/*
 * Decompiled with CFR 0.152.
 */
package bl4ckscor3.mod.ceilingtorch;

import bl4ckscor3.mod.ceilingtorch.compat.vanilla.BlockCeilingTorch;
import java.util.HashMap;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="ceilingtorch")
public class PlaceHandler {
    private static final HashMap<ResourceLocation, IBlockState> PLACE_ENTRIES = new HashMap();

    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        EnumHand actualHand = EnumHand.values()[(event.getHand().ordinal() + 1) % 2];
        ItemStack held = event.getEntityPlayer().func_184586_b(actualHand);
        ResourceLocation rl = held.func_77973_b().getRegistryName();
        if (PLACE_ENTRIES.containsKey(rl)) {
            PlaceHandler.placeTorch(event, actualHand, held, PLACE_ENTRIES.get(rl));
        }
    }

    private static void placeTorch(PlayerInteractEvent.RightClickBlock event, EnumHand actualHand, ItemStack held, IBlockState state) {
        BlockPos pos = event.getPos();
        EnumFacing face = event.getFace();
        BlockPos placeAt = pos.func_177972_a(face);
        World world = event.getWorld();
        if (face == EnumFacing.DOWN && world.func_175623_d(placeAt) && BlockCeilingTorch.canPlaceAt(world, placeAt, EnumFacing.DOWN)) {
            world.func_175656_a(placeAt, state);
            SoundType soundType = state.func_177230_c().getSoundType(state, world, pos, (Entity)event.getEntityPlayer());
            world.func_184148_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), soundType.func_185841_e(), SoundCategory.BLOCKS, soundType.func_185843_a(), soundType.func_185847_b() - 0.2f);
            event.getEntityPlayer().func_184609_a(actualHand);
            if (!event.getEntityPlayer().func_184812_l_()) {
                held.func_190918_g(1);
            }
        }
    }

    public static void registerPlaceEntry(ResourceLocation itemName, IBlockState ceilingTorchState) {
        if (!PLACE_ENTRIES.containsKey(itemName)) {
            PLACE_ENTRIES.put(itemName, ceilingTorchState);
        }
    }
}

