/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.client.gui.component.container;

import com.google.common.eventbus.Subscribe;
import net.malisis.core.client.gui.Anchor;
import net.malisis.core.client.gui.GuiRenderer;
import net.malisis.core.client.gui.MalisisGui;
import net.malisis.core.client.gui.component.UIComponent;
import net.malisis.core.client.gui.component.container.BasicContainer;
import net.malisis.core.client.gui.component.container.UIContainer;
import net.malisis.core.client.gui.component.decoration.BasicLine;
import net.malisis.core.client.gui.component.interaction.UIButton;
import net.malisis.core.client.gui.component.interaction.button.BasicSimpleButton;
import net.malisis.core.renderer.font.FontOptions;
import net.malisis.core.util.FontColors;
import net.malisis.core.util.MouseButton;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class BasicForm
extends BasicContainer<BasicForm> {
    private BasicContainer<?> titleContainer;
    private BasicLine line;
    private BasicSimpleButton closeButton;
    private boolean closable;
    private boolean movable;
    private boolean dragging;

    public BasicForm(MalisisGui gui, int width, int height) {
        this(gui, width, height, "");
    }

    public BasicForm(MalisisGui gui, int width, int height, String title) {
        super(gui, title, width, height);
        this.setAnchor(Anchor.CENTER | Anchor.MIDDLE);
        this.setMovable(true);
        this.setBorder(0xFFFFFF, 1, 185);
        this.setBackgroundAlpha(215);
        this.setColor(Integer.MIN_VALUE);
        this.setPadding(3, 20, 3, 3);
        this.construct(gui);
        this.setClosable(true);
    }

    private void construct(MalisisGui gui) {
        this.titleContainer = new BasicContainer(gui);
        this.titleContainer.setPosition(-this.getLeftBorderedPadding(), -19, Anchor.TOP | Anchor.LEFT);
        this.titleContainer.setSize(this.getWidth() - this.getRightBorderedPadding(), 15);
        this.titleContainer.setColor(0x363636);
        this.titleContainer.setBackgroundAlpha(215);
        this.add(this.titleContainer);
        this.line = new BasicLine(gui, this.getWidth() + this.getLeftBorderedPadding() + this.getRightBorderedPadding());
        this.line.setPosition(-this.getLeftBorderedPadding(), -4);
        this.add(this.line);
        this.closeButton = new BasicSimpleButton(this.getGui(), "x");
        this.closeButton.setName("button.form.close");
        this.closeButton.setPosition(0, 0, Anchor.MIDDLE | Anchor.RIGHT);
        this.closeButton.register(this);
        if (this.titleLabel != null) {
            this.remove(this.titleLabel);
            this.titleContainer.add(this.titleLabel);
            this.titleLabel.setFontOptions(FontColors.WHITE_FO.toBuilder().shadow(false).build());
            this.titleLabel.setPosition(0, 1, Anchor.MIDDLE | Anchor.CENTER);
        }
    }

    public boolean isClosable() {
        return this.closable;
    }

    public BasicForm setClosable(boolean closable) {
        this.closable = closable;
        if (closable) {
            this.titleContainer.add(this.closeButton);
        } else {
            this.titleContainer.remove(this.closeButton);
        }
        return this;
    }

    public boolean isMovable() {
        return this.movable;
    }

    public BasicForm setMovable(boolean movable) {
        this.movable = movable;
        return this;
    }

    public void setTitle(String text, FontOptions options) {
        super.setTitle(text);
        this.titleLabel.setFontOptions(options);
    }

    @Override
    public void onClose() {
        MalisisGui currentGui = this.getGui();
        if (currentGui != null) {
            if (currentGui.isOverlay()) {
                currentGui.closeOverlay();
            } else {
                currentGui.close();
            }
        }
    }

    private int getLeftBorderedPadding() {
        return this.getLeftPadding() - this.getLeftBorderSize();
    }

    private int getRightBorderedPadding() {
        return this.getRightPadding() - this.getRightBorderSize();
    }

    @Override
    public boolean onButtonPress(int x, int y, MouseButton button) {
        this.dragging = !this.closeButton.isInsideBounds(x, y) && this.titleContainer.isInsideBounds(x, y);
        return super.onButtonPress(x, y, button);
    }

    @Override
    public boolean onButtonRelease(int x, int y, MouseButton button) {
        if (button == MouseButton.LEFT && this.dragging) {
            this.dragging = false;
        }
        return super.onButtonRelease(x, y, button);
    }

    @Override
    public boolean onDrag(int lastX, int lastY, int x, int y, MouseButton button) {
        if (!this.movable || !this.dragging) {
            return super.onDrag(lastX, lastY, x, y, button);
        }
        UIComponent<?> parentContainer = this.getParent();
        if (parentContainer == null) {
            return super.onDrag(lastX, lastY, x, y, button);
        }
        int xPos = this.getParent().relativeX(x) - this.relativeX(lastX);
        int yPos = this.getParent().relativeY(y) - this.relativeY(lastY);
        int targetX = Math.min(parentContainer.getWidth() - this.width, Math.max(xPos, 0));
        int targetY = Math.min(parentContainer.getHeight() - this.height, Math.max(yPos, 0));
        this.setPosition(targetX, targetY, Anchor.NONE);
        return true;
    }

    @Override
    public BasicForm setSize(int width, int height) {
        super.setSize(width, height);
        if (this.line != null) {
            this.line.setWidth(this.getWidth() + this.getLeftBorderedPadding() + this.getRightBorderedPadding());
        }
        if (this.titleContainer != null) {
            this.titleContainer.setSize(this.getWidth() - this.getRightBorderedPadding(), 15);
        }
        return this;
    }

    @Subscribe
    public void onButtonClick(UIButton.ClickEvent event) {
        if ("button.form.close".equals(((UIButton)event.getComponent()).getName().toLowerCase()) && this.closeButton.isInsideBounds(event.getX(), event.getY())) {
            this.onClose();
            if (this.getParent() instanceof UIContainer) {
                ((UIContainer)this.getParent()).remove(this);
            }
        }
    }

    @Override
    public void drawBackground(GuiRenderer renderer, int mouseX, int mouseY, float partialTick) {
        super.drawBackground(renderer, mouseX, mouseY, partialTick);
    }

    @Override
    public void drawForeground(GuiRenderer renderer, int mouseX, int mouseY, float partialTick) {
        super.drawForeground(renderer, mouseX, mouseY, partialTick);
        this.closeButton.setFontOptions(this.closeButton.isInsideBounds(mouseX, mouseY) ? FontColors.WHITE_FO : FontColors.GRAY_FO);
    }
}

