/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.entity;

import com.mrcrayfish.vehicle.VehicleMod;
import com.mrcrayfish.vehicle.entity.EngineTier;
import com.mrcrayfish.vehicle.entity.EntityPoweredVehicle;
import com.mrcrayfish.vehicle.network.PacketHandler;
import com.mrcrayfish.vehicle.network.message.MessageFlaps;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public abstract class EntityPlane
extends EntityPoweredVehicle {
    private static final DataParameter<Integer> FLAP_DIRECTION = EntityDataManager.func_187226_a(EntityPlane.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Float> LIFT = EntityDataManager.func_187226_a(EntityPlane.class, (DataSerializer)DataSerializers.field_187193_c);
    private float lift;
    public float prevBodyRotationX;
    public float prevBodyRotationY;
    public float prevBodyRotationZ;
    public float bodyRotationX;
    public float bodyRotationY;
    public float bodyRotationZ;

    protected EntityPlane(World worldIn) {
        super(worldIn);
        this.setAccelerationSpeed(0.5f);
        this.setMaxSpeed(25.0f);
        this.setTurnSensitivity(5);
    }

    @Override
    public void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(FLAP_DIRECTION, (Object)FlapDirection.NONE.ordinal());
        this.field_70180_af.func_187214_a(LIFT, (Object)Float.valueOf(0.0f));
    }

    @Override
    public void updateVehicleMotion() {
        float f1 = MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))) / 20.0f;
        float f2 = MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180))) / 20.0f;
        this.updateLift();
        this.vehicleMotionX = -this.currentSpeed * f1;
        this.vehicleMotionZ = this.currentSpeed * f2;
        this.field_70181_x += (double)this.lift;
        this.field_70181_x -= 0.05;
    }

    @Override
    public void onClientUpdate() {
        super.onClientUpdate();
        this.prevBodyRotationX = this.bodyRotationX;
        this.prevBodyRotationY = this.bodyRotationY;
        this.prevBodyRotationZ = this.bodyRotationZ;
        EntityLivingBase entity = (EntityLivingBase)this.func_184179_bs();
        if (entity != null && entity.equals((Object)Minecraft.func_71410_x().field_71439_g)) {
            FlapDirection flapDirection = VehicleMod.proxy.getFlapDirection();
            if (this.getFlapDirection() != flapDirection) {
                this.setFlapDirection(flapDirection);
                PacketHandler.INSTANCE.sendToServer((IMessage)new MessageFlaps(flapDirection));
            }
        }
        if (this.isFlying()) {
            this.bodyRotationX = (float)Math.toDegrees(Math.atan2(this.field_70181_x, this.currentSpeed / 20.0f));
            this.bodyRotationZ = this.turnAngle / (float)this.getMaxTurnAngle() * 20.0f;
        } else {
            this.bodyRotationX *= 0.5f;
            this.bodyRotationZ *= 0.5f;
        }
    }

    @Override
    protected void updateSpeed() {
        this.lift = 0.0f;
        this.currentSpeed = this.getSpeed();
        if (this.func_184179_bs() != null) {
            EntityPoweredVehicle.AccelerationDirection acceleration = this.getAcceleration();
            if (this.canDrive() && acceleration == EntityPoweredVehicle.AccelerationDirection.FORWARD) {
                if (this.field_70181_x < 0.0) {
                    this.field_70181_x *= 0.95;
                }
                EngineTier engineTier = this.getEngineTier();
                float accelerationSpeed = this.getModifiedAccelerationSpeed() * engineTier.getAccelerationMultiplier();
                if (this.currentSpeed < this.getActualMaxSpeed()) {
                    this.currentSpeed += accelerationSpeed;
                }
                this.lift = 0.051f * (Math.min(this.currentSpeed, 15.0f) / 15.0f);
            } else if (acceleration == EntityPoweredVehicle.AccelerationDirection.REVERSE) {
                this.currentSpeed = this.isFlying() ? (this.currentSpeed *= 0.95f) : (this.currentSpeed *= 0.9f);
            }
            if (acceleration != EntityPoweredVehicle.AccelerationDirection.FORWARD) {
                this.currentSpeed = this.isFlying() ? (this.currentSpeed *= 0.995f) : (this.currentSpeed *= 0.98f);
                this.lift = 0.04f * (Math.min(this.currentSpeed, 15.0f) / 15.0f);
            }
        } else {
            this.currentSpeed = this.isFlying() ? (this.currentSpeed *= 0.98f) : (this.currentSpeed *= 0.85f);
        }
    }

    @Override
    protected void updateTurning() {
        EntityPoweredVehicle.TurnDirection direction = this.getTurnDirection();
        if (this.func_184179_bs() != null && direction != EntityPoweredVehicle.TurnDirection.FORWARD) {
            this.turnAngle += (float)(direction.dir * this.getTurnSensitivity());
            if (Math.abs(this.turnAngle) > (float)this.getMaxTurnAngle()) {
                this.turnAngle = this.getMaxTurnAngle() * direction.dir;
            }
        } else {
            this.turnAngle = (float)((double)this.turnAngle * 0.95);
        }
        this.wheelAngle = this.isFlying() ? this.turnAngle * Math.max(0.25f, 1.0f - Math.abs(Math.min(this.currentSpeed, 30.0f) / 30.0f)) : this.turnAngle * Math.abs(Math.min(this.currentSpeed, 30.0f) / 30.0f);
        this.deltaYaw = this.wheelAngle;
        this.deltaYaw = this.isFlying() ? (float)((double)this.deltaYaw * 0.5) : (float)((double)this.deltaYaw * (0.5 * (0.5 + 0.5 * (double)(1.0f - Math.min(this.currentSpeed, 15.0f) / 15.0f))));
    }

    public void updateLift() {
        FlapDirection flapDirection = this.getFlapDirection();
        if (flapDirection == FlapDirection.UP) {
            this.lift += 0.04f * (Math.min(Math.max(this.currentSpeed - 5.0f, 0.0f), 15.0f) / 15.0f);
        } else if (flapDirection == FlapDirection.DOWN) {
            this.lift -= 0.06f * (Math.min(this.currentSpeed, 15.0f) / 15.0f);
        }
        this.setLift(this.lift);
    }

    public NBTTagCompound func_189511_e(NBTTagCompound compound) {
        super.func_189511_e(compound);
        compound.func_74768_a("flapDirection", this.getFlapDirection().ordinal());
        compound.func_74776_a("lift", this.getLift());
        return compound;
    }

    @Override
    protected void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (compound.func_150297_b("flapDirection", 3)) {
            this.setFlapDirection(FlapDirection.values()[compound.func_74762_e("flapDirection")]);
        }
        if (compound.func_150297_b("lift", 5)) {
            this.setLift(compound.func_74760_g("lift"));
        }
    }

    public void setFlapDirection(FlapDirection flapDirection) {
        this.field_70180_af.func_187227_b(FLAP_DIRECTION, (Object)flapDirection.ordinal());
    }

    public FlapDirection getFlapDirection() {
        return FlapDirection.values()[(Integer)this.field_70180_af.func_187225_a(FLAP_DIRECTION)];
    }

    public float getLift() {
        return ((Float)this.field_70180_af.func_187225_a(LIFT)).floatValue();
    }

    public void setLift(float lift) {
        this.field_70180_af.func_187227_b(LIFT, (Object)Float.valueOf(lift));
    }

    public boolean isFlying() {
        return !this.field_70122_E;
    }

    @Override
    public void func_180430_e(float distance, float damageMultiplier) {
    }

    @Override
    public boolean canChangeWheels() {
        return false;
    }

    public static enum FlapDirection {
        UP,
        DOWN,
        NONE;


        public static FlapDirection fromInput(boolean up, boolean down) {
            return up && !down ? UP : (down && !up ? DOWN : NONE);
        }
    }
}

