/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.entity;

import com.google.common.collect.ImmutableList;
import com.mrcrayfish.vehicle.VehicleConfig;
import com.mrcrayfish.vehicle.block.BlockVehicleCrate;
import com.mrcrayfish.vehicle.common.Seat;
import com.mrcrayfish.vehicle.common.SeatTracker;
import com.mrcrayfish.vehicle.common.entity.PartPosition;
import com.mrcrayfish.vehicle.common.entity.SyncedPlayerData;
import com.mrcrayfish.vehicle.crafting.VehicleRecipes;
import com.mrcrayfish.vehicle.entity.EntityJack;
import com.mrcrayfish.vehicle.entity.EntityTrailer;
import com.mrcrayfish.vehicle.entity.VehicleProperties;
import com.mrcrayfish.vehicle.init.ModItems;
import com.mrcrayfish.vehicle.init.ModSounds;
import com.mrcrayfish.vehicle.item.ItemSprayCan;
import com.mrcrayfish.vehicle.util.InventoryUtil;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.play.server.SPacketAnimation;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class EntityVehicle
extends Entity
implements IEntityAdditionalSpawnData {
    public static final int[] DYE_TO_COLOR = new int[]{0xF9FFFE, 16351261, 13061821, 3847130, 16701501, 8439583, 15961002, 4673362, 0x9D9D97, 1481884, 8991416, 3949738, 8606770, 6192150, 11546150, 0x1D1D21};
    protected static final DataParameter<Integer> COLOR = EntityDataManager.func_187226_a(EntityVehicle.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> TIME_SINCE_HIT = EntityDataManager.func_187226_a(EntityVehicle.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Float> MAX_HEALTH = EntityDataManager.func_187226_a(EntityVehicle.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> HEALTH = EntityDataManager.func_187226_a(EntityVehicle.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Integer> TRAILER = EntityDataManager.func_187226_a(EntityVehicle.class, (DataSerializer)DataSerializers.field_187192_b);
    protected UUID trailerId;
    protected EntityTrailer trailer = null;
    private int searchDelay = 0;
    protected int lerpSteps;
    protected double lerpX;
    protected double lerpY;
    protected double lerpZ;
    protected double lerpYaw;
    protected double lerpPitch;
    protected SeatTracker seatTracker = new SeatTracker(this);

    public EntityVehicle(World worldIn) {
        super(worldIn);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(TIME_SINCE_HIT, (Object)0);
        this.field_70180_af.func_187214_a(MAX_HEALTH, (Object)Float.valueOf(100.0f));
        this.field_70180_af.func_187214_a(HEALTH, (Object)Float.valueOf(100.0f));
        this.field_70180_af.func_187214_a(COLOR, (Object)0xF9FFFE);
        this.field_70180_af.func_187214_a(TRAILER, (Object)-1);
        if (this.field_70170_p.field_72995_K) {
            this.onClientInit();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void onClientInit() {
    }

    protected final void func_180429_a(BlockPos pos, Block blockIn) {
    }

    public AxisAlignedBB func_184177_bl() {
        return this.func_174813_aQ().func_186662_g(1.0);
    }

    public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
        if (!this.field_70170_p.field_72995_K && !player.func_70093_af()) {
            int trailerId = SyncedPlayerData.getTrailer(player);
            if (trailerId != -1) {
                Entity entity;
                if (this.func_184187_bx() == null && this.canTowTrailer() && this.getTrailer() == null && (entity = this.field_70170_p.func_73045_a(trailerId)) instanceof EntityTrailer && entity != this) {
                    EntityTrailer trailer = (EntityTrailer)entity;
                    this.setTrailer(trailer);
                    SyncedPlayerData.setTrailer(player, -1);
                }
                return true;
            }
            ItemStack heldItem = player.func_184586_b(hand);
            if (heldItem.func_77973_b() == ModItems.SPRAY_CAN) {
                if (this.canBeColored()) {
                    NBTTagCompound tagCompound = ItemSprayCan.createTagCompound(heldItem);
                    int remainingSprays = tagCompound.func_74762_e("remainingSprays");
                    if (tagCompound.func_150297_b("color", 3) && remainingSprays > 0) {
                        int color = tagCompound.func_74762_e("color");
                        if (this.getColor() != color) {
                            this.setColor(tagCompound.func_74762_e("color"));
                            player.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, ModSounds.SPRAY_CAN_SPRAY, SoundCategory.PLAYERS, 1.0f, 1.0f);
                            tagCompound.func_74768_a("remainingSprays", remainingSprays - 1);
                        }
                    }
                }
            } else {
                if (heldItem.func_77973_b() == ModItems.HAMMER && this.func_184187_bx() instanceof EntityJack) {
                    if (this.getHealth() < this.getMaxHealth()) {
                        heldItem.func_77972_a(1, (EntityLivingBase)player);
                        this.setHealth(this.getHealth() + 5.0f);
                        this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, ModSounds.VEHICLE_THUD, SoundCategory.PLAYERS, 1.0f, 0.8f + 0.4f * this.field_70146_Z.nextFloat());
                        player.func_184609_a(hand);
                        if (player instanceof EntityPlayerMP) {
                            ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)new SPacketAnimation((Entity)player, hand == EnumHand.MAIN_HAND ? 0 : 3));
                        }
                        if (this.getHealth() == this.getMaxHealth()) {
                            if (this.field_70170_p instanceof WorldServer) {
                                int count = (int)(50.0f * (this.field_70130_N * this.field_70131_O));
                                for (int i = 0; i < count; ++i) {
                                    double width = this.field_70130_N * 2.0f;
                                    double height = (double)this.field_70131_O * 1.5;
                                    Vec3d heldOffset = this.getProperties().getHeldOffset().func_178785_b((float)Math.toRadians(-this.field_70177_z));
                                    double x = this.field_70165_t + width * (double)this.field_70146_Z.nextFloat() - width / 2.0 + heldOffset.field_72449_c * 0.0625;
                                    double y = this.field_70163_u + height * (double)this.field_70146_Z.nextFloat();
                                    double z = this.field_70161_v + width * (double)this.field_70146_Z.nextFloat() - width / 2.0 + heldOffset.field_72450_a * 0.0625;
                                    double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                                    double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                                    double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                                    ((WorldServer)this.field_70170_p).func_175739_a(EnumParticleTypes.VILLAGER_HAPPY, x, y, z, 1, d0, d1, d2, 1.0, new int[0]);
                                }
                            }
                            this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187802_ec, SoundCategory.PLAYERS, 1.0f, 1.5f);
                        }
                    }
                    return true;
                }
                if (this.func_184228_n((Entity)player)) {
                    int seatIndex = this.seatTracker.getClosestAvailableSeatToPlayer(player);
                    if (seatIndex != -1 && player.func_184220_m((Entity)this)) {
                        this.getSeatTracker().setSeatIndex(seatIndex, player.func_110124_au());
                    }
                    return true;
                }
            }
        }
        return true;
    }

    protected void func_70037_a(NBTTagCompound compound) {
        if (compound.func_150297_b("color", 11)) {
            int[] c = compound.func_74759_k("color");
            if (c.length == 3) {
                int color = (c[0] & 0xFF) << 16 | (c[1] & 0xFF) << 8 | c[2] & 0xFF;
                this.setColor(color);
            }
        } else if (compound.func_150297_b("color", 3)) {
            int index = compound.func_74762_e("color");
            if (index >= 0 && index < DYE_TO_COLOR.length) {
                this.setColor(DYE_TO_COLOR[index]);
            }
            compound.func_82580_o("color");
        }
        if (compound.func_150297_b("maxHealth", 5)) {
            this.setMaxHealth(compound.func_74760_g("maxHealth"));
        }
        if (compound.func_150297_b("health", 5)) {
            this.setHealth(compound.func_74760_g("health"));
        }
        if (compound.func_186855_b("trailer")) {
            this.trailerId = compound.func_186857_a("trailer");
        }
        if (compound.func_150297_b("SeatTracker", 10)) {
            this.seatTracker.read(compound.func_74775_l("SeatTracker"));
        }
    }

    protected void func_70014_b(NBTTagCompound compound) {
        compound.func_74783_a("color", this.getColorRGB());
        compound.func_74776_a("maxHealth", this.getMaxHealth());
        compound.func_74776_a("health", this.getHealth());
        if (this.trailerId != null) {
            compound.func_186854_a("trailer", this.trailerId);
        }
        compound.func_74782_a("SeatTracker", (NBTBase)this.seatTracker.write());
    }

    public void func_70071_h_() {
        if (this.getTimeSinceHit() > 0) {
            this.setTimeSinceHit(this.getTimeSinceHit() - 1);
        }
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        if (!this.field_70170_p.field_72995_K) {
            if (this.searchDelay <= 0) {
                if (this.trailer != null) {
                    this.field_70180_af.func_187217_b(TRAILER);
                    this.trailer.func_184212_Q().func_187217_b(EntityTrailer.PULLING_ENTITY);
                    this.searchDelay = VehicleConfig.SERVER.trailerSyncCooldown;
                } else {
                    this.findTrailer();
                }
            } else {
                --this.searchDelay;
            }
        }
        if (this.field_70170_p.field_72995_K) {
            int entityId = (Integer)this.field_70180_af.func_187225_a(TRAILER);
            if (entityId != -1) {
                Entity entity = this.field_70170_p.func_73045_a(((Integer)this.field_70180_af.func_187225_a(TRAILER)).intValue());
                if (entity instanceof EntityTrailer) {
                    this.trailer = (EntityTrailer)entity;
                    this.trailerId = this.trailer.func_110124_au();
                } else if (this.trailer != null) {
                    this.trailer = null;
                    this.trailerId = null;
                }
            } else if (this.trailer != null) {
                this.trailer = null;
                this.trailerId = null;
            }
        }
        if (!this.field_70170_p.field_72995_K && this.trailer != null && (this.trailer.field_70128_L || this.trailer.getPullingEntity() != this)) {
            this.setTrailer(null);
        }
        super.func_70071_h_();
        this.tickLerp();
        this.onUpdateVehicle();
    }

    private void findTrailer() {
        if (!this.field_70170_p.field_72995_K && this.trailerId != null && this.trailer == null) {
            WorldServer server = (WorldServer)this.field_70170_p;
            Entity entity = server.func_175733_a(this.trailerId);
            if (entity instanceof EntityTrailer) {
                this.setTrailer((EntityTrailer)entity);
                return;
            }
            this.trailerId = null;
        }
    }

    protected abstract void onUpdateVehicle();

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        if (!this.field_70170_p.field_72995_K && !this.field_70128_L) {
            boolean isCreativeMode;
            Entity trueSource = source.func_76346_g();
            if (source instanceof EntityDamageSourceIndirect && trueSource != null && this.func_184196_w(trueSource)) {
                return false;
            }
            if (VehicleConfig.SERVER.vehicleDamage) {
                this.setTimeSinceHit(10);
                this.setHealth(this.getHealth() - amount);
            }
            boolean bl = isCreativeMode = trueSource instanceof EntityPlayer && ((EntityPlayer)trueSource).field_71075_bZ.field_75098_d;
            if (isCreativeMode || this.getHealth() < 0.0f) {
                this.onVehicleDestroyed((EntityLivingBase)trueSource);
                this.func_70106_y();
            }
            return true;
        }
        return true;
    }

    public void func_180430_e(float distance, float damageMultiplier) {
        if (VehicleConfig.SERVER.vehicleDamage && distance >= 4.0f && this.field_70181_x < -1.0) {
            float damage = distance / 2.0f;
            this.func_70097_a(DamageSource.field_76379_h, damage);
            this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, ModSounds.VEHICLE_IMPACT, SoundCategory.AMBIENT, 1.0f, 1.0f);
        }
    }

    protected void onVehicleDestroyed(EntityLivingBase entity) {
        VehicleRecipes.VehicleRecipe recipe;
        boolean isCreativeMode;
        this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, ModSounds.VEHICLE_DESTROYED, SoundCategory.AMBIENT, 1.0f, 0.5f);
        boolean bl = isCreativeMode = entity instanceof EntityPlayer && ((EntityPlayer)entity).field_71075_bZ.field_75098_d;
        if (!isCreativeMode && this.field_70170_p.func_82736_K().func_82766_b("doEntityDrops") && (recipe = VehicleRecipes.getRecipe(((Object)((Object)this)).getClass())) != null) {
            ImmutableList<ItemStack> materials = recipe.getMaterials();
            for (ItemStack stack : materials) {
                ItemStack copy = stack.func_77946_l();
                int shrink = copy.func_190916_E() / 2;
                if (shrink > 0) {
                    copy.func_190918_g(this.field_70146_Z.nextInt(shrink + 1));
                }
                InventoryUtil.spawnItemStack(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, copy);
            }
        }
    }

    public int getDestroyedStage() {
        return 10 - (int)Math.max(1.0f, (float)((int)Math.ceil(10.0f * (this.getHealth() / this.getMaxHealth()))));
    }

    private void tickLerp() {
        if (this.lerpSteps > 0 && !this.func_184186_bw()) {
            double d0 = this.field_70165_t + (this.lerpX - this.field_70165_t) / (double)this.lerpSteps;
            double d1 = this.field_70163_u + (this.lerpY - this.field_70163_u) / (double)this.lerpSteps;
            double d2 = this.field_70161_v + (this.lerpZ - this.field_70161_v) / (double)this.lerpSteps;
            double d3 = MathHelper.func_76138_g((double)(this.lerpYaw - (double)this.field_70177_z));
            this.field_70177_z = (float)((double)this.field_70177_z + d3 / (double)this.lerpSteps);
            this.field_70125_A = (float)((double)this.field_70125_A + (this.lerpPitch - (double)this.field_70125_A) / (double)this.lerpSteps);
            --this.lerpSteps;
            this.func_70107_b(d0, d1, d2);
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180426_a(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        this.lerpX = x;
        this.lerpY = y;
        this.lerpZ = z;
        this.lerpYaw = yaw;
        this.lerpPitch = pitch;
        this.lerpSteps = 10;
    }

    protected boolean func_184228_n(Entity entityIn) {
        return true;
    }

    public void func_184200_o(Entity passenger) {
        super.func_184200_o(passenger);
        if (this.func_184186_bw() && this.lerpSteps > 0) {
            this.lerpSteps = 0;
            this.field_70165_t = this.lerpX;
            this.field_70163_u = this.lerpY;
            this.field_70161_v = this.lerpZ;
            this.field_70177_z = (float)this.lerpYaw;
            this.field_70125_A = (float)this.lerpPitch;
        }
    }

    protected void applyYawToEntity(Entity passenger) {
        int seatIndex = this.getSeatTracker().getSeatIndex(passenger.func_110124_au());
        if (seatIndex != -1) {
            VehicleProperties properties = this.getProperties();
            Seat seat = properties.getSeats().get(seatIndex);
            passenger.func_181013_g(this.getModifiedRotationYaw() + seat.getYawOffset());
            float f = MathHelper.func_76142_g((float)(passenger.field_70177_z - this.getModifiedRotationYaw() + seat.getYawOffset()));
            float f1 = MathHelper.func_76131_a((float)f, (float)-120.0f, (float)120.0f);
            passenger.field_70126_B += f1 - f;
            passenger.field_70177_z += f1 - f;
            passenger.func_70034_d(passenger.field_70177_z);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_184190_l(Entity entityToUpdate) {
        this.applyYawToEntity(entityToUpdate);
    }

    public void func_70024_g(double x, double y, double z) {
    }

    public void setTimeSinceHit(int timeSinceHit) {
        this.field_70180_af.func_187227_b(TIME_SINCE_HIT, (Object)timeSinceHit);
    }

    public int getTimeSinceHit() {
        return (Integer)this.field_70180_af.func_187225_a(TIME_SINCE_HIT);
    }

    public void setMaxHealth(float maxHealth) {
        this.field_70180_af.func_187227_b(MAX_HEALTH, (Object)Float.valueOf(maxHealth));
    }

    public float getMaxHealth() {
        return ((Float)this.field_70180_af.func_187225_a(MAX_HEALTH)).floatValue();
    }

    public void setHealth(float health) {
        this.field_70180_af.func_187227_b(HEALTH, (Object)Float.valueOf(Math.min(this.getMaxHealth(), health)));
    }

    public float getHealth() {
        return ((Float)this.field_70180_af.func_187225_a(HEALTH)).floatValue();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70057_ab() {
        this.setTimeSinceHit(10);
    }

    public boolean canBeColored() {
        return false;
    }

    public void setColor(int color) {
        if (this.canBeColored()) {
            this.field_70180_af.func_187227_b(COLOR, (Object)color);
        }
    }

    public void setColorRGB(int r, int g, int b) {
        int color = (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
        this.field_70180_af.func_187227_b(COLOR, (Object)color);
    }

    public int getColor() {
        return (Integer)this.field_70180_af.func_187225_a(COLOR);
    }

    public int[] getColorRGB() {
        int color = (Integer)this.field_70180_af.func_187225_a(COLOR);
        return new int[]{color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF};
    }

    public boolean canMountTrailer() {
        return true;
    }

    public Vec3d getPartPositionAbsoluteVec(PartPosition position, float partialTicks) {
        VehicleProperties properties = this.getProperties();
        PartPosition bodyPosition = properties.getBodyPosition();
        Vec3d partVec = Vec3d.field_186680_a;
        partVec = partVec.func_72441_c(0.0, 0.5, 0.0);
        partVec = partVec.func_186678_a(position.getScale());
        partVec = partVec.func_72441_c(0.0, -0.5, 0.0);
        partVec = partVec.func_72441_c(position.getX() * 0.0625, position.getY() * 0.0625, position.getZ() * 0.0625);
        partVec = partVec.func_72441_c(0.0, (double)properties.getWheelOffset() * 0.0625, 0.0);
        partVec = partVec.func_72441_c(0.0, (double)properties.getAxleOffset() * 0.0625, 0.0);
        partVec = partVec.func_72441_c(0.0, 0.5, 0.0);
        partVec = partVec.func_186678_a(bodyPosition.getScale());
        partVec = partVec.func_72441_c(0.0, -0.5, 0.0);
        partVec = partVec.func_72441_c(0.0, 0.5, 0.0);
        partVec = partVec.func_72441_c(bodyPosition.getX(), bodyPosition.getY(), bodyPosition.getZ());
        partVec = partVec.func_178785_b(-(this.field_70126_B + (this.field_70177_z - this.field_70126_B) * partialTicks) * ((float)Math.PI / 180));
        partVec = partVec.func_72441_c(this.field_70169_q + (this.field_70165_t - this.field_70169_q) * (double)partialTicks, 0.0, 0.0);
        partVec = partVec.func_72441_c(0.0, this.field_70167_r + (this.field_70163_u - this.field_70167_r) * (double)partialTicks, 0.0);
        partVec = partVec.func_72441_c(0.0, 0.0, this.field_70166_s + (this.field_70161_v - this.field_70166_s) * (double)partialTicks);
        return partVec;
    }

    protected static AxisAlignedBB createScaledBoundingBox(double x1, double y1, double z1, double x2, double y2, double z2, double scale) {
        return new AxisAlignedBB(x1 * scale, y1 * scale, z1 * scale, x2 * scale, y2 * scale, z2 * scale);
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeFloat(this.field_70177_z);
        this.seatTracker.write(buffer);
    }

    public void readSpawnData(ByteBuf buffer) {
        this.field_70177_z = this.field_70126_B = buffer.readFloat();
        this.seatTracker.read(buffer);
    }

    public boolean canTowTrailer() {
        return false;
    }

    public void setTrailer(EntityTrailer trailer) {
        if (trailer != null) {
            this.trailer = trailer;
            this.trailerId = trailer.func_110124_au();
            trailer.setPullingEntity(this);
            this.field_70180_af.func_187227_b(TRAILER, (Object)trailer.func_145782_y());
        } else {
            if (this.trailer != null && this.trailer.getPullingEntity() == this) {
                this.trailer.setPullingEntity(null);
            }
            this.trailer = null;
            this.trailerId = null;
            this.field_70180_af.func_187227_b(TRAILER, (Object)-1);
        }
    }

    @Nullable
    public UUID getTrailerId() {
        return this.trailerId;
    }

    @Nullable
    public EntityTrailer getTrailer() {
        return this.trailer;
    }

    public VehicleProperties getProperties() {
        return VehicleProperties.getProperties(((Object)((Object)this)).getClass());
    }

    public float getModifiedRotationYaw() {
        return this.field_70177_z;
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        ResourceLocation entityId = EntityList.func_191301_a((Entity)this);
        return BlockVehicleCrate.create(entityId, this.getColor(), null, null, -1);
    }

    public SeatTracker getSeatTracker() {
        return this.seatTracker;
    }

    protected boolean func_184219_q(Entity passenger) {
        return this.func_184188_bt().size() < this.getProperties().getSeats().size();
    }

    public void func_184232_k(Entity passenger) {
        super.func_184232_k(passenger);
        this.updatePassengerPosition(passenger);
    }

    protected void updatePassengerPosition(Entity passenger) {
        int seatIndex;
        if (this.func_184196_w(passenger) && (seatIndex = this.getSeatTracker().getSeatIndex(passenger.func_110124_au())) != -1) {
            VehicleProperties properties = this.getProperties();
            if (seatIndex >= 0 && seatIndex < properties.getSeats().size()) {
                Seat seat = properties.getSeats().get(seatIndex);
                Vec3d seatVec = seat.getPosition().func_72441_c(0.0, (double)(properties.getAxleOffset() + properties.getWheelOffset()), 0.0).func_186678_a(properties.getBodyPosition().getScale()).func_178785_b(-this.getModifiedRotationYaw() * ((float)Math.PI / 180) - 1.5707964f);
                passenger.func_70107_b(this.field_70165_t + seatVec.field_72450_a, this.field_70163_u + seatVec.field_72448_b, this.field_70161_v + seatVec.field_72449_c);
                this.applyYawToEntity(passenger);
            }
        }
    }
}

