/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import de.ellpeck.actuallyadditions.api.laser.IConnectionPair;
import de.ellpeck.actuallyadditions.api.laser.LaserType;
import de.ellpeck.actuallyadditions.api.laser.Network;
import de.ellpeck.actuallyadditions.mod.config.values.ConfigBoolValues;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityBase;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityLaserRelay;
import de.ellpeck.actuallyadditions.mod.util.StringUtil;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityLaserRelayEnergy
extends TileEntityLaserRelay {
    public static final int CAP = 1000;
    public final ConcurrentHashMap<EnumFacing, TileEntity> receiversAround = new ConcurrentHashMap();
    private final IEnergyStorage[] energyStorages = new IEnergyStorage[6];
    private Mode mode = Mode.BOTH;

    public TileEntityLaserRelayEnergy(String name) {
        super(name, LaserType.ENERGY);
        for (int i = 0; i < this.energyStorages.length; ++i) {
            final EnumFacing facing = EnumFacing.values()[i];
            this.energyStorages[i] = new IEnergyStorage(){

                public int receiveEnergy(int amount, boolean simulate) {
                    return TileEntityLaserRelayEnergy.this.transmitEnergy(facing, amount, simulate);
                }

                public int extractEnergy(int maxExtract, boolean simulate) {
                    return 0;
                }

                public int getEnergyStored() {
                    return 0;
                }

                public int getMaxEnergyStored() {
                    return TileEntityLaserRelayEnergy.this.getEnergyCap();
                }

                public boolean canExtract() {
                    return false;
                }

                public boolean canReceive() {
                    return true;
                }
            };
        }
    }

    public TileEntityLaserRelayEnergy() {
        this("laserRelay");
    }

    private int transmitEnergy(EnumFacing from, int maxTransmit, boolean simulate) {
        Network network;
        int transmitted = 0;
        if (maxTransmit > 0 && this.mode != Mode.OUTPUT_ONLY && (network = this.getNetwork()) != null) {
            transmitted = this.transferEnergyToReceiverInNeed(from, network, maxTransmit, simulate);
        }
        return transmitted;
    }

    @Override
    public IEnergyStorage getEnergyStorage(EnumFacing facing) {
        return this.energyStorages[facing == null ? 0 : facing.ordinal()];
    }

    @Override
    public boolean shouldSaveDataOnChangeOrWorldStart() {
        return true;
    }

    @Override
    public void saveDataOnChangeOrWorldStart() {
        Network network;
        HashMap<EnumFacing, TileEntity> old = new HashMap<EnumFacing, TileEntity>(this.receiversAround);
        boolean change = false;
        this.receiversAround.clear();
        for (EnumFacing side : EnumFacing.values()) {
            TileEntity tile;
            BlockPos pos = this.func_174877_v().func_177972_a(side);
            if (!this.field_145850_b.func_175667_e(pos) || (tile = this.field_145850_b.func_175625_s(pos)) == null || tile instanceof TileEntityLaserRelay || !tile.hasCapability(CapabilityEnergy.ENERGY, side.func_176734_d())) continue;
            this.receiversAround.put(side, tile);
            TileEntity oldTile = (TileEntity)old.get(side);
            if (oldTile != null && tile.equals(oldTile)) continue;
            change = true;
        }
        if ((change || old.size() != this.receiversAround.size()) && (network = this.getNetwork()) != null) {
            ++network.changeAmount;
        }
    }

    private int transferEnergyToReceiverInNeed(EnumFacing from, Network network, int maxTransfer, boolean simulate) {
        int transmitted = 0;
        ObjectOpenHashSet alreadyChecked = new ObjectOpenHashSet();
        ObjectOpenHashSet relaysThatWork = new ObjectOpenHashSet();
        int totalReceiverAmount = 0;
        for (IConnectionPair pair : network.connections) {
            for (BlockPos relay : pair.getPositions()) {
                if (relay == null || !this.field_145850_b.func_175667_e(relay) || alreadyChecked.contains(relay)) continue;
                alreadyChecked.add(relay);
                TileEntity relayTile = this.field_145850_b.func_175625_s(relay);
                if (!(relayTile instanceof TileEntityLaserRelayEnergy)) continue;
                TileEntityLaserRelayEnergy theRelay = (TileEntityLaserRelayEnergy)relayTile;
                if (theRelay.mode == Mode.INPUT_ONLY) continue;
                boolean workedOnce = false;
                for (EnumFacing facing : theRelay.receiversAround.keySet()) {
                    IEnergyStorage cap;
                    if (theRelay == this && facing == from) continue;
                    TileEntity tile = theRelay.receiversAround.get(facing);
                    EnumFacing opp = facing.func_176734_d();
                    if (tile == null || !tile.hasCapability(CapabilityEnergy.ENERGY, opp) || (cap = (IEnergyStorage)tile.getCapability(CapabilityEnergy.ENERGY, opp)) == null || cap.receiveEnergy(maxTransfer, true) <= 0) continue;
                    ++totalReceiverAmount;
                    workedOnce = true;
                }
                if (!workedOnce) continue;
                relaysThatWork.add(theRelay);
            }
        }
        if (totalReceiverAmount > 0 && !relaysThatWork.isEmpty()) {
            int amountPer = maxTransfer / totalReceiverAmount;
            if (amountPer <= 0) {
                amountPer = maxTransfer;
            }
            for (TileEntityLaserRelayEnergy theRelay : relaysThatWork) {
                double highestLoss = Math.max(theRelay.getLossPercentage(), this.getLossPercentage());
                int lowestCap = Math.min(theRelay.getEnergyCap(), this.getEnergyCap());
                for (Map.Entry<EnumFacing, TileEntity> receiver : theRelay.receiversAround.entrySet()) {
                    int theoreticalReceived;
                    IEnergyStorage cap;
                    if (receiver == null) continue;
                    EnumFacing side = receiver.getKey();
                    EnumFacing opp = side.func_176734_d();
                    TileEntity tile = receiver.getValue();
                    if (alreadyChecked.contains(tile.func_174877_v())) continue;
                    alreadyChecked.add(tile.func_174877_v());
                    if (theRelay == this && side == from) continue;
                    if (tile.hasCapability(CapabilityEnergy.ENERGY, opp) && (cap = (IEnergyStorage)tile.getCapability(CapabilityEnergy.ENERGY, opp)) != null && (theoreticalReceived = cap.receiveEnergy(Math.min(amountPer, lowestCap), true)) > 0) {
                        int deduct = this.calcDeduction(theoreticalReceived, highestLoss);
                        if (deduct >= theoreticalReceived) {
                            deduct = 0;
                        }
                        transmitted += cap.receiveEnergy(theoreticalReceived - deduct, simulate);
                        transmitted += deduct;
                    }
                    if (transmitted < maxTransfer) continue;
                    return transmitted;
                }
            }
        }
        return transmitted;
    }

    private int calcDeduction(int theoreticalReceived, double highestLoss) {
        return ConfigBoolValues.LASER_RELAY_LOSS.isEnabled() ? MathHelper.func_76143_f((double)((double)theoreticalReceived * (highestLoss / 100.0))) : 0;
    }

    public int getEnergyCap() {
        return 1000;
    }

    public double getLossPercentage() {
        return 5.0;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getExtraDisplayString() {
        return StringUtil.localize("info.actuallyadditions.laserRelay.energy.extra") + ": " + TextFormatting.DARK_RED + StringUtil.localize(this.mode.name) + TextFormatting.RESET;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getCompassDisplayString() {
        return TextFormatting.GREEN + StringUtil.localize("info.actuallyadditions.laserRelay.energy.display");
    }

    @Override
    public void onCompassAction(EntityPlayer player) {
        this.mode = this.mode.getNext();
    }

    @Override
    public void writeSyncableNBT(NBTTagCompound compound, TileEntityBase.NBTType type) {
        super.writeSyncableNBT(compound, type);
        if (type != TileEntityBase.NBTType.SAVE_BLOCK) {
            compound.func_74778_a("Mode", this.mode.toString());
        }
    }

    @Override
    public void readSyncableNBT(NBTTagCompound compound, TileEntityBase.NBTType type) {
        String modeStrg;
        super.readSyncableNBT(compound, type);
        if (type != TileEntityBase.NBTType.SAVE_BLOCK && (modeStrg = compound.func_74779_i("Mode")) != null && !modeStrg.isEmpty()) {
            this.mode = Mode.valueOf(modeStrg);
        }
    }

    public static enum Mode {
        BOTH("info.actuallyadditions.laserRelay.mode.both"),
        OUTPUT_ONLY("info.actuallyadditions.laserRelay.mode.outputOnly"),
        INPUT_ONLY("info.actuallyadditions.laserRelay.mode.inputOnly");

        public final String name;

        private Mode(String name) {
            this.name = name;
        }

        public Mode getNext() {
            int ordinal = this.ordinal() + 1;
            if (ordinal >= Mode.values().length) {
                ordinal = 0;
            }
            return Mode.values()[ordinal];
        }
    }
}

