/*
 * Decompiled with CFR 0.152.
 */
package mekanism.tools.common;

import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import mekanism.common.MekanismItems;
import mekanism.common.config.MekanismConfig;
import mekanism.common.config.ToolsConfig;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.common.util.EnumHelper;

public enum Materials {
    OBSIDIAN("OBSIDIAN", cfg -> cfg.toolOBSIDIAN, cfg -> cfg.toolOBSIDIAN2, cfg -> cfg.armorOBSIDIAN, () -> new ItemStack(MekanismItems.Ingot)),
    LAZULI("LAZULI", cfg -> cfg.toolLAZULI, cfg -> cfg.toolLAZULI2, cfg -> cfg.armorLAZULI, () -> new ItemStack(Items.field_151100_aR, 1, 4), SoundEvents.field_187716_o),
    OSMIUM("OSMIUM", cfg -> cfg.toolOSMIUM, cfg -> cfg.toolOSMIUM2, cfg -> cfg.armorOSMIUM, () -> new ItemStack(MekanismItems.Ingot, 1, 1)),
    BRONZE("BRONZE", cfg -> cfg.toolBRONZE, cfg -> cfg.toolBRONZE2, cfg -> cfg.armorBRONZE, () -> new ItemStack(MekanismItems.Ingot, 1, 2)),
    GLOWSTONE("GLOWSTONE", tools -> tools.toolGLOWSTONE, tools -> tools.toolGLOWSTONE2, cfg -> cfg.armorGLOWSTONE, () -> new ItemStack(MekanismItems.Ingot, 1, 3)),
    STEEL("STEEL", cfg -> cfg.toolSTEEL, cfg -> cfg.toolSTEEL2, cfg -> cfg.armorSTEEL, () -> new ItemStack(MekanismItems.Ingot, 1, 4));

    private final Function<ToolsConfig, ToolsConfig.ToolBalance> materialFunction;
    private final Function<ToolsConfig, ToolsConfig.ToolBalance> paxelMaterialFunction;
    private final Function<ToolsConfig, ToolsConfig.ArmorBalance> armorMaterialFunction;
    private final Supplier<ItemStack> repairStackSupplier;
    private final SoundEvent equipSound;
    private final String materialName;
    private Item.ToolMaterial material;
    private Item.ToolMaterial paxelMaterial;
    private ItemArmor.ArmorMaterial armorMaterial;
    private boolean initialized;
    private float axeDamage;
    private float axeSpeed;

    private Materials(@Nonnull String name, @Nonnull Function<ToolsConfig, ToolsConfig.ToolBalance> material, @Nonnull Function<ToolsConfig, ToolsConfig.ToolBalance> paxelMaterial, Function<ToolsConfig, ToolsConfig.ArmorBalance> armorMaterial, Supplier<ItemStack> repairStack) {
        this(name, material, paxelMaterial, armorMaterial, repairStack, SoundEvents.field_187725_r);
    }

    private Materials(@Nonnull String name, @Nonnull Function<ToolsConfig, ToolsConfig.ToolBalance> material, @Nonnull Function<ToolsConfig, ToolsConfig.ToolBalance> paxelMaterial, @Nonnull Function<ToolsConfig, ToolsConfig.ArmorBalance> armorMaterial, Supplier<ItemStack> repairStack, SoundEvent equipSound) {
        this.materialName = name;
        this.materialFunction = material;
        this.paxelMaterialFunction = paxelMaterial;
        this.armorMaterialFunction = armorMaterial;
        this.repairStackSupplier = repairStack;
        this.equipSound = equipSound;
    }

    private static Item.ToolMaterial getToolMaterial(@Nonnull String enumName, @Nonnull ToolsConfig.ToolBalance config) {
        return EnumHelper.addToolMaterial((String)enumName, (int)config.harvestLevel.val(), (int)config.maxUses.val(), (float)config.efficiency.val(), (float)config.damage.val(), (int)config.enchantability.val());
    }

    private static ItemArmor.ArmorMaterial getArmorMaterial(@Nonnull String enumName, @Nonnull ToolsConfig.ArmorBalance config, @Nonnull SoundEvent equipSound) {
        return EnumHelper.addArmorMaterial((String)enumName, (String)"TODO", (int)config.durability.val(), (int[])new int[]{config.feetProtection.val(), config.legsProtection.val(), config.chestProtection.val(), config.headProtection.val()}, (int)config.enchantability.val(), (SoundEvent)equipSound, (float)config.toughness.val());
    }

    public static void load() {
        for (Materials material : Materials.values()) {
            material.init();
        }
    }

    private void init() {
        if (this.initialized) {
            return;
        }
        ToolsConfig.ToolBalance materialBalance = this.materialFunction.apply(MekanismConfig.current().tools);
        ToolsConfig.ToolBalance paxelMaterialBalance = this.paxelMaterialFunction.apply(MekanismConfig.current().tools);
        ToolsConfig.ArmorBalance armorBalance = this.armorMaterialFunction.apply(MekanismConfig.current().tools);
        this.material = Materials.getToolMaterial(this.materialName, materialBalance);
        this.paxelMaterial = Materials.getToolMaterial(this.materialName + "2", paxelMaterialBalance);
        this.armorMaterial = Materials.getArmorMaterial(this.materialName, armorBalance, this.equipSound);
        this.axeDamage = materialBalance.axeAttackDamage.val();
        this.axeSpeed = materialBalance.axeAttackSpeed.val();
        ItemStack repairStack = this.repairStackSupplier.get();
        this.material.setRepairItem(repairStack);
        this.paxelMaterial.setRepairItem(repairStack);
        this.armorMaterial.setRepairItem(repairStack);
        this.initialized = true;
    }

    public Item.ToolMaterial getMaterial() {
        return this.material;
    }

    public Item.ToolMaterial getPaxelMaterial() {
        return this.paxelMaterial;
    }

    public ItemArmor.ArmorMaterial getArmorMaterial() {
        return this.armorMaterial;
    }

    public float getAxeDamage() {
        return this.axeDamage;
    }

    public float getAxeSpeed() {
        return this.axeSpeed;
    }
}

