/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.energycontrol;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.zuxelus.energycontrol.EnergyControl;
import com.zuxelus.energycontrol.EnergyControlConfig;
import com.zuxelus.energycontrol.network.NetworkHelper;
import com.zuxelus.energycontrol.network.PacketAlarm;
import com.zuxelus.energycontrol.network.PacketOreHelper;
import com.zuxelus.energycontrol.websockets.SocketClient;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class ServerTickHandler {
    public static final ServerTickHandler instance = new ServerTickHandler();
    public Map<String, JsonObject> cards = new HashMap<String, JsonObject>();
    public int updateTicker;

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        EnergyControl.instance.screenManager.clearWorld(event.getWorld());
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        if (!(event.player instanceof EntityPlayerMP)) {
            return;
        }
        EnergyControl.altPressed.put(event.player, false);
        NetworkHelper.network.sendTo((IMessage)new PacketAlarm(EnergyControlConfig.howlerAlarmRange, EnergyControlConfig.allowedAlarms), (EntityPlayerMP)event.player);
        if (EnergyControl.oreHelper != null) {
            NetworkHelper.network.sendTo((IMessage)new PacketOreHelper(EnergyControl.oreHelper), (EntityPlayerMP)event.player);
        }
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && EnergyControlConfig.webSocket.wsEnabled && this.updateTicker-- < 0) {
            this.updateTicker = EnergyControlConfig.webSocket.wsRefreshRate - 1;
            if (!this.cards.isEmpty()) {
                JsonObject json = new JsonObject();
                json.addProperty("id", EnergyControlConfig.webSocket.wsServerID);
                JsonArray array = new JsonArray();
                for (Map.Entry<String, JsonObject> card : this.cards.entrySet()) {
                    array.add((JsonElement)card.getValue());
                }
                json.add("cards", (JsonElement)array);
                SocketClient.sendMessage(json.toString());
                this.cards.clear();
            }
        }
    }
}

