/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.energycontrol.crossmod;

import com.zuxelus.energycontrol.crossmod.CrossModBase;
import com.zuxelus.energycontrol.crossmod.IC2ReactorHelper;
import com.zuxelus.energycontrol.hooks.IC2ClassicHooks;
import com.zuxelus.energycontrol.init.ModItems;
import com.zuxelus.energycontrol.items.ItemDigitalThermometer;
import com.zuxelus.energycontrol.items.cards.ItemCardIC2;
import com.zuxelus.energycontrol.items.cards.ItemCardMain;
import com.zuxelus.energycontrol.items.kits.ItemKitIC2;
import com.zuxelus.energycontrol.items.kits.ItemKitMain;
import com.zuxelus.energycontrol.utils.FluidInfo;
import ic2.api.classic.tile.machine.IEUStorage;
import ic2.api.item.ElectricItem;
import ic2.api.item.IC2Items;
import ic2.api.item.ICustomDamageItem;
import ic2.api.reactor.IReactor;
import ic2.api.tile.IEnergyStorage;
import ic2.core.IC2;
import ic2.core.block.base.tile.TileEntityElectricBlock;
import ic2.core.block.base.tile.TileEntityFuelGeneratorBase;
import ic2.core.block.base.tile.TileEntityGeneratorBase;
import ic2.core.block.generator.tile.TileEntityBasicSteamTurbine;
import ic2.core.block.generator.tile.TileEntityFuelBoiler;
import ic2.core.block.generator.tile.TileEntityLiquidFuelGenerator;
import ic2.core.block.generator.tile.TileEntityNuclearReactorElectric;
import ic2.core.block.generator.tile.TileEntityNuclearSteamReactor;
import ic2.core.block.generator.tile.TileEntityReactorChamberElectric;
import ic2.core.block.generator.tile.TileEntitySolarPanel;
import ic2.core.block.generator.tile.TileEntitySteamReactorChamber;
import ic2.core.block.generator.tile.TileEntityWaterGenerator;
import ic2.core.block.generator.tile.TileEntityWindGenerator;
import ic2.core.block.machine.low.TileEntityMachineTank;
import ic2.core.block.personal.tile.TileEntityPersonalTank;
import ic2.core.item.reactor.ItemReactorUraniumRod;
import ic2.core.item.tool.ItemToolWrench;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class CrossIC2Classic
extends CrossModBase {
    @Override
    public ItemStack getItemStack(String name) {
        switch (name) {
            case "transformer": {
                return IC2Items.getItem((String)"upgrade", (String)"transformer");
            }
            case "energy_storage": {
                return IC2Items.getItem((String)"upgrade", (String)"energy_storage");
            }
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public ItemStack getChargedStack(ItemStack stack) {
        ElectricItem.manager.charge(stack, 2.147483647E9, Integer.MAX_VALUE, true, false);
        return stack;
    }

    @Override
    public boolean isWrench(ItemStack stack) {
        return !stack.func_190926_b() && stack.func_77973_b() instanceof ItemToolWrench;
    }

    @Override
    public NBTTagCompound getEnergyData(TileEntity te) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("euType", "EU");
        if (te instanceof IEnergyStorage) {
            tag.func_74780_a("energy", (double)((IEnergyStorage)te).getStored());
            tag.func_74780_a("capacity", (double)((IEnergyStorage)te).getCapacity());
            return tag;
        }
        return null;
    }

    @Override
    public List<FluidInfo> getAllTanks(TileEntity te) {
        ArrayList<FluidInfo> result = new ArrayList<FluidInfo>();
        if (te instanceof TileEntityNuclearSteamReactor) {
            result.add(new FluidInfo((IFluidTank)((TileEntityNuclearSteamReactor)te).getWaterTank()));
            result.add(new FluidInfo((IFluidTank)((TileEntityNuclearSteamReactor)te).getSteamTank()));
        }
        if (te instanceof TileEntityMachineTank) {
            result.add(new FluidInfo((IFluidTank)((TileEntityMachineTank)te).tank));
        }
        if (te instanceof TileEntityPersonalTank) {
            result.add(new FluidInfo((IFluidTank)((TileEntityPersonalTank)te).tank));
        }
        if (te instanceof TileEntityLiquidFuelGenerator) {
            result.add(new FluidInfo((IFluidTank)((TileEntityLiquidFuelGenerator)te).tank));
        }
        if (result.size() == 0) {
            return null;
        }
        return result;
    }

    @Override
    public NBTTagCompound getCardData(World world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        try {
            IReactor reactor;
            NBTTagCompound tag = new NBTTagCompound();
            if (te instanceof IEUStorage) {
                ArrayList values;
                tag.func_74780_a("energy", (double)((IEUStorage)te).getStoredEU());
                tag.func_74780_a("capacity", (double)((IEUStorage)te).getMaxEU());
                if (te instanceof TileEntityFuelGeneratorBase) {
                    tag.func_74757_a("active", ((TileEntityFuelGeneratorBase)te).fuel > 0);
                    tag.func_74780_a("output", ((TileEntityFuelGeneratorBase)te).fuel > 0 ? (double)((TileEntityGeneratorBase)te).getOutput() : 0.0);
                    tag.func_74768_a("fuel", ((TileEntityFuelGeneratorBase)te).fuel);
                    if (te instanceof TileEntityWaterGenerator) {
                        tag.func_74757_a("active", ((TileEntityFuelGeneratorBase)te).fuel > 0 || ((TileEntityWaterGenerator)te).water > 0);
                        tag.func_74780_a("output", ((TileEntityFuelGeneratorBase)te).fuel > 0 ? (double)((TileEntityGeneratorBase)te).getOutput() : (double)(((TileEntityWaterGenerator)te).water * IC2.config.getInt("energyGeneratorWater")) / 10000.0);
                    }
                }
                if (te instanceof TileEntityElectricBlock && (values = this.getHookValues(te)) != null) {
                    tag.func_74780_a("diff", (double)((Integer)values.get(0) - (Integer)values.get(20)) / 20.0);
                }
                if (te instanceof TileEntityWindGenerator) {
                    tag.func_74780_a("output", ((TileEntityWindGenerator)te).subProduction * 4.0);
                }
                if (te instanceof TileEntityBasicSteamTurbine) {
                    tag.func_74757_a("active", ((TileEntityBasicSteamTurbine)te).getActive());
                    double speed = ((TileEntityBasicSteamTurbine)te).speed;
                    ArrayList values2 = this.getHookValues(te);
                    if (values2 != null) {
                        tag.func_74780_a("output", (double)((Integer)values2.get(0)).intValue());
                    }
                    FluidInfo.addTank("tank", tag, ((TileEntityBasicSteamTurbine)te).tank);
                }
                return tag;
            }
            if (te instanceof TileEntitySolarPanel) {
                tag.func_74757_a("active", ((TileEntitySolarPanel)te).getActive());
                tag.func_74780_a("output", ((TileEntitySolarPanel)te).getActive() ? (double)((TileEntitySolarPanel)te).getOutput() : 0.0);
                return tag;
            }
            if (te instanceof TileEntityFuelBoiler) {
                int realHeat = ((TileEntityFuelBoiler)te).heat / 30;
                tag.func_74768_a("heat", realHeat);
                tag.func_74768_a("maxHeat", 800);
                tag.func_74780_a("consumption", realHeat >= 100 ? (double)((float)realHeat * 0.32f / 160.0f) : 0.0);
                tag.func_74780_a("outputmb", realHeat >= 100 ? (double)((int)((float)realHeat * 0.32f)) : 0.0);
                IFluidTankProperties[] tanks = ((TileEntityFuelBoiler)te).getTankProperties();
                FluidInfo.addTank("tank", tag, tanks[0].getContents());
                FluidInfo.addTank("tank2", tag, tanks[1].getContents());
                return tag;
            }
            if (te instanceof TileEntityNuclearReactorElectric) {
                return this.getReactorData((TileEntityNuclearReactorElectric)te);
            }
            if (te instanceof TileEntityReactorChamberElectric && (reactor = ((TileEntityReactorChamberElectric)te).getReactorInstance()) instanceof TileEntityNuclearReactorElectric) {
                return this.getReactorData((TileEntityNuclearReactorElectric)reactor);
            }
            if (te instanceof TileEntityNuclearSteamReactor) {
                return this.getReactorData((TileEntityNuclearSteamReactor)te);
            }
            if (te instanceof TileEntitySteamReactorChamber && (reactor = ((TileEntitySteamReactorChamber)te).getReactorInstance()) instanceof TileEntityNuclearSteamReactor) {
                return this.getReactorData((TileEntityNuclearSteamReactor)reactor);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    private NBTTagCompound getReactorData(TileEntityNuclearReactorElectric reactor) {
        if (reactor == null) {
            return null;
        }
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("heat", reactor.getHeat());
        tag.func_74768_a("maxHeat", reactor.getMaxHeat());
        tag.func_74757_a("active", reactor.produceEnergy());
        tag.func_74768_a("output", (int)Math.round(reactor.getReactorEUEnergyOutput()));
        TileEntityNuclearReactorElectric chamber = reactor;
        int size = chamber.getReactorSize();
        int dmgLeft = 0;
        for (int y = 0; y < 6; ++y) {
            for (int x = 0; x < size; ++x) {
                ItemStack stack = chamber.getItemAt(x, y);
                if (stack.func_190926_b()) continue;
                dmgLeft = Math.max(dmgLeft, this.getNuclearCellTimeLeft(stack));
            }
        }
        tag.func_74768_a("timeLeft", dmgLeft * reactor.getTickRate() / 20);
        return tag;
    }

    private NBTTagCompound getReactorData(TileEntityNuclearSteamReactor reactor) {
        if (reactor == null) {
            return null;
        }
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("heat", reactor.getHeat());
        tag.func_74768_a("maxHeat", reactor.getMaxHeat());
        tag.func_74757_a("active", reactor.produceEnergy());
        tag.func_74780_a("consumption", (double)reactor.output * 3.2 / 160.0);
        tag.func_74780_a("outputmb", (double)reactor.output * 3.2);
        TileEntityNuclearSteamReactor chamber = reactor;
        int size = chamber.getReactorSize();
        int dmgLeft = 0;
        for (int y = 0; y < 6; ++y) {
            for (int x = 0; x < size; ++x) {
                ItemStack stack = chamber.getItemAt(x, y);
                if (stack.func_190926_b()) continue;
                dmgLeft = Math.max(dmgLeft, this.getNuclearCellTimeLeft(stack));
            }
        }
        tag.func_74768_a("timeLeft", dmgLeft);
        FluidInfo.addTank("tank", tag, reactor.getWaterTank());
        FluidInfo.addTank("tank2", tag, reactor.getSteamTank());
        return tag;
    }

    private int getNuclearCellTimeLeft(ItemStack stack) {
        if (stack.func_190926_b()) {
            return 0;
        }
        Item item = stack.func_77973_b();
        if (item instanceof ItemReactorUraniumRod) {
            return ((ICustomDamageItem)item).getMaxCustomDamage(stack) - ((ICustomDamageItem)item).getCustomDamage(stack);
        }
        return 0;
    }

    @Override
    public int getHeat(World world, BlockPos pos) {
        IReactor reactor = IC2ReactorHelper.getReactorAround(world, pos);
        if (reactor != null) {
            return reactor.getHeat();
        }
        reactor = IC2ReactorHelper.getReactor3x3(world, pos);
        if (reactor != null) {
            return reactor.getHeat();
        }
        return -1;
    }

    @Override
    public ArrayList getHookValues(TileEntity te) {
        ArrayList values = IC2ClassicHooks.map.get(te);
        if (values == null) {
            IC2ClassicHooks.map.put(te, null);
        }
        return values;
    }

    @Override
    public void registerItems(RegistryEvent.Register<Item> event) {
        ModItems.itemThermometerDigital = ModItems.register(event, new ItemDigitalThermometer(), "thermometer_digital");
        ItemKitMain.register(ItemKitIC2::new);
        ItemCardMain.register(ItemCardIC2::new);
    }

    @Override
    public void registerModels(ModelRegistryEvent event) {
        ModItems.registerItemModel(ModItems.itemThermometerDigital, 0, "thermometer_digital");
    }
}

