/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.energycontrol.crossmod;

import com.zuxelus.energycontrol.crossmod.CrossModBase;
import com.zuxelus.energycontrol.hooks.MekanismHooks;
import com.zuxelus.energycontrol.utils.FluidInfo;
import java.util.ArrayList;
import java.util.List;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.GasTank;
import mekanism.api.infuse.InfuseType;
import mekanism.common.FluidSlot;
import mekanism.common.InfuseStorage;
import mekanism.common.config.MekanismConfig;
import mekanism.common.content.boiler.SynchronizedBoilerData;
import mekanism.common.content.matrix.SynchronizedMatrixData;
import mekanism.common.tile.TileEntityBoilerCasing;
import mekanism.common.tile.TileEntityChargepad;
import mekanism.common.tile.TileEntityChemicalCrystallizer;
import mekanism.common.tile.TileEntityChemicalDissolutionChamber;
import mekanism.common.tile.TileEntityChemicalInfuser;
import mekanism.common.tile.TileEntityChemicalOxidizer;
import mekanism.common.tile.TileEntityChemicalWasher;
import mekanism.common.tile.TileEntityCombiner;
import mekanism.common.tile.TileEntityElectricPump;
import mekanism.common.tile.TileEntityElectrolyticSeparator;
import mekanism.common.tile.TileEntityEnergyCube;
import mekanism.common.tile.TileEntityFactory;
import mekanism.common.tile.TileEntityFluidTank;
import mekanism.common.tile.TileEntityFluidicPlenisher;
import mekanism.common.tile.TileEntityFormulaicAssemblicator;
import mekanism.common.tile.TileEntityFuelwoodHeater;
import mekanism.common.tile.TileEntityInductionCasing;
import mekanism.common.tile.TileEntityInductionCell;
import mekanism.common.tile.TileEntityLaser;
import mekanism.common.tile.TileEntityLaserAmplifier;
import mekanism.common.tile.TileEntityMetallurgicInfuser;
import mekanism.common.tile.TileEntityPRC;
import mekanism.common.tile.TileEntityPrecisionSawmill;
import mekanism.common.tile.TileEntityResistiveHeater;
import mekanism.common.tile.TileEntityRotaryCondensentrator;
import mekanism.common.tile.TileEntitySeismicVibrator;
import mekanism.common.tile.TileEntitySolarNeutronActivator;
import mekanism.common.tile.TileEntityTeleporter;
import mekanism.common.tile.prefab.TileEntityAdvancedElectricMachine;
import mekanism.common.tile.prefab.TileEntityElectricBlock;
import mekanism.common.tile.prefab.TileEntityElectricMachine;
import mekanism.common.tile.prefab.TileEntityMachine;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.UnitDisplayUtils;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.IFluidTank;

public class CrossMekanism
extends CrossModBase {
    @Override
    public NBTTagCompound getEnergyData(TileEntity te) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("euType", CrossMekanism.getEUType());
        if (te instanceof TileEntityInductionCell) {
            tag.func_74780_a("energy", MekanismUtils.convertToDisplay((double)((TileEntityInductionCell)te).getEnergy()));
            tag.func_74780_a("capacity", MekanismUtils.convertToDisplay((double)((TileEntityInductionCell)te).getMaxEnergy()));
            return tag;
        }
        if (te instanceof TileEntityElectricBlock) {
            return CrossMekanism.setStorage(te);
        }
        if (te instanceof TileEntityInductionCasing) {
            SynchronizedMatrixData matrix = (SynchronizedMatrixData)((TileEntityInductionCasing)te).getSynchronizedData();
            if (matrix == null) {
                return null;
            }
            tag.func_74780_a("energy", MekanismUtils.convertToDisplay((double)matrix.getEnergy()));
            tag.func_74780_a("capacity", MekanismUtils.convertToDisplay((double)matrix.getStorageCap()));
            return tag;
        }
        if (te instanceof TileEntityLaserAmplifier) {
            tag.func_74780_a("energy", MekanismUtils.convertToDisplay((double)((TileEntityLaserAmplifier)te).getEnergy()));
            tag.func_74780_a("capacity", MekanismUtils.convertToDisplay((double)((TileEntityLaserAmplifier)te).getMaxEnergy()));
            return tag;
        }
        return null;
    }

    @Override
    public List<FluidInfo> getAllTanks(TileEntity te) {
        ArrayList<FluidInfo> result = new ArrayList<FluidInfo>();
        if (te instanceof TileEntityFluidTank) {
            result.add(new FluidInfo((IFluidTank)((TileEntityFluidTank)te).fluidTank));
            return result;
        }
        if (te instanceof TileEntityAdvancedElectricMachine) {
            result.add(CrossMekanism.toFluidInfo(((TileEntityAdvancedElectricMachine)te).gasTank));
            return result;
        }
        if (te instanceof TileEntityMetallurgicInfuser) {
            result.add(CrossMekanism.toFluidInfo(((TileEntityMetallurgicInfuser)te).infuseStored, ((TileEntityMetallurgicInfuser)te).MAX_INFUSE));
            return result;
        }
        if (te instanceof TileEntityRotaryCondensentrator) {
            result.add(CrossMekanism.toFluidInfo(((TileEntityRotaryCondensentrator)te).gasTank));
            result.add(new FluidInfo((IFluidTank)((TileEntityRotaryCondensentrator)te).fluidTank));
            return result;
        }
        if (te instanceof TileEntityChemicalOxidizer) {
            result.add(CrossMekanism.toFluidInfo(((TileEntityChemicalOxidizer)te).gasTank));
            return result;
        }
        if (te instanceof TileEntityChemicalInfuser) {
            result.add(CrossMekanism.toFluidInfo(((TileEntityChemicalInfuser)te).leftTank));
            result.add(CrossMekanism.toFluidInfo(((TileEntityChemicalInfuser)te).rightTank));
            result.add(CrossMekanism.toFluidInfo(((TileEntityChemicalInfuser)te).centerTank));
            return result;
        }
        if (te instanceof TileEntityElectrolyticSeparator) {
            result.add(new FluidInfo((IFluidTank)((TileEntityElectrolyticSeparator)te).fluidTank));
            result.add(CrossMekanism.toFluidInfo(((TileEntityElectrolyticSeparator)te).leftTank));
            result.add(CrossMekanism.toFluidInfo(((TileEntityElectrolyticSeparator)te).rightTank));
            return result;
        }
        if (te instanceof TileEntityChemicalDissolutionChamber) {
            result.add(CrossMekanism.toFluidInfo(((TileEntityChemicalDissolutionChamber)te).injectTank));
            result.add(CrossMekanism.toFluidInfo(((TileEntityChemicalDissolutionChamber)te).outputTank));
            return result;
        }
        if (te instanceof TileEntityChemicalWasher) {
            result.add(new FluidInfo((IFluidTank)((TileEntityChemicalWasher)te).fluidTank));
            result.add(CrossMekanism.toFluidInfo(((TileEntityChemicalWasher)te).inputTank));
            result.add(CrossMekanism.toFluidInfo(((TileEntityChemicalWasher)te).outputTank));
            return result;
        }
        if (te instanceof TileEntityChemicalCrystallizer) {
            result.add(CrossMekanism.toFluidInfo(((TileEntityChemicalCrystallizer)te).inputTank));
            return result;
        }
        if (te instanceof TileEntityBoilerCasing) {
            SynchronizedBoilerData boiler = (SynchronizedBoilerData)((TileEntityBoilerCasing)te).getSynchronizedData();
            if (boiler == null) {
                return null;
            }
            result.add(new FluidInfo(boiler.waterStored, boiler.waterVolume * 16000));
            result.add(new FluidInfo(boiler.steamStored, boiler.steamVolume * 160000));
            return result;
        }
        if (te instanceof TileEntitySolarNeutronActivator) {
            result.add(CrossMekanism.toFluidInfo(((TileEntitySolarNeutronActivator)te).inputTank));
            result.add(CrossMekanism.toFluidInfo(((TileEntitySolarNeutronActivator)te).outputTank));
            return result;
        }
        return null;
    }

    public static FluidInfo toFluidInfo(GasTank tank) {
        GasStack stack = tank.getGas();
        if (stack == null) {
            return new FluidInfo(null, null, 0L, tank.getMaxGas());
        }
        Fluid fluid = stack.getGas().getFluid();
        if (fluid != null) {
            return new FluidInfo(fluid, stack.amount, tank.getMaxGas());
        }
        return new FluidInfo(stack.getGas().getTranslationKey(), stack.getGas().getIcon().toString(), stack.amount, tank.getMaxGas());
    }

    public static FluidInfo toFluidInfo(InfuseStorage tank, int capacity) {
        if (tank.getType() == null) {
            return new FluidInfo(null, null, tank.getAmount(), capacity);
        }
        return new FluidInfo(tank.getType().unlocalizedName, null, tank.getAmount(), capacity);
    }

    @Override
    public NBTTagCompound getCardData(World world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityEnergyCube) {
            NBTTagCompound tag = CrossMekanism.setStorage(te);
            ArrayList values = this.getHookValues(te);
            if (values != null) {
                tag.func_74780_a("diff", MekanismUtils.convertToDisplay((double)(((Double)values.get(0) - (Double)values.get(20)) / 20.0)));
            }
            return tag;
        }
        if (te instanceof TileEntityFactory) {
            NBTTagCompound tag = CrossMekanism.setStorage(te);
            tag.func_74780_a("usage", MekanismUtils.convertToDisplay((double)((TileEntityFactory)te).lastUsage));
            tag.func_74757_a("active", ((TileEntityFactory)te).lastUsage > 0.0);
            return tag;
        }
        if (te instanceof TileEntityElectricMachine) {
            NBTTagCompound tag = CrossMekanism.setStorage(te);
            CrossMekanism.addUsage(tag, te);
            return tag;
        }
        if (te instanceof TileEntityAdvancedElectricMachine) {
            NBTTagCompound tag = CrossMekanism.setStorage(te);
            CrossMekanism.addUsage(tag, te);
            CrossMekanism.addTank("tank", tag, ((TileEntityAdvancedElectricMachine)te).gasTank);
            return tag;
        }
        if (te instanceof TileEntityCombiner) {
            NBTTagCompound tag = CrossMekanism.setStorage(te);
            CrossMekanism.addUsage(tag, te);
            return tag;
        }
        if (te instanceof TileEntityMetallurgicInfuser) {
            NBTTagCompound tag = CrossMekanism.setStorage(te);
            CrossMekanism.addUsage(tag, te);
            CrossMekanism.addTank("tank", tag, ((TileEntityMetallurgicInfuser)te).infuseStored);
            return tag;
        }
        if (te instanceof TileEntityTeleporter) {
            NBTTagCompound tag = CrossMekanism.setStorage(te);
            return tag;
        }
        if (te instanceof TileEntityElectricPump) {
            NBTTagCompound tag = CrossMekanism.setStorage(te);
            FluidInfo.addTank("tank", tag, ((TileEntityElectricPump)te).fluidTank);
            return tag;
        }
        if (te instanceof TileEntityChargepad) {
            NBTTagCompound tag = CrossMekanism.setStorage(te);
            tag.func_74757_a("active", ((TileEntityChargepad)te).getActive());
            return tag;
        }
        if (te instanceof TileEntityRotaryCondensentrator) {
            NBTTagCompound tag = CrossMekanism.setStorage(te);
            CrossMekanism.addUsage(tag, te);
            CrossMekanism.addTank("tank", tag, ((TileEntityRotaryCondensentrator)te).gasTank);
            FluidInfo.addTank("tank2", tag, ((TileEntityRotaryCondensentrator)te).fluidTank);
            return tag;
        }
        if (te instanceof TileEntityChemicalOxidizer) {
            NBTTagCompound tag = CrossMekanism.setStorage(te);
            CrossMekanism.addUsage(tag, te);
            CrossMekanism.addTank("tank", tag, ((TileEntityChemicalOxidizer)te).gasTank);
            return tag;
        }
        if (te instanceof TileEntityChemicalInfuser) {
            NBTTagCompound tag = CrossMekanism.setStorage(te);
            CrossMekanism.addUsage(tag, te);
            CrossMekanism.addTank("tank", tag, ((TileEntityChemicalInfuser)te).leftTank);
            CrossMekanism.addTank("tank2", tag, ((TileEntityChemicalInfuser)te).rightTank);
            CrossMekanism.addTank("tank3", tag, ((TileEntityChemicalInfuser)te).centerTank);
            return tag;
        }
        if (te instanceof TileEntityElectrolyticSeparator) {
            NBTTagCompound tag = CrossMekanism.setStorage(te);
            CrossMekanism.addUsage(tag, te);
            FluidInfo.addTank("tank", tag, ((TileEntityElectrolyticSeparator)te).fluidTank);
            CrossMekanism.addTank("tank2", tag, ((TileEntityElectrolyticSeparator)te).leftTank);
            CrossMekanism.addTank("tank3", tag, ((TileEntityElectrolyticSeparator)te).rightTank);
            return tag;
        }
        if (te instanceof TileEntityPrecisionSawmill) {
            NBTTagCompound tag = CrossMekanism.setStorage(te);
            CrossMekanism.addUsage(tag, te);
            return tag;
        }
        if (te instanceof TileEntityChemicalDissolutionChamber) {
            NBTTagCompound tag = CrossMekanism.setStorage(te);
            CrossMekanism.addUsage(tag, te);
            CrossMekanism.addTank("tank", tag, ((TileEntityChemicalDissolutionChamber)te).injectTank);
            CrossMekanism.addTank("tank2", tag, ((TileEntityChemicalDissolutionChamber)te).outputTank);
            return tag;
        }
        if (te instanceof TileEntityChemicalWasher) {
            NBTTagCompound tag = CrossMekanism.setStorage(te);
            CrossMekanism.addUsage(tag, te);
            FluidInfo.addTank("tank", tag, ((TileEntityChemicalWasher)te).fluidTank);
            CrossMekanism.addTank("tank2", tag, ((TileEntityChemicalWasher)te).inputTank);
            CrossMekanism.addTank("tank3", tag, ((TileEntityChemicalWasher)te).outputTank);
            return tag;
        }
        if (te instanceof TileEntityChemicalCrystallizer) {
            NBTTagCompound tag = CrossMekanism.setStorage(te);
            CrossMekanism.addUsage(tag, te);
            CrossMekanism.addTank("tank", tag, ((TileEntityChemicalCrystallizer)te).inputTank);
            return tag;
        }
        if (te instanceof TileEntitySeismicVibrator) {
            NBTTagCompound tag = CrossMekanism.setStorage(te);
            return tag;
        }
        if (te instanceof TileEntityResistiveHeater) {
            NBTTagCompound tag = CrossMekanism.setStorage(te);
            if (((TileEntityResistiveHeater)te).getActive()) {
                tag.func_74780_a("usage", MekanismUtils.convertToDisplay((double)((TileEntityResistiveHeater)te).energyUsage));
                tag.func_74757_a("active", true);
            } else {
                tag.func_74780_a("usage", 0.0);
                tag.func_74757_a("active", false);
            }
            tag.func_74778_a("temp", CrossMekanism.getTempString(((TileEntityResistiveHeater)te).temperature + 300.0));
            return tag;
        }
        if (te instanceof TileEntityLaser) {
            NBTTagCompound tag = CrossMekanism.setStorage(te);
            return tag;
        }
        if (te instanceof TileEntityLaserAmplifier) {
            NBTTagCompound tag = new NBTTagCompound();
            UnitDisplayUtils.EnergyType euType = (UnitDisplayUtils.EnergyType)MekanismConfig.current().general.energyUnit.val();
            tag.func_74778_a("euType", euType.name());
            tag.func_74780_a("energy", MekanismUtils.convertToDisplay((double)((TileEntityLaserAmplifier)te).getEnergy()));
            tag.func_74780_a("capacity", MekanismUtils.convertToDisplay((double)((TileEntityLaserAmplifier)te).getMaxEnergy()));
            return tag;
        }
        if (te instanceof TileEntityBoilerCasing) {
            SynchronizedBoilerData boiler = (SynchronizedBoilerData)((TileEntityBoilerCasing)te).getSynchronizedData();
            if (boiler == null) {
                return null;
            }
            NBTTagCompound tag = CrossMekanism.setStorage(te);
            tag.func_74780_a("boil_rate", (double)boiler.lastBoilRate);
            tag.func_74778_a("temp", CrossMekanism.getTempString(boiler.getTemp() + 300.0));
            FluidInfo.addTank("tank", tag, boiler.waterStored);
            FluidInfo.addTank("tank2", tag, boiler.steamStored);
            return tag;
        }
        if (te instanceof TileEntityInductionCasing) {
            SynchronizedMatrixData matrix = (SynchronizedMatrixData)((TileEntityInductionCasing)te).getSynchronizedData();
            if (matrix == null) {
                return null;
            }
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74778_a("euType", CrossMekanism.getEUType());
            tag.func_74780_a("energy", MekanismUtils.convertToDisplay((double)matrix.getEnergy()));
            tag.func_74780_a("capacity", MekanismUtils.convertToDisplay((double)matrix.getStorageCap()));
            tag.func_74780_a("input", MekanismUtils.convertToDisplay((double)matrix.getLastInput()));
            tag.func_74780_a("output", MekanismUtils.convertToDisplay((double)matrix.getLastOutput()));
            return tag;
        }
        if (te instanceof TileEntityFormulaicAssemblicator) {
            NBTTagCompound tag = CrossMekanism.setStorage(te);
            return tag;
        }
        if (te instanceof TileEntitySolarNeutronActivator) {
            NBTTagCompound tag = new NBTTagCompound();
            CrossMekanism.addTank("tank", tag, ((TileEntitySolarNeutronActivator)te).inputTank);
            CrossMekanism.addTank("tank2", tag, ((TileEntitySolarNeutronActivator)te).outputTank);
            return tag;
        }
        if (te instanceof TileEntityFuelwoodHeater) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74757_a("active", ((TileEntityFuelwoodHeater)te).getActive());
            tag.func_74778_a("temp", CrossMekanism.getTempString(((TileEntityFuelwoodHeater)te).temperature + 300.0));
            return tag;
        }
        if (te instanceof TileEntityFluidicPlenisher) {
            NBTTagCompound tag = CrossMekanism.setStorage(te);
            tag.func_74780_a("usage", MekanismUtils.convertToDisplay((double)((TileEntityFluidicPlenisher)te).energyPerTick));
            FluidInfo.addTank("tank", tag, ((TileEntityFluidicPlenisher)te).fluidTank);
            return tag;
        }
        if (te instanceof TileEntityPRC) {
            NBTTagCompound tag = CrossMekanism.setStorage(te);
            CrossMekanism.addUsage(tag, te);
            FluidInfo.addTank("tank", tag, ((TileEntityPRC)te).inputFluidTank);
            CrossMekanism.addTank("tank2", tag, ((TileEntityPRC)te).inputGasTank);
            CrossMekanism.addTank("tank3", tag, ((TileEntityPRC)te).outputGasTank);
            return tag;
        }
        return null;
    }

    private static void addUsage(NBTTagCompound tag, TileEntity te) {
        if (!(te instanceof TileEntityMachine)) {
            return;
        }
        if (((TileEntityMachine)te).getActive()) {
            tag.func_74780_a("usage", MekanismUtils.convertToDisplay((double)((TileEntityMachine)te).energyPerTick));
            tag.func_74757_a("active", true);
        } else {
            tag.func_74780_a("usage", 0.0);
            tag.func_74757_a("active", false);
        }
    }

    public static void addTank(String name, NBTTagCompound tag, GasTank tank) {
        GasStack stack = tank.getGas();
        if (stack == null) {
            tag.func_74778_a(name, "N/A");
        } else {
            tag.func_74778_a(name, String.format("%s: %s mB", stack.getGas().getLocalizedName(), stack.amount));
        }
    }

    public static void addTank(String name, NBTTagCompound tag, InfuseStorage tank) {
        InfuseType type = tank.getType();
        if (type == null) {
            tag.func_74778_a(name, "N/A");
        } else {
            tag.func_74778_a(name, String.format("%s: %s mB", type.getLocalizedName(), tank.getAmount()));
        }
    }

    public static void addTank(String name, NBTTagCompound tag, FluidSlot tank, String fluid) {
        if (tank.fluidStored == 0) {
            tag.func_74778_a(name, "N/A");
        } else {
            tag.func_74778_a(name, String.format("%s: %s mB", I18n.func_74838_a((String)"gui.bioGenerator.bioFuel"), tank.fluidStored));
        }
    }

    public static NBTTagCompound setStorage(TileEntity te) {
        NBTTagCompound tag = new NBTTagCompound();
        if (!(te instanceof TileEntityElectricBlock)) {
            return tag;
        }
        TileEntityElectricBlock tile = (TileEntityElectricBlock)te;
        tag.func_74778_a("euType", CrossMekanism.getEUType());
        tag.func_74780_a("energy", MekanismUtils.convertToDisplay((double)tile.getEnergy()));
        tag.func_74780_a("capacity", MekanismUtils.convertToDisplay((double)tile.getMaxEnergy()));
        return tag;
    }

    public static String getTempString(double temp) {
        switch ((UnitDisplayUtils.TempType)MekanismConfig.current().general.tempUnit.val()) {
            case K: {
                return CrossMekanism.formatTemp(UnitDisplayUtils.TemperatureUnit.KELVIN, temp);
            }
            case C: {
                return CrossMekanism.formatTemp(UnitDisplayUtils.TemperatureUnit.CELSIUS, temp);
            }
            case R: {
                return CrossMekanism.formatTemp(UnitDisplayUtils.TemperatureUnit.RANKINE, temp);
            }
            case F: {
                return CrossMekanism.formatTemp(UnitDisplayUtils.TemperatureUnit.FAHRENHEIT, temp);
            }
            case STP: {
                return CrossMekanism.formatTemp(UnitDisplayUtils.TemperatureUnit.AMBIENT, temp);
            }
        }
        return "";
    }

    private static String formatTemp(UnitDisplayUtils.TemperatureUnit unit, double temp) {
        return String.format("%.3f %s", unit.convertFromK(temp, true), unit.symbol);
    }

    public static String getEUType() {
        return ((UnitDisplayUtils.EnergyType)MekanismConfig.current().general.energyUnit.val()).name();
    }

    @Override
    public ArrayList getHookValues(TileEntity te) {
        ArrayList values = MekanismHooks.map.get(te);
        if (values == null) {
            MekanismHooks.map.put(te, null);
        }
        return values;
    }
}

