/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.energycontrol.items.cards;

import com.zuxelus.energycontrol.api.CardState;
import com.zuxelus.energycontrol.api.ICardReader;
import com.zuxelus.energycontrol.api.PanelSetting;
import com.zuxelus.energycontrol.api.PanelString;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class ItemCardBase {
    protected String name;
    protected int damage;

    public ItemCardBase(int damage, String name) {
        this.damage = damage;
        this.name = name;
    }

    public final int getDamage() {
        return this.damage;
    }

    public final String getName() {
        return this.name;
    }

    public final String getUnlocalizedName() {
        return "item." + this.name;
    }

    public boolean isRemoteCard() {
        return true;
    }

    public abstract CardState update(World var1, ICardReader var2, int var3, BlockPos var4);

    public abstract List<PanelString> getStringData(int var1, ICardReader var2, boolean var3, boolean var4);

    public abstract List<PanelSetting> getSettingsList();

    protected BlockPos getCoordinates(ICardReader reader, int cardNumber) {
        if (cardNumber >= reader.getCardCount()) {
            return null;
        }
        return new BlockPos(reader.getInt(String.format("_%dx", cardNumber)).intValue(), reader.getInt(String.format("_%dy", cardNumber)).intValue(), reader.getInt(String.format("_%dz", cardNumber)).intValue());
    }

    protected void addHeat(List<PanelString> result, String name, int heat, int maxHeat, boolean showLabels) {
        int rate;
        PanelString line = new PanelString(name, heat, showLabels);
        int n = rate = maxHeat == 0 ? 0 : 10 * heat / maxHeat;
        line.colorLeft = rate < 4 ? 65280 : (rate < 8 ? 0xFFFF00 : 0xFF0000);
        result.add(line);
    }

    protected void addOnOff(List<PanelString> result, boolean isServer, boolean value) {
        String text;
        int txtColor;
        if (value) {
            txtColor = 65280;
            text = isServer ? "On" : I18n.func_135052_a((String)"msg.ec.InfoPanelOn", (Object[])new Object[0]);
        } else {
            txtColor = 0xFF0000;
            String string = text = isServer ? "Off" : I18n.func_135052_a((String)"msg.ec.InfoPanelOff", (Object[])new Object[0]);
        }
        if (result.size() > 0) {
            PanelString firstLine = result.get(0);
            if (firstLine.textCenter == null) {
                firstLine.textRight = text;
                firstLine.colorRight = txtColor;
                return;
            }
            if (result.size() > 1) {
                firstLine = result.get(1);
                firstLine.textRight = text;
                firstLine.colorRight = txtColor;
                return;
            }
        }
        PanelString line = new PanelString();
        line.textLeft = text;
        line.colorLeft = txtColor;
        result.add(line);
    }
}

