/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.energycontrol.items.cards;

import com.zuxelus.energycontrol.api.CardState;
import com.zuxelus.energycontrol.api.ICardReader;
import com.zuxelus.energycontrol.api.PanelSetting;
import com.zuxelus.energycontrol.api.PanelString;
import com.zuxelus.energycontrol.crossmod.CrossModLoader;
import com.zuxelus.energycontrol.items.cards.ItemCardBase;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemCardDraconicEvolution
extends ItemCardBase {
    public ItemCardDraconicEvolution() {
        super(21, "card_draconic_evolution");
    }

    @Override
    public CardState update(World world, ICardReader reader, int range, BlockPos pos) {
        BlockPos target = reader.getTarget();
        if (target == null) {
            return CardState.NO_TARGET;
        }
        NBTTagCompound tag = CrossModLoader.getCrossMod("draconicevolution").getCardData(world, target);
        if (tag == null) {
            return CardState.NO_TARGET;
        }
        reader.reset();
        reader.copyFrom(tag);
        return CardState.OK;
    }

    @Override
    public List<PanelString> getStringData(int settings, ICardReader reader, boolean isServer, boolean showLabels) {
        List<PanelString> result = reader.getTitleList();
        if (reader.hasField("energy") && (settings & 2) > 0) {
            result.add(new PanelString("msg.ec.InfoPanelEnergy", reader.getLong("energy").longValue(), "RF", showLabels));
        }
        if (reader.hasField("capacity") && (settings & 2) > 0) {
            result.add(new PanelString("msg.ec.InfoPanelCapacity", reader.getLong("capacity").longValue(), "RF", showLabels));
        }
        if (reader.hasField("diff") && (settings & 0x40) > 0) {
            result.add(new PanelString("msg.ec.InfoPanelDifference", reader.getLong("diff").longValue(), "RF/t", showLabels));
        }
        if (reader.hasField("tier") && (settings & 0x40) > 0) {
            result.add(new PanelString("msg.ec.InfoPanelTier", reader.getInt("tier").intValue(), showLabels));
        }
        if (reader.hasField("connections") && (settings & 0x40) > 0) {
            result.add(new PanelString("msg.ec.InfoPanelConnections", reader.getInt("connections").intValue(), showLabels));
        }
        if (reader.hasField("flowLow") && (settings & 0x40) > 0) {
            result.add(new PanelString("msg.ec.InfoPanelSignalLow", reader.getInt("flowLow").intValue(), "RF/t", showLabels));
        }
        if (reader.hasField("flowHigh") && (settings & 0x40) > 0) {
            result.add(new PanelString("msg.ec.InfoPanelSignalHigh", reader.getInt("flowHigh").intValue(), "RF/t", showLabels));
        }
        if (reader.hasField("flowLowMB") && (settings & 0x40) > 0) {
            result.add(new PanelString("msg.ec.InfoPanelSignalLow", reader.getInt("flowLowMB").intValue(), "mB/t", showLabels));
        }
        if (reader.hasField("flowHighMB") && (settings & 0x40) > 0) {
            result.add(new PanelString("msg.ec.InfoPanelSignalHigh", reader.getInt("flowHighMB").intValue(), "mB/t", showLabels));
        }
        if (reader.hasField("status") && (settings & 1) > 0) {
            result.add(new PanelString("msg.ec.InfoPanelStatus", reader.getString("status"), showLabels));
        }
        if (reader.hasField("temp") && (settings & 8) > 0) {
            result.add(new PanelString("msg.ec.InfoPanelCoreHeat", reader.getInt("temp").intValue(), "\u00b0C", showLabels));
        }
        if (reader.hasField("consumption") && (settings & 4) > 0) {
            result.add(new PanelString("msg.ec.InfoPanelConsumption", reader.getDouble("consumption"), "RF/t", showLabels));
        }
        if (reader.hasField("output") && (settings & 4) > 0) {
            result.add(new PanelString("msg.ec.InfoPanelOutput", reader.getDouble("output"), "RF/t", showLabels));
        }
        if (reader.hasField("shield") && (settings & 0x40) > 0) {
            result.add(new PanelString("msg.ec.InfoPanelFieldStrength", reader.getDouble("shield"), "%", showLabels));
        }
        if (reader.hasField("saturation") && (settings & 0x40) > 0) {
            result.add(new PanelString("msg.ec.InfoPanelSaturation", reader.getDouble("saturation"), "%", showLabels));
        }
        if (reader.hasField("fuelMax") && (settings & 0x10) > 0) {
            result.add(new PanelString("msg.ec.InfoPanelFuel", reader.getDouble("fuelMax"), showLabels));
        }
        if (reader.hasField("fuel") && (settings & 0x10) > 0) {
            result.add(new PanelString("msg.ec.InfoPanelConvertedFuel", reader.getDouble("fuel"), showLabels));
        }
        if (reader.hasField("fuelRate") && (settings & 0x10) > 0) {
            result.add(new PanelString("msg.ec.InfoPanelConversionRate", reader.getDouble("fuelRate") * 1000000.0, "nb/t", showLabels));
        }
        if (reader.hasField("diam") && (settings & 0x40) > 0) {
            result.add(new PanelString("msg.ec.InfoPanelDiameter", reader.getDouble("diam"), showLabels));
        }
        if (reader.hasField("active")) {
            this.addOnOff(result, isServer, reader.getBoolean("active"));
        }
        return result;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<PanelSetting> getSettingsList() {
        ArrayList<PanelSetting> result = new ArrayList<PanelSetting>(6);
        result.add(new PanelSetting(I18n.func_135052_a((String)"msg.ec.cbInfoPanelStatus", (Object[])new Object[0]), 1));
        result.add(new PanelSetting(I18n.func_135052_a((String)"msg.ec.cbInfoPanelEnergy", (Object[])new Object[0]), 2));
        result.add(new PanelSetting(I18n.func_135052_a((String)"msg.ec.cbInfoPanelOutput", (Object[])new Object[0]), 4));
        result.add(new PanelSetting(I18n.func_135052_a((String)"msg.ec.cbInfoPanelHeat", (Object[])new Object[0]), 8));
        result.add(new PanelSetting(I18n.func_135052_a((String)"msg.ec.cbInfoPanelFuel", (Object[])new Object[0]), 16));
        result.add(new PanelSetting(I18n.func_135052_a((String)"msg.ec.cbInfoPanelOther", (Object[])new Object[0]), 64));
        return result;
    }
}

