/*
 * Decompiled with CFR 0.152.
 */
package com.mia.craftstudio.minecraft;

import com.mia.craftstudio.minecraft.ImmutableDirectionHolder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.util.EnumFacing;

public class DirectionHelper {
    public static final EnumFacing[] allDirections = new EnumFacing[]{EnumFacing.SOUTH, EnumFacing.WEST, EnumFacing.NORTH, EnumFacing.EAST, EnumFacing.UP, EnumFacing.DOWN};
    public static final EnumFacing[] flatDirections = new EnumFacing[]{EnumFacing.SOUTH, EnumFacing.WEST, EnumFacing.NORTH, EnumFacing.EAST};
    public static final Set<ImmutableDirectionHolder> directions;
    private static final Map<String, ImmutableDirectionHolder> s2triptype;

    public static ImmutableDirectionHolder getDirection(String s) {
        ImmutableDirectionHolder retval = s2triptype.get(s.toLowerCase());
        if (retval == null) {
            throw new RuntimeException(String.format("Invalid direction request : %s", s));
        }
        return retval;
    }

    public static Set<ImmutableDirectionHolder> getAllDirections() {
        return directions;
    }

    static {
        s2triptype = new HashMap<String, ImmutableDirectionHolder>();
        for (EnumFacing fd1 : allDirections) {
            String fd1Letter = fd1.toString().substring(0, 1);
            s2triptype.put(fd1Letter, new ImmutableDirectionHolder(fd1));
            for (EnumFacing fd2 : allDirections) {
                if (fd1.func_176734_d() == fd2) continue;
                String fd2Letter = fd2.toString().substring(0, 1);
                s2triptype.put(fd1Letter + fd2Letter, new ImmutableDirectionHolder(fd1, fd2));
                for (EnumFacing fd3 : allDirections) {
                    if (fd1.func_176734_d() == fd3 || fd2.func_176734_d() == fd3) continue;
                    String fd3Letter = fd3.toString().substring(0, 1);
                    s2triptype.put(fd1Letter + fd2Letter + fd3Letter, new ImmutableDirectionHolder(fd1, fd2, fd3));
                }
            }
        }
        directions = new HashSet<ImmutableDirectionHolder>(s2triptype.values());
    }
}

