/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.backpacks.client.gui.config;

import java.text.DecimalFormat;
import java.util.Optional;
import net.mcft.copy.backpacks.client.gui.Direction;
import net.mcft.copy.backpacks.client.gui.config.IConfigValue;
import net.mcft.copy.backpacks.client.gui.control.GuiSlider;
import net.mcft.copy.backpacks.config.Setting;
import net.mcft.copy.backpacks.config.SettingDouble;
import net.mcft.copy.backpacks.config.SettingInteger;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.StringUtils;

@SideOnly(value=Side.CLIENT)
public abstract class EntryValueSlider<T>
extends GuiSlider
implements IConfigValue<T>,
IConfigValue.Setup<T> {
    public EntryValueSlider() {
        this.setHeight(18);
    }

    public static class Percentage
    extends RangeDouble {
        public Percentage() {
            this.setRange(0.0, 1.0);
        }

        @Override
        public void setRange(Direction direction, double min, double max) {
            super.setRange(direction, min, max);
            double range = this.getMax(Direction.HORIZONTAL) - this.getMin(Direction.HORIZONTAL);
            int numDecimals = (int)Math.ceil(Math.max(0.0, 1.5 - Math.log10(range)));
            DecimalFormat formatter = new DecimalFormat("0." + StringUtils.repeat((char)'#', (int)numDecimals));
            this.setValueFormatter(val -> formatter.format(val * 100.0) + "%");
            this.setStepSize(1.0 / Math.pow(10.0, numDecimals));
        }
    }

    public static class RangeInteger
    extends EntryValueSlider<Integer> {
        public RangeInteger(int min, int max) {
            this.setRange(min, max);
        }

        public RangeInteger() {
            this.setValueFormatter(val -> Long.toString(Math.round(val)));
            this.setStepSize(1.0);
        }

        @Override
        public void setup(Setting<Integer> setting) {
            SettingInteger settingI = (SettingInteger)setting;
            this.setRange(settingI.getMinValue(), settingI.getMaxValue());
        }

        @Override
        public Optional<Integer> getValue() {
            return Optional.of((int)Math.round(this.getSliderValue()));
        }

        @Override
        public void setValue(Integer value) {
            this.setSliderValue(value.intValue());
        }
    }

    public static class RangeDouble
    extends EntryValueSlider<Double> {
        public RangeDouble(double min, double max, double step) {
            this(min, max);
            this.setStepSize(step);
        }

        public RangeDouble(double min, double max) {
            this.setRange(min, max);
        }

        public RangeDouble() {
        }

        @Override
        public void setup(Setting<Double> setting) {
            SettingDouble settingD = (SettingDouble)setting;
            this.setRange(settingD.getMinValue(), settingD.getMaxValue());
        }

        @Override
        public Optional<Double> getValue() {
            return Optional.of(this.getSliderValue());
        }

        @Override
        public void setValue(Double value) {
            this.setSliderValue(value);
        }
    }
}

