/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.backpacks.client.gui.control;

import java.util.function.Predicate;
import net.mcft.copy.backpacks.client.gui.Direction;
import net.mcft.copy.backpacks.client.gui.GuiElementBase;
import net.minecraft.client.gui.GuiTextField;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiField
extends GuiElementBase {
    public static final int DEFAULT_WIDTH = 200;
    public static final int DEFAULT_HEIGHT = 20;
    public static final int COLOR_TEXT_DEFAULT = -2039584;
    public static final int COLOR_BACKGROUND_DEFAULT = -16777216;
    public static final int COLOR_BORDER_DEFAULT = -6250336;
    public static final int COLOR_TEXT_DISABLED = -9408400;
    private final GuiTextField _field = new GuiTextField(0, GuiField.getFontRenderer(), 1, 1, 0, 0);
    private int _colorText = -2039584;
    private int _colorBackground = -16777216;
    private int _colorBorder = -6250336;
    private Runnable _changedAction = null;
    private Predicate<Character> _charValidator = null;

    public GuiField() {
        this(200);
    }

    public GuiField(int width) {
        this(width, 20);
    }

    public GuiField(int width, int height) {
        this(width, height, "");
    }

    public GuiField(String text) {
        this(200, text);
    }

    public GuiField(int width, String text) {
        this(width, 20, text);
    }

    public GuiField(int width, int height, String text) {
        this(0, 0, width, height, text);
    }

    public GuiField(int x, int y, int width, int height, String text) {
        this.setPosition(x, y);
        this.setSize(width, height);
        this.setText(text);
        this.setMaxLength(Integer.MAX_VALUE);
    }

    public String getText() {
        return this._field.func_146179_b();
    }

    public void setText(String value) {
        if (value == null) {
            throw new NullPointerException("Argument can't be null");
        }
        if (value.equals(this.getText())) {
            return;
        }
        this._field.func_146180_a(value);
        this._field.func_146196_d();
    }

    public int getMaxLength() {
        return this._field.func_146208_g();
    }

    public void setMaxLength(int value) {
        this._field.func_146203_f(value);
    }

    public int getCursorPosition() {
        return this._field.func_146198_h();
    }

    public void setTextColor(int value) {
        this._colorText = (value & 0xFF000000) == 0 ? value | 0xFF000000 : value;
    }

    public void resetTextColor() {
        this.setTextColor(-2039584);
    }

    public void setBackgroundColor(int value) {
        this._colorBackground = (value & 0xFF000000) == 0 ? value | 0xFF000000 : value;
    }

    public void resetBackgroundColor() {
        this.setBorderColor(-16777216);
    }

    public void setBorderColor(int value) {
        this._colorBorder = (value & 0xFF000000) == 0 ? value | 0xFF000000 : value;
    }

    public void resetBorderColor() {
        this.setBorderColor(-6250336);
    }

    public void setChangedAction(Runnable value) {
        this._changedAction = value;
    }

    protected void onTextChanged() {
        if (this._changedAction != null) {
            this._changedAction.run();
        }
    }

    public void setCharValidator(Predicate<Character> value) {
        this._charValidator = value;
    }

    protected boolean isCharValid(char chr) {
        return this._charValidator != null ? this._charValidator.test(Character.valueOf(chr)) : true;
    }

    @Override
    public boolean canFocus() {
        return true;
    }

    @Override
    public void onSizeChanged(Direction direction) {
        if (direction == Direction.HORIZONTAL) {
            this._field.field_146218_h = this.getWidth() - 2;
        } else {
            this._field.field_146219_i = this.getHeight() - 2;
        }
    }

    @Override
    public void onPressed(int mouseX, int mouseY) {
        this._field.func_146192_a(mouseX, mouseY, GuiElementBase.MouseButton.LEFT);
    }

    @Override
    public void onKey(int keyCode, char keyChar) {
        if (!this.isEnabled() && keyCode != 203 && keyCode != 205 && keyCode != 199 && keyCode != 207) {
            return;
        }
        String beforeText = this.getText();
        if (!Character.isISOControl(keyChar) && !this.isCharValid(keyChar)) {
            return;
        }
        this._field.func_146201_a(keyChar, keyCode);
        if (!this.getText().equals(beforeText)) {
            this.onTextChanged();
        }
    }

    @Override
    public void draw(int mouseX, int mouseY, float partialTicks) {
        if (!this.isVisible()) {
            return;
        }
        GuiField.enableBlendAlphaStuffs();
        GuiField.setRenderColorARGB(this._colorBackground);
        GuiField.drawRect(1, 1, this.getWidth() - 2, this.getHeight() - 2);
        GuiField.setRenderColorARGB(this._colorBorder);
        GuiField.drawOutline(0, 0, this.getWidth(), this.getHeight());
        GuiField.disableBlendAlphaStuffs();
        this._field.func_146185_a(false);
        this._field.field_146209_f = 5;
        this._field.field_146210_g = (this.getHeight() - 8) / 2;
        this._field.field_146218_h -= 8;
        this._field.func_146193_g(this._colorText);
        this._field.func_146184_c(this.isEnabled());
        this._field.func_146195_b(this.isFocused());
        this._field.func_146194_f();
        this._field.field_146210_g = 1;
        this._field.field_146209_f = 1;
        this._field.field_146218_h += 8;
        this._field.func_146185_a(true);
    }
}

