/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.api.fuel;

import java.util.HashSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;

public class FuelRegistry {
    public static final FuelRegistry instance = new FuelRegistry();

    public boolean registerFuel(@Nonnull FuelType type, Fluid fluid, float multiplier) {
        FuelEntry entry = new FuelEntry(fluid, multiplier);
        return type.addFuel(entry);
    }

    public boolean registerFuel(@Nonnull FuelType type, @Nonnull ItemStack item, float multiplier) {
        FuelEntry entry = new FuelEntry(item, multiplier);
        return type.addFuel(entry);
    }

    public boolean isFuel(@Nullable FuelType type, @Nonnull ItemStack stack) {
        return this.isFuel(type, (Object)stack);
    }

    public boolean isFuel(@Nullable FuelType type, Fluid fluid) {
        return this.isFuel(type, (Object)fluid);
    }

    private boolean isFuel(@Nullable FuelType type, Object obj) {
        if (type == null) {
            return false;
        }
        return type.isFuel(obj);
    }

    public float getMultiplier(@Nullable FuelType type, @Nonnull ItemStack stack) {
        return this.getMultiplier(type, (Object)stack);
    }

    public float getMultiplier(@Nullable FuelType type, Fluid fluid) {
        return this.getMultiplier(type, (Object)fluid);
    }

    private float getMultiplier(@Nullable FuelType type, Object obj) {
        if (type == null) {
            return 0.0f;
        }
        FuelEntry fuel = type.getFuel(obj);
        if (fuel == null) {
            return 0.0f;
        }
        return fuel.multiplier;
    }

    private static class FuelEntry {
        private Object fuel;
        private FuelType type;
        private float multiplier;

        public FuelEntry(@Nonnull Object fuel, float multiplier) {
            this.fuel = fuel;
            this.multiplier = multiplier;
        }

        public boolean fuelMatches(@Nullable Object obj) {
            if (obj == null || this.fuel.getClass() != obj.getClass()) {
                return false;
            }
            if (this.fuel instanceof ItemStack) {
                return ItemStack.func_77989_b((ItemStack)((ItemStack)this.fuel), (ItemStack)((ItemStack)obj));
            }
            if (this.fuel instanceof Fluid) {
                return this.fuel.equals(obj);
            }
            return false;
        }

        public boolean equals(@Nullable Object obj) {
            if (obj != null) {
                if (obj instanceof FuelEntry) {
                    FuelEntry cmp = (FuelEntry)obj;
                    return this.fuelMatches(cmp.fuel) && cmp.type == this.type;
                }
                return super.equals(obj);
            }
            return false;
        }
    }

    public static enum FuelType {
        LIQUID_MONOPROPELLANT,
        LIQUID_BIPROPELLANT,
        LIQUID_OXIDIZER,
        NUCLEAR_WORKING_FLUID,
        ION,
        WARP,
        IMPULSE;

        final HashSet<FuelEntry> fuels = new HashSet();

        public boolean addFuel(@Nonnull FuelEntry entry) {
            entry.type = this;
            return !this.fuels.add(entry);
        }

        public boolean isFuel(@Nonnull ItemStack stack) {
            return this.isFuel((Object)stack);
        }

        public boolean isFuel(Fluid stack) {
            return this.isFuel((Object)stack);
        }

        private boolean isFuel(@Nullable Object obj) {
            if (obj == null) {
                return false;
            }
            for (FuelEntry fuel : this.fuels) {
                if (fuel.fuel != obj) continue;
                return true;
            }
            return false;
        }

        public FuelEntry getFuel(@Nonnull ItemStack stack) {
            return this.getFuel((Object)stack);
        }

        public FuelEntry getFuel(Fluid fluid) {
            return this.getFuel((Object)fluid);
        }

        private FuelEntry getFuel(Object obj) {
            for (FuelEntry fuel : this.fuels) {
                FuelEntry entry = fuel;
                if (!entry.fuelMatches(obj)) continue;
                return entry;
            }
            return null;
        }
    }
}

