/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.tile.station;

import io.netty.buffer.ByteBuf;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.fml.relauncher.Side;
import zmaster587.advancedRocketry.api.AdvancedRocketryBlocks;
import zmaster587.advancedRocketry.api.stations.ISpaceObject;
import zmaster587.advancedRocketry.inventory.TextureResources;
import zmaster587.advancedRocketry.network.PacketStationUpdate;
import zmaster587.advancedRocketry.stations.SpaceObjectManager;
import zmaster587.advancedRocketry.stations.SpaceStationObject;
import zmaster587.advancedRocketry.world.provider.WorldProviderSpace;
import zmaster587.libVulpes.LibVulpes;
import zmaster587.libVulpes.inventory.modules.IButtonInventory;
import zmaster587.libVulpes.inventory.modules.IModularInventory;
import zmaster587.libVulpes.inventory.modules.ISliderBar;
import zmaster587.libVulpes.inventory.modules.ModuleBase;
import zmaster587.libVulpes.inventory.modules.ModuleButton;
import zmaster587.libVulpes.inventory.modules.ModuleSlider;
import zmaster587.libVulpes.inventory.modules.ModuleText;
import zmaster587.libVulpes.network.BasePacket;
import zmaster587.libVulpes.network.PacketHandler;
import zmaster587.libVulpes.network.PacketMachine;
import zmaster587.libVulpes.util.INetworkMachine;

public class TileStationOrientationController
extends TileEntity
implements ITickable,
IModularInventory,
INetworkMachine,
ISliderBar,
IButtonInventory {
    private int[] progress;
    private ModuleText moduleAngularVelocity = new ModuleText(6, 15, LibVulpes.proxy.getLocalizedString("msg.stationorientctrl.alt"), 0xAA2020);
    private ModuleText numThrusters;
    private ModuleText maxAngularAcceleration;
    private ModuleText targetRotations = new ModuleText(6, 25, LibVulpes.proxy.getLocalizedString("msg.stationorientctrl.tgtalt"), 0x202020);

    public TileStationOrientationController() {
        this.progress = new int[3];
        this.progress[0] = this.getTotalProgress(0) / 2;
        this.progress[1] = this.getTotalProgress(1) / 2;
        this.progress[2] = this.getTotalProgress(2) / 2;
    }

    public List<ModuleBase> getModules(int id, EntityPlayer player) {
        LinkedList<ModuleBase> modules = new LinkedList<ModuleBase>();
        modules.add((ModuleBase)this.moduleAngularVelocity);
        modules.add((ModuleBase)this.targetRotations);
        modules.add((ModuleBase)new ModuleText(10, 54, "X:", 0x202020));
        modules.add((ModuleBase)new ModuleText(10, 69, "Y:", 0x202020));
        modules.add((ModuleBase)new ModuleSlider(24, 50, 0, TextureResources.doubleWarningSideBarIndicator, (ISliderBar)this));
        modules.add((ModuleBase)new ModuleSlider(24, 65, 1, TextureResources.doubleWarningSideBarIndicator, (ISliderBar)this));
        modules.add((ModuleBase)new ModuleButton(25, 35, 2, LibVulpes.proxy.getLocalizedString("msg.spacelaser.reset"), (IButtonInventory)this, zmaster587.libVulpes.inventory.TextureResources.buttonBuild, 36, 15));
        this.updateText();
        return modules;
    }

    private void updateText() {
        ISpaceObject spaceObject;
        if (this.field_145850_b.field_72995_K && (spaceObject = SpaceObjectManager.getSpaceManager().getSpaceStationFromBlockCoords(this.field_174879_c)) != null) {
            this.moduleAngularVelocity.setText(String.format("%s%.1f %.1f %.1f", LibVulpes.proxy.getLocalizedString("msg.stationorientctrl.alt"), 72000.0 * spaceObject.getDeltaRotation(EnumFacing.EAST), 72000.0 * spaceObject.getDeltaRotation(EnumFacing.UP), 7200.0 * spaceObject.getDeltaRotation(EnumFacing.NORTH)));
            int[] targetRotationsPerHour = ((SpaceStationObject)spaceObject).targetRotationsPerHour;
            this.targetRotations.setText(String.format("%s%d %d %d", LibVulpes.proxy.getLocalizedString("msg.stationorientctrl.tgtalt"), targetRotationsPerHour[0], targetRotationsPerHour[1], targetRotationsPerHour[2]));
        }
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_73011_w instanceof WorldProviderSpace) {
            if (!this.field_145850_b.field_72995_K) {
                ISpaceObject spaceObject = SpaceObjectManager.getSpaceManager().getSpaceStationFromBlockCoords(this.field_174879_c);
                boolean update = false;
                if (spaceObject != null) {
                    int i;
                    EnumFacing[] dirs = new EnumFacing[]{EnumFacing.EAST, EnumFacing.UP, EnumFacing.NORTH};
                    int[] targetRotationsPerHour = ((SpaceStationObject)spaceObject).targetRotationsPerHour;
                    for (i = 0; i < 3; ++i) {
                        this.setProgress(i, targetRotationsPerHour[i] + this.getTotalProgress(i) / 2);
                    }
                    for (i = 0; i < 3; ++i) {
                        double targetAngularVelocity = (double)targetRotationsPerHour[i] / 72000.0;
                        double angVel = spaceObject.getDeltaRotation(dirs[i]);
                        double acc = spaceObject.getMaxRotationalAcceleration();
                        double difference = targetAngularVelocity - angVel;
                        if (difference == 0.0) continue;
                        double finalVel = angVel;
                        if (difference < 0.0) {
                            finalVel = angVel + Math.max(difference, -acc);
                        } else if (difference > 0.0) {
                            finalVel = angVel + Math.min(difference, acc);
                        }
                        spaceObject.setDeltaRotation(finalVel, dirs[i]);
                        update = true;
                    }
                    if (!this.field_145850_b.field_72995_K && update) {
                        PacketHandler.sendToAll((BasePacket)new PacketStationUpdate(spaceObject, PacketStationUpdate.Type.ROTANGLE_UPDATE));
                    }
                } else {
                    this.updateText();
                }
            } else {
                this.updateText();
            }
        }
    }

    public String getModularInventoryName() {
        return AdvancedRocketryBlocks.blockOrientationController.func_149732_F();
    }

    public boolean canInteractWithContainer(EntityPlayer entity) {
        return true;
    }

    public void writeDataToNetwork(ByteBuf out, byte id) {
        if (id == 0) {
            out.writeShort(this.progress[0]);
            out.writeShort(this.progress[1]);
            out.writeShort(this.progress[2]);
        }
    }

    public void readDataFromNetwork(ByteBuf in, byte packetId, NBTTagCompound nbt) {
        if (packetId == 0) {
            this.setProgress(0, in.readShort());
            this.setProgress(1, in.readShort());
            this.setProgress(2, in.readShort());
        }
    }

    public void useNetworkData(EntityPlayer player, Side side, byte id, NBTTagCompound nbt) {
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        return nbt;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
    }

    public float getNormallizedProgress(int id) {
        return (float)this.getProgress(id) / (float)this.getTotalProgress(id);
    }

    public void setProgress(int id, int progress) {
        this.progress[id] = progress;
        if (SpaceObjectManager.getSpaceManager().getSpaceStationFromBlockCoords(this.field_174879_c) != null) {
            ((SpaceStationObject)SpaceObjectManager.getSpaceManager().getSpaceStationFromBlockCoords(this.field_174879_c)).setTargetRotationsPerHour(id, progress - this.getTotalProgress(id) / 2);
        }
    }

    public int getProgress(int id) {
        return this.progress[id];
    }

    public int getTotalProgress(int id) {
        return 120;
    }

    public void setTotalProgress(int id, int progress) {
    }

    public void setProgressByUser(int id, int progress) {
        this.setProgress(id, progress);
        PacketHandler.sendToServer((BasePacket)new PacketMachine((INetworkMachine)this, 0));
    }

    public void onInventoryButtonPressed(int i) {
        if (i == 2) {
            this.setProgress(0, this.getTotalProgress(0) / 2);
            this.setProgress(1, this.getTotalProgress(1) / 2);
            this.setProgress(2, this.getTotalProgress(2) / 2);
        }
        PacketHandler.sendToServer((BasePacket)new PacketMachine((INetworkMachine)this, 0));
    }
}

