/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.util;

import zmaster587.advancedRocketry.AdvancedRocketry;
import zmaster587.advancedRocketry.api.dimension.solar.StellarBody;

public class AstronomicalBodyHelper {
    public static float getBodySizeMultiplier(float orbitalDistance) {
        return 100.0f / orbitalDistance;
    }

    public static double getOrbitalPeriod(int orbitalDistance, float solarSize) {
        return 48.0 * Math.pow(Math.pow((double)orbitalDistance / (100.0 * (double)solarSize), 3.0), 0.5);
    }

    public static double getMoonOrbitalPeriod(float orbitalDistance, float planetaryMass) {
        return 8.0 * Math.pow(Math.pow((double)orbitalDistance / 100.0, 3.0) / (double)planetaryMass, 0.5);
    }

    public static double getOrbitalTheta(int orbitalDistance, float solarSize) {
        double orbitalPeriod = AstronomicalBodyHelper.getOrbitalPeriod(orbitalDistance, solarSize);
        return (double)AdvancedRocketry.proxy.getWorldTimeUniversal(0) % (24000.0 * orbitalPeriod) / (24000.0 * orbitalPeriod) * (Math.PI * 2);
    }

    public static double getMoonOrbitalTheta(int orbitalDistance, float parentGravitationalMultiplier) {
        double orbitalPeriod = AstronomicalBodyHelper.getMoonOrbitalPeriod(orbitalDistance, parentGravitationalMultiplier);
        return (double)AdvancedRocketry.proxy.getWorldTimeUniversal(0) % (24000.0 * orbitalPeriod) / (24000.0 * orbitalPeriod) * (Math.PI * 2);
    }

    public static float getParentPlanetThetaFromMoon(int rotationalPeriod, int orbitalDistance, float parentGravitationalMultiplier, double currentOrbitalTheta, double baseOrbitalTheta) {
        float degreeOrbitalTheta = (float)(currentOrbitalTheta * 180.0 / Math.PI);
        float planetPositionTheta = ((float)(AstronomicalBodyHelper.getMoonOrbitalPeriod(orbitalDistance, parentGravitationalMultiplier) * 24000.0) / (float)rotationalPeriod - 1.0f) * degreeOrbitalTheta;
        return (planetPositionTheta + (float)(baseOrbitalTheta * 180.0 / Math.PI)) % 360.0f;
    }

    public static int getAverageTemperature(StellarBody star, int orbitalDistance, int atmPressure) {
        int starSurfaceTemperature = 58 * star.getTemperature();
        float starRadius = star.getSize() / 215.0f;
        float planetaryOrbitalRadius = (float)orbitalDistance / 100.0f;
        double averageWithoutAtmosphere = (double)starSurfaceTemperature * Math.pow(starRadius / (2.0f * planetaryOrbitalRadius), 0.5) * Math.pow(0.7f, 0.25);
        return (int)(averageWithoutAtmosphere * Math.max(1.0, 1.125 * Math.pow((double)atmPressure / 100.0, 0.25)));
    }

    public static double getStellarBrightness(StellarBody star, int orbitalDistance) {
        float lightMultiplier = 1.0f;
        float normalizedStarTemperature = (float)star.getTemperature() / 100.0f;
        float planetaryOrbitalRadius = (float)orbitalDistance / 100.0f;
        boolean blackHole = star.isBlackHole();
        for (StellarBody star2 : star.getSubStars()) {
            if (star2.isBlackHole()) continue;
            blackHole = false;
            break;
        }
        if (blackHole) {
            lightMultiplier = (float)((double)lightMultiplier * 0.25);
        }
        return (double)lightMultiplier * (Math.pow(star.getSize(), 2.0) * Math.pow(normalizedStarTemperature, 4.0) / Math.pow(planetaryOrbitalRadius, 2.0));
    }

    public static double getPlanetaryLightLevelMultiplier(double stellarBrightnessMultiplier) {
        double log2Multiplier = Math.log10(stellarBrightnessMultiplier) / Math.log10(2.0);
        return Math.pow(1.5, log2Multiplier);
    }
}

