/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.util;

import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;
import zmaster587.advancedRocketry.AdvancedRocketry;
import zmaster587.advancedRocketry.util.Asteroid;

public class XMLAsteroidLoader {
    private Document doc = null;

    public boolean loadFile(File xmlFile) throws IOException {
        DocumentBuilder docBuilder;
        this.doc = null;
        try {
            docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            return false;
        }
        try {
            this.doc = docBuilder.parse(xmlFile);
        }
        catch (SAXException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public List<Asteroid> loadPropertyFile() {
        Node childNode = this.doc.getFirstChild().getFirstChild();
        LinkedList<Asteroid> mapping = new LinkedList<Asteroid>();
        while (childNode != null) {
            if (childNode.getNodeType() != 1 || !childNode.getNodeName().equalsIgnoreCase("asteroid")) {
                childNode = childNode.getNextSibling();
                continue;
            }
            Asteroid asteroid = new Asteroid();
            if (childNode.hasAttributes()) {
                NamedNodeMap att = childNode.getAttributes();
                Node node = att.getNamedItem("name");
                if (node != null) {
                    asteroid.ID = node.getTextContent();
                }
                if ((node = att.getNamedItem("distance")) != null) {
                    try {
                        asteroid.distance = Integer.parseInt(node.getTextContent());
                    }
                    catch (NumberFormatException e) {
                        AdvancedRocketry.logger.warn("Asteroid " + asteroid.ID + " has invalid distance value");
                    }
                }
                if ((node = att.getNamedItem("mass")) != null) {
                    try {
                        asteroid.mass = Integer.parseInt(node.getTextContent());
                    }
                    catch (NumberFormatException e) {
                        AdvancedRocketry.logger.warn("Asteroid " + asteroid.ID + " has invalid mass value");
                    }
                }
                if ((node = att.getNamedItem("minLevel")) != null) {
                    try {
                        asteroid.minLevel = Integer.parseInt(node.getTextContent());
                    }
                    catch (NumberFormatException e) {
                        AdvancedRocketry.logger.warn("Asteroid " + asteroid.ID + " has invalid minLevel value");
                    }
                }
                if ((node = att.getNamedItem("massVariability")) != null) {
                    try {
                        asteroid.massVariability = Float.parseFloat(node.getTextContent());
                    }
                    catch (NumberFormatException e) {
                        AdvancedRocketry.logger.warn("Asteroid " + asteroid.ID + " has invalid massVariability value");
                    }
                }
                if ((node = att.getNamedItem("richness")) != null) {
                    try {
                        asteroid.richness = Float.parseFloat(node.getTextContent());
                    }
                    catch (NumberFormatException e) {
                        AdvancedRocketry.logger.warn("Asteroid " + asteroid.ID + " has invalid richness value");
                    }
                }
                if ((node = att.getNamedItem("richnessVariability")) != null) {
                    try {
                        asteroid.richnessVariability = Float.parseFloat(node.getTextContent());
                    }
                    catch (NumberFormatException e) {
                        AdvancedRocketry.logger.warn("Asteroid " + asteroid.ID + " has invalid richnessVariability value");
                    }
                }
                if ((node = att.getNamedItem("probability")) != null) {
                    try {
                        asteroid.probability = Float.parseFloat(node.getTextContent());
                    }
                    catch (NumberFormatException e) {
                        AdvancedRocketry.logger.warn("Asteroid " + asteroid.ID + " has invalid probability value");
                    }
                }
                if ((node = att.getNamedItem("timeMultiplier")) != null) {
                    try {
                        asteroid.timeMultiplier = Float.parseFloat(node.getTextContent());
                    }
                    catch (NumberFormatException e) {
                        AdvancedRocketry.logger.warn("Asteroid " + asteroid.ID + " has invalid timeMultiplier value");
                    }
                } else {
                    asteroid.timeMultiplier = 1.0f;
                }
                if ((node = att.getNamedItem("baseStack")) != null) {
                    ItemStack stack = XMLAsteroidLoader.getStack(node.getTextContent());
                    if (!stack.func_190926_b()) {
                        asteroid.baseStack = stack;
                    } else {
                        AdvancedRocketry.logger.warn("Asteroid " + asteroid.ID + " has invalid baseStack: " + node.getTextContent());
                    }
                } else {
                    asteroid.baseStack = new ItemStack(Blocks.field_150347_e);
                }
            }
            Node asteroidNode = childNode.getFirstChild();
            while (asteroidNode != null) {
                block40: {
                    if (asteroidNode.getNodeType() != 1 || !asteroidNode.getNodeName().equalsIgnoreCase("ore")) {
                        asteroidNode = asteroidNode.getNextSibling();
                        continue;
                    }
                    if (asteroidNode.getNodeName().equalsIgnoreCase("ore")) {
                        NamedNodeMap att = asteroidNode.getAttributes();
                        Node nodeStack = att.getNamedItem("itemStack");
                        Node nodeChance = att.getNamedItem("chance");
                        if (nodeStack != null && nodeChance != null) {
                            ItemStack stack = XMLAsteroidLoader.getStack(nodeStack.getTextContent());
                            if (stack.func_190926_b()) {
                                AdvancedRocketry.logger.warn("Asteroid " + asteroid.ID + " has invalid ore: " + nodeStack.getTextContent());
                                asteroidNode = asteroidNode.getNextSibling();
                                continue;
                            }
                            asteroid.itemStacks.add(stack);
                            try {
                                asteroid.stackProbabilities.add(Float.valueOf(Float.parseFloat(nodeChance.getTextContent())));
                                break block40;
                            }
                            catch (NumberFormatException e) {
                                AdvancedRocketry.logger.warn("Asteroid " + asteroid.ID + " has invalid stack probability: " + nodeChance.getTextContent());
                                asteroid.itemStacks.remove(asteroid.itemStacks.size() - 1);
                                asteroidNode = asteroidNode.getNextSibling();
                                continue;
                            }
                        }
                        AdvancedRocketry.logger.warn("Asteroid " + asteroid.ID + " expected 'itemStack' and 'chance' tags, at least one is missing");
                    }
                }
                asteroidNode = asteroidNode.getNextSibling();
            }
            mapping.add(asteroid);
            childNode = childNode.getNextSibling();
        }
        return mapping;
    }

    @Nonnull
    public static ItemStack getStack(String text) {
        String[] splitStr = text.contains(";") ? text.split(";") : text.split(" ");
        int meta = 0;
        int size = 1;
        if (splitStr.length > 1) {
            try {
                meta = Integer.parseInt(splitStr[1].trim());
            }
            catch (NumberFormatException e) {
                AdvancedRocketry.logger.warn("Unable to parse int in asteroid config: \"" + splitStr[1] + "\"");
            }
        }
        ItemStack stack = ItemStack.field_190927_a;
        Block block = Block.func_149684_b((String)splitStr[0].trim());
        if (block == null) {
            Item item = Item.func_111206_d((String)splitStr[0].trim());
            if (item != null) {
                stack = new ItemStack(item, size, meta);
            }
        } else {
            stack = new ItemStack(block, size, meta);
        }
        return stack;
    }
}

