/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.api;

import net.geforcemods.securitycraft.api.Option;
import net.minecraft.nbt.NBTTagCompound;

public interface ICustomizable {
    public Option<?>[] customOptions();

    default public void onOptionChanged(Option<?> option) {
    }

    default public void readOptions(NBTTagCompound tag) {
        Option<?>[] options = this.customOptions();
        if (options.length > 0) {
            for (Option<?> option : options) {
                option.load(tag);
            }
        }
    }

    default public NBTTagCompound writeOptions(NBTTagCompound tag) {
        Option<?>[] options = this.customOptions();
        if (options.length > 0) {
            for (Option<?> option : options) {
                option.save(tag);
            }
        }
        return tag;
    }
}

