/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blockentities;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.ILockable;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.blockentities.DisguisableBlockEntity;
import net.geforcemods.securitycraft.blocks.BlockChangeDetectorBlock;
import net.geforcemods.securitycraft.misc.BlockEntityTracker;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;

public class BlockChangeDetectorBlockEntity
extends DisguisableBlockEntity
implements IInventory,
ILockable,
ITickable {
    private Option.IntOption signalLength = new Option.IntOption(() -> ((BlockChangeDetectorBlockEntity)this).func_174877_v(), "signalLength", 60, 5, 400, 5, true);
    private Option.IntOption range = new Option.IntOption(() -> ((BlockChangeDetectorBlockEntity)this).func_174877_v(), "range", 5, 1, 15, 1, true);
    private Option.DisabledOption disabled = new Option.DisabledOption(false);
    private Option.IgnoreOwnerOption ignoreOwner = new Option.IgnoreOwnerOption(true);
    private EnumDetectionMode mode = EnumDetectionMode.BOTH;
    private boolean tracked = false;
    private List<ChangeEntry> entries = new ArrayList<ChangeEntry>();
    private final List<ChangeEntry> filteredEntries = new ArrayList<ChangeEntry>();
    private ItemStack filter = ItemStack.field_190927_a;
    private boolean showHighlights = false;
    private int color = -16776961;

    public void log(EntityPlayer player, EnumDetectionMode action, BlockPos changedPos, IBlockState state) {
        if (this.isDisabled()) {
            return;
        }
        if (this.mode != EnumDetectionMode.BOTH && action != this.mode) {
            return;
        }
        if (this.isOwnedBy(player) && this.ignoresOwner() || this.isAllowed((Entity)player)) {
            return;
        }
        BlockPos thisPos = this.func_174877_v();
        if (changedPos.equals((Object)thisPos)) {
            return;
        }
        if (this.isModuleEnabled(ModuleType.SMART) && this.filter.func_77973_b() instanceof ItemBlock) {
            if (((ItemBlock)this.filter.func_77973_b()).func_179223_d() == state.func_177230_c()) {
                if (this.filter.func_77960_j() != state.func_177230_c().func_176201_c(state)) {
                    return;
                }
            } else {
                return;
            }
        }
        IBlockState thisState = this.field_145850_b.func_180495_p(thisPos);
        if (this.isModuleEnabled(ModuleType.REDSTONE)) {
            this.field_145850_b.func_175656_a(thisPos, thisState.func_177226_a((IProperty)BlockChangeDetectorBlock.POWERED, (Comparable)Boolean.valueOf(true)));
            BlockUtils.updateIndirectNeighbors(this.field_145850_b, thisPos, SCContent.blockChangeDetector);
            this.field_145850_b.func_175684_a(thisPos, SCContent.blockChangeDetector, ((Integer)this.signalLength.get()).intValue());
        }
        this.entries.add(new ChangeEntry(player.func_70005_c_(), player.func_146103_bH().getId(), System.currentTimeMillis(), action, changedPos, state));
        this.func_70296_d();
        this.sync();
    }

    public void func_73660_a() {
        if (!this.tracked) {
            BlockEntityTracker.BLOCK_CHANGE_DETECTOR.track(this);
            this.tracked = true;
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        NBTTagList entryList = new NBTTagList();
        this.entries.stream().map(ChangeEntry::save).forEach(arg_0 -> ((NBTTagList)entryList).func_74742_a(arg_0));
        tag.func_74768_a("mode", this.mode.ordinal());
        tag.func_74782_a("entries", (NBTBase)entryList);
        tag.func_74782_a("filter", (NBTBase)this.filter.func_77955_b(new NBTTagCompound()));
        tag.func_74757_a("ShowHighlights", this.showHighlights);
        tag.func_74768_a("Color", this.color);
        return tag;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        int modeOrdinal = tag.func_74762_e("mode");
        if (modeOrdinal < 0 || modeOrdinal >= EnumDetectionMode.values().length) {
            modeOrdinal = 0;
        }
        this.mode = EnumDetectionMode.values()[modeOrdinal];
        this.entries = new ArrayList<ChangeEntry>();
        tag.func_150295_c("entries", 10).forEach(element -> this.entries.add(ChangeEntry.load((NBTTagCompound)element)));
        this.filter = new ItemStack(tag.func_74775_l("filter"));
        this.showHighlights = tag.func_74767_n("ShowHighlights");
        this.setColor(tag.func_74762_e("Color"));
        this.updateFilteredEntries();
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        BlockEntityTracker.BLOCK_CHANGE_DETECTOR.stopTracking(this);
    }

    @Override
    public ITextComponent func_145748_c_() {
        return super.func_145748_c_();
    }

    public void setMode(EnumDetectionMode mode) {
        this.mode = mode;
        if (!this.field_145850_b.field_72995_K) {
            this.func_70296_d();
        }
    }

    public EnumDetectionMode getMode() {
        return this.mode;
    }

    public int getRange() {
        return (Integer)this.range.get();
    }

    public List<ChangeEntry> getEntries() {
        return this.entries;
    }

    public boolean isDisabled() {
        return (Boolean)this.disabled.get();
    }

    public boolean ignoresOwner() {
        return (Boolean)this.ignoreOwner.get();
    }

    public List<ChangeEntry> getFilteredEntries() {
        return this.filteredEntries;
    }

    public void updateFilteredEntries() {
        this.filteredEntries.clear();
        this.entries.stream().filter(this::isEntryShown).forEach(this.filteredEntries::add);
    }

    public boolean isEntryShown(ChangeEntry entry) {
        EnumDetectionMode currentMode = this.getMode();
        if (currentMode == EnumDetectionMode.BOTH || currentMode == entry.action) {
            if (this.filter.func_77973_b() instanceof ItemBlock) {
                Block block = entry.state.func_177230_c();
                return ((ItemBlock)this.filter.func_77973_b()).func_179223_d() == block && block.func_176201_c(entry.state) == this.filter.func_77960_j();
            }
            return true;
        }
        return false;
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[]{ModuleType.DISGUISE, ModuleType.ALLOWLIST, ModuleType.SMART, ModuleType.REDSTONE};
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.signalLength, this.range, this.disabled, this.ignoreOwner};
    }

    public void func_174888_l() {
        this.filter = ItemStack.field_190927_a;
        this.func_70296_d();
    }

    public int func_70302_i_() {
        return 1;
    }

    public int func_70297_j_() {
        return 1;
    }

    public boolean func_191420_l() {
        return this.filter.func_190926_b();
    }

    public ItemStack func_70298_a(int index, int count) {
        ItemStack stack = this.filter;
        if (count >= 1) {
            this.filter = ItemStack.field_190927_a;
            this.func_70296_d();
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack func_70304_b(int index) {
        ItemStack stack = this.filter;
        this.filter = ItemStack.field_190927_a;
        this.func_70296_d();
        return stack;
    }

    public void func_70299_a(int index, ItemStack stack) {
        if (stack.func_77973_b() instanceof ItemBlock) {
            if (!stack.func_190926_b() && stack.func_190916_E() > this.func_70297_j_()) {
                stack = new ItemStack(stack.func_77973_b(), this.func_70297_j_());
            }
            this.filter = stack;
            this.func_70296_d();
        }
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    @Override
    public boolean enableHack() {
        return true;
    }

    public ItemStack func_70301_a(int slot) {
        return slot >= 100 ? this.getModuleInSlot(slot) : (slot == 36 ? this.filter : ItemStack.field_190927_a);
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return this.isModuleEnabled(ModuleType.SMART) && stack.func_77973_b() instanceof ItemBlock;
    }

    public void showHighlights(boolean showHighlights) {
        this.showHighlights = showHighlights;
    }

    public boolean isShowingHighlights() {
        return this.showHighlights;
    }

    public void setColor(int color) {
        this.color = MathHelper.func_76125_a((int)color, (int)-16777216, (int)-1);
    }

    public int getColor() {
        return this.color;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public static class ChangeEntry {
        public final String player;
        public final UUID uuid;
        public final long timestamp;
        public final EnumDetectionMode action;
        public final BlockPos pos;
        public final IBlockState state;

        public ChangeEntry(String player, UUID uuid, long timestamp, EnumDetectionMode action, BlockPos pos, IBlockState state) {
            this.player = player;
            this.uuid = uuid;
            this.timestamp = timestamp;
            this.action = action;
            this.pos = pos;
            this.state = state;
        }

        public NBTTagCompound save() {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74778_a("player", this.player);
            tag.func_186854_a("uuid", this.uuid);
            tag.func_74772_a("timestamp", this.timestamp);
            tag.func_74768_a("action", this.action.ordinal());
            tag.func_74772_a("pos", this.pos.func_177986_g());
            tag.func_74782_a("state", (NBTBase)NBTUtil.func_190009_a((NBTTagCompound)new NBTTagCompound(), (IBlockState)this.state));
            return tag;
        }

        public static ChangeEntry load(NBTTagCompound tag) {
            int actionOrdinal = tag.func_74762_e("action");
            if (actionOrdinal < 0 || actionOrdinal >= EnumDetectionMode.values().length) {
                actionOrdinal = 0;
            }
            return new ChangeEntry(tag.func_74779_i("player"), tag.func_186857_a("uuid"), tag.func_74763_f("timestamp"), EnumDetectionMode.values()[actionOrdinal], BlockPos.func_177969_a((long)tag.func_74763_f("pos")), NBTUtil.func_190008_d((NBTTagCompound)tag.func_74775_l("state")));
        }
    }

    public static enum EnumDetectionMode {
        BREAK("gui.securitycraft:block_change_detector.mode.break"),
        PLACE("gui.securitycraft:block_change_detector.mode.place"),
        BOTH("gui.securitycraft:block_change_detector.mode.both");

        private String descriptionId;

        private EnumDetectionMode(String desciptionId) {
            this.descriptionId = desciptionId;
        }

        public String getDescriptionId() {
            return this.descriptionId;
        }
    }
}

