/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blockentities;

import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.blockentities.DisguisableBlockEntity;
import net.geforcemods.securitycraft.blocks.SometimesVisibleBlock;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.misc.TargetingMode;
import net.geforcemods.securitycraft.util.EntityUtils;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.ITextComponent;

public class FloorTrapBlockEntity
extends DisguisableBlockEntity
implements ITickable {
    private Option.IgnoreOwnerOption ignoreOwner = new Option.IgnoreOwnerOption(true);
    private Option.BooleanOption disappearInstantlyInChains = new Option.BooleanOption("disappearInstantlyInChains", true);
    private Option.IntOption disappearDelay = new Option.IntOption(() -> ((FloorTrapBlockEntity)this).func_174877_v(), "disappearDelay", 5, 0, 200, 1, true);
    private Option.IntOption reappearDelay = new Option.IntOption(() -> ((FloorTrapBlockEntity)this).func_174877_v(), "reappearDelay", 20, 5, 200, 1, true);
    private Option.EnumOption<TargetingMode> targetingMode = new Option.EnumOption<TargetingMode>("targetingMode", TargetingMode.PLAYERS, TargetingMode.class){

        @Override
        public ITextComponent getValueName() {
            return ((TargetingMode)((Object)this.value)).translate();
        }
    };
    private boolean shouldDisappear = false;
    private boolean shouldReappear = false;
    private int ticksUntilDisappearing = -1;
    private int ticksUntilReappearing = -1;

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (!this.shouldReappear && this.shouldDisappear) {
            if (this.ticksUntilDisappearing-- <= 0) {
                this.disappear();
            }
            return;
        }
        TargetingMode mode = (TargetingMode)((Object)this.targetingMode.get());
        AxisAlignedBB area = new AxisAlignedBB((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o() + 1.0, (double)this.field_174879_c.func_177952_p(), (double)this.field_174879_c.func_177958_n() + 1.0, (double)this.field_174879_c.func_177956_o() + 1.1666, (double)this.field_174879_c.func_177952_p() + 1.0);
        this.shouldDisappear = this.field_145850_b.func_175647_a(EntityLivingBase.class, area, e -> !(e instanceof EntityPlayer && ((EntityPlayer)e).func_175149_v() || this.allowsOwnableEntity((Entity)e) || this.isAllowed((Entity)e) || EntityUtils.doesEntityOwn((Entity)e, this.field_145850_b, this.field_174879_c) && this.ignoresOwner())).stream().anyMatch(entity -> mode.allowsPlayers() && entity instanceof EntityPlayer || mode.allowsMobs());
        if (this.shouldReappear && this.ticksUntilReappearing-- <= 0 && !this.shouldDisappear) {
            this.reappear();
        }
        this.scheduleDisappear(false);
    }

    public void scheduleDisappear(boolean force) {
        this.scheduleDisappear((Integer)this.disappearDelay.get(), force);
    }

    public void scheduleDisappear(int delay, boolean force) {
        if (force) {
            this.shouldDisappear = true;
        }
        if (this.shouldDisappear) {
            this.ticksUntilDisappearing = delay;
        }
    }

    public void disappear() {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.field_145850_b.func_175656_a(this.field_174879_c, state.func_177226_a((IProperty)SometimesVisibleBlock.INVISIBLE, (Comparable)Boolean.valueOf(true)));
        this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187524_aN, SoundCategory.BLOCKS, 1.0f, 2.0f);
        this.shouldDisappear = false;
        this.scheduleReappear();
    }

    public void scheduleReappear() {
        this.scheduleReappear((Integer)this.reappearDelay.get());
    }

    public void scheduleReappear(int delay) {
        this.shouldReappear = true;
        this.ticksUntilReappearing = delay;
    }

    public void reappear() {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.field_145850_b.func_175656_a(this.field_174879_c, state.func_177226_a((IProperty)SometimesVisibleBlock.INVISIBLE, (Comparable)Boolean.valueOf(false)));
        this.shouldReappear = false;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74757_a("should_disappear", this.shouldDisappear);
        tag.func_74757_a("should_reappear", this.shouldReappear);
        tag.func_74768_a("ticks_until_disappearing", this.ticksUntilDisappearing);
        tag.func_74768_a("ticks_until_reappearing", this.ticksUntilReappearing);
        return tag;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.shouldDisappear = tag.func_74767_n("should_disappear");
        this.shouldReappear = tag.func_74767_n("should_reappear");
        this.ticksUntilDisappearing = tag.func_74762_e("ticks_until_disappearing");
        this.ticksUntilReappearing = tag.func_74762_e("ticks_until_reappearing");
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[]{ModuleType.DISGUISE, ModuleType.ALLOWLIST, ModuleType.SMART};
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.ignoreOwner, this.targetingMode, this.disappearInstantlyInChains, this.disappearDelay, this.reappearDelay};
    }

    public boolean ignoresOwner() {
        return (Boolean)this.ignoreOwner.get();
    }

    public boolean shouldDisappearInstantlyInChains() {
        return (Boolean)this.disappearInstantlyInChains.get();
    }
}

