/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blockentities;

import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.blockentities.KeycardReaderBlockEntity;
import net.geforcemods.securitycraft.items.KeycardItem;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;

public class KeycardLockBlockEntity
extends KeycardReaderBlockEntity {
    protected Option.BooleanOption exactLevel = new Option.BooleanOption("exactLevel", true);
    private boolean setUp = false;

    @Override
    public boolean onRightClickWithActionItem(ItemStack stack, EnumHand hand, EntityPlayer player, boolean isCodebreaker, boolean isKeycardHolder) {
        if (!this.isSetUp() && this.isOwnedBy(player)) {
            if (stack.func_77973_b() instanceof KeycardItem) {
                String keySuffix;
                KeycardItem item = (KeycardItem)stack.func_77973_b();
                boolean[] levels = new boolean[]{false, false, false, false, false};
                if (((Boolean)this.exactLevel.get()).booleanValue()) {
                    levels[item.getLevel()] = true;
                    keySuffix = "exact";
                } else {
                    for (int i = item.getLevel(); i < 5; ++i) {
                        levels[i] = true;
                    }
                    keySuffix = "above";
                }
                if (!stack.func_77942_o()) {
                    stack.func_77982_d(new NBTTagCompound());
                }
                this.setUp = true;
                this.setAcceptedLevels(levels);
                this.setSignature(stack.func_77978_p().func_74762_e("signature"));
                PlayerUtils.sendMessageToPlayer(player, (ITextComponent)Utils.localize(this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c(), new Object[0]), (ITextComponent)Utils.localize("messages.securitycraft:keycard_lock.setup_successful." + keySuffix, item.getLevel() + 1), TextFormatting.GREEN);
                return true;
            }
            PlayerUtils.sendMessageToPlayer(player, (ITextComponent)Utils.localize(this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c(), new Object[0]), (ITextComponent)Utils.localize("messages.securitycraft:keycard_lock.not_set_up", new Object[0]), TextFormatting.RED);
            return false;
        }
        return super.onRightClickWithActionItem(stack, hand, player, isCodebreaker, isKeycardHolder);
    }

    public boolean isSetUp() {
        return this.setUp;
    }

    public void reset() {
        this.setUp = false;
        this.setAcceptedLevels(new boolean[]{false, false, false, false, false});
        this.setSignature(0);
    }

    @Override
    public void onOptionChanged(Option<?> option) {
        if (option.getName().equals(this.exactLevel.getName())) {
            boolean[] acceptedLevels = this.getAcceptedLevels();
            boolean swap = false;
            for (int i = 0; i < acceptedLevels.length; ++i) {
                if (swap) {
                    acceptedLevels[i] = !acceptedLevels[i];
                    continue;
                }
                if (!acceptedLevels[i]) continue;
                swap = true;
            }
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74757_a("set_up", this.setUp);
        return tag;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.setUp = tag.func_74767_n("set_up");
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[]{ModuleType.DENYLIST};
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.sendMessage, this.signalLength, this.disabled, this.exactLevel};
    }
}

