/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blockentities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.CustomizableBlockEntity;
import net.geforcemods.securitycraft.api.IEMPAffectedBE;
import net.geforcemods.securitycraft.api.ILockable;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.blocks.SonicSecuritySystemBlock;
import net.geforcemods.securitycraft.items.SonicSecuritySystemItem;
import net.geforcemods.securitycraft.misc.BlockEntityTracker;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.misc.SCSounds;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.minecraft.block.properties.IProperty;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;

public class SonicSecuritySystemBlockEntity
extends CustomizableBlockEntity
implements ITickable,
IEMPAffectedBE {
    private static final int PING_DELAY = 100;
    private static final int LISTEN_DELAY = 60;
    public static final int MAX_RANGE = 30;
    public static final int MAX_LINKED_BLOCKS = 30;
    private boolean emitsPings = true;
    private int pingCooldown = 100;
    private Option.IntOption signalLength = new Option.IntOption(() -> ((SonicSecuritySystemBlockEntity)this).func_174877_v(), "signalLength", 60, 5, 400, 5, true);
    private int powerCooldown = 0;
    private float radarRotationDegrees = 0.0f;
    private float oRadarRotationDegrees = 0.0f;
    private Set<BlockPos> linkedBlocks = new HashSet<BlockPos>();
    private boolean isActive = true;
    private boolean isRecording = false;
    private ArrayList<NoteWrapper> recordedNotes = new ArrayList();
    private boolean wasCorrectTunePlayed = false;
    private boolean isListening = false;
    private int listeningTimer = 60;
    private int listenPos = 0;
    private boolean tracked = false;
    private boolean shutDown = false;
    private boolean disableBlocksWhenTuneIsPlayed = false;

    public void func_73660_a() {
        if (!this.tracked) {
            BlockEntityTracker.SONIC_SECURITY_SYSTEM.track(this);
            this.tracked = true;
        }
        if (!this.field_145850_b.field_72995_K) {
            if (!this.isActive()) {
                return;
            }
            if (this.wasCorrectTunePlayed()) {
                if (this.powerCooldown > 0) {
                    --this.powerCooldown;
                } else {
                    this.wasCorrectTunePlayed = false;
                    this.field_145850_b.func_175656_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c).func_177226_a((IProperty)SonicSecuritySystemBlock.POWERED, (Comparable)Boolean.valueOf(false)));
                    BlockUtils.updateIndirectNeighbors(this.field_145850_b, this.field_174879_c, SCContent.sonicSecuritySystem, EnumFacing.DOWN);
                }
            }
            if (this.isListening) {
                if (this.listeningTimer > 0) {
                    --this.listeningTimer;
                    return;
                }
                this.stopListening();
            }
            if (!this.isLinkedToBlock()) {
                return;
            }
            if (this.pingCooldown > 0) {
                --this.pingCooldown;
            } else {
                ArrayList<BlockPos> blocksToRemove = new ArrayList<BlockPos>();
                for (BlockPos blockPos : this.linkedBlocks) {
                    if (this.field_145850_b.func_175625_s(blockPos) instanceof ILockable) continue;
                    blocksToRemove.add(blockPos);
                }
                for (BlockPos posToRemove : blocksToRemove) {
                    this.delink(posToRemove, false);
                    this.sync();
                }
                if (this.emitsPings && !this.isRecording) {
                    this.field_145850_b.func_184133_a(null, this.field_174879_c, SCSounds.PING.event, SoundCategory.BLOCKS, 0.3f, 1.0f);
                }
                this.pingCooldown = 100;
            }
        } else {
            this.oRadarRotationDegrees = this.getRadarRotationDegrees();
            if (this.isActive() || this.isRecording()) {
                this.radarRotationDegrees = this.getRadarRotationDegrees() + 0.15f;
                if (this.getRadarRotationDegrees() >= 360.0f) {
                    this.radarRotationDegrees = 0.0f;
                }
            }
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        BlockEntityTracker.SONIC_SECURITY_SYSTEM.stopTracking(this);
    }

    @Override
    public void onModuleRemoved(ItemStack stack, ModuleType module, boolean toggled) {
        if (module == ModuleType.REDSTONE) {
            this.field_145850_b.func_175656_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c).func_177226_a((IProperty)SonicSecuritySystemBlock.POWERED, (Comparable)Boolean.valueOf(false)));
            BlockUtils.updateIndirectNeighbors(this.field_145850_b, this.field_174879_c, SCContent.sonicSecuritySystem, EnumFacing.DOWN);
        }
        super.onModuleRemoved(stack, module, toggled);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        if (!this.linkedBlocks.isEmpty() && !tag.func_74764_b("LinkedBlocks")) {
            tag.func_74782_a("LinkedBlocks", (NBTBase)new NBTTagList());
        }
        for (BlockPos blockToSave : this.linkedBlocks) {
            NBTTagCompound nbt = NBTUtil.func_186859_a((BlockPos)blockToSave);
            tag.func_150295_c("LinkedBlocks", 10).func_74742_a((NBTBase)nbt);
            if (this.linkedBlocks.contains(blockToSave)) continue;
            this.linkedBlocks.add(blockToSave);
        }
        this.saveNotes(tag);
        tag.func_74757_a("emitsPings", this.emitsPings);
        tag.func_74757_a("isActive", this.isActive);
        tag.func_74757_a("isRecording", this.isRecording);
        tag.func_74757_a("isListening", this.isListening);
        tag.func_74768_a("listenPos", this.listenPos);
        tag.func_74757_a("correctTuneWasPlayed", this.wasCorrectTunePlayed());
        tag.func_74768_a("powerCooldown", this.powerCooldown);
        tag.func_74757_a("shutDown", this.shutDown);
        tag.func_74757_a("disableBlocksWhenTuneIsPlayed", this.disableBlocksWhenTuneIsPlayed);
        return tag;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        if (tag.func_74764_b("LinkedBlocks")) {
            NBTTagList list = tag.func_150295_c("LinkedBlocks", 10);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound linkedBlock = list.func_150305_b(i);
                BlockPos linkedBlockPos = NBTUtil.func_186861_c((NBTTagCompound)linkedBlock);
                this.linkedBlocks.add(linkedBlockPos);
            }
        }
        this.recordedNotes.clear();
        SonicSecuritySystemBlockEntity.loadNotes(tag, this.recordedNotes);
        if (tag.func_74764_b("emitsPings")) {
            this.emitsPings = tag.func_74767_n("emitsPings");
        }
        if (tag.func_74764_b("isActive")) {
            this.isActive = tag.func_74767_n("isActive");
        }
        this.isRecording = tag.func_74767_n("isRecording");
        this.isListening = tag.func_74767_n("isListening");
        this.listenPos = tag.func_74762_e("listenPos");
        this.wasCorrectTunePlayed = tag.func_74767_n("correctTuneWasPlayed");
        this.powerCooldown = tag.func_74762_e("powerCooldown");
        this.shutDown = tag.func_74767_n("shutDown");
        this.disableBlocksWhenTuneIsPlayed = tag.func_74767_n("disableBlocksWhenTuneIsPlayed");
    }

    public void saveNotes(NBTTagCompound tag) {
        NBTTagList notes = new NBTTagList();
        for (NoteWrapper note : this.recordedNotes) {
            NBTTagCompound noteNbt = new NBTTagCompound();
            noteNbt.func_74768_a("noteID", note.noteID);
            noteNbt.func_74778_a("instrument", note.instrumentName);
            notes.func_74742_a((NBTBase)noteNbt);
        }
        tag.func_74782_a("Notes", (NBTBase)notes);
    }

    public static <T extends Collection<NoteWrapper>> void loadNotes(NBTTagCompound tag, T recordedNotes) {
        if (tag.func_74764_b("Notes")) {
            NBTTagList list = tag.func_150295_c("Notes", 10);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound note = list.func_150305_b(i);
                recordedNotes.add((NoteWrapper)new NoteWrapper(note.func_74762_e("noteID"), note.func_74779_i("instrument")));
            }
        }
    }

    public void transferPositionsFromItem(NBTTagCompound itemTag) {
        Set<BlockPos> positions = SonicSecuritySystemItem.stackTagToBlockPosSet(itemTag);
        positions.removeIf(this::isLinkedToBlock);
        this.linkedBlocks.addAll(positions);
        if (!this.linkedBlocks.isEmpty()) {
            this.sync();
        }
    }

    public boolean isLinkedToBlock() {
        return !this.linkedBlocks.isEmpty();
    }

    public boolean isLinkedToBlock(BlockPos linkedBlockPos) {
        if (this.linkedBlocks.isEmpty()) {
            return false;
        }
        return this.linkedBlocks.contains(linkedBlockPos);
    }

    public void delink(BlockPos linkedBlockPos, boolean shouldSync) {
        if (this.linkedBlocks.isEmpty()) {
            return;
        }
        this.linkedBlocks.remove(linkedBlockPos);
        if (shouldSync) {
            this.sync();
        }
    }

    public void delinkAll() {
        this.linkedBlocks.clear();
        this.sync();
    }

    public int getNumberOfLinkedBlocks() {
        return this.linkedBlocks.size();
    }

    public Set<BlockPos> getLinkedBlocks() {
        return this.linkedBlocks;
    }

    public boolean pings() {
        return this.emitsPings;
    }

    public void setPings(boolean pings) {
        this.emitsPings = pings;
    }

    public boolean isActive() {
        return this.isActive && !this.isShutDown();
    }

    public void setActive(boolean active) {
        this.isActive = active;
    }

    public boolean isRecording() {
        return this.isRecording;
    }

    public void setRecording(boolean recording) {
        this.isRecording = recording;
    }

    public boolean isListening() {
        return this.isListening;
    }

    public void startListening() {
        this.isListening = true;
    }

    public void stopListening() {
        this.resetListeningTimer();
        this.listenPos = 0;
        this.isListening = false;
        this.field_145850_b.func_175685_c(this.field_174879_c, SCContent.sonicSecuritySystem, false);
        if (!this.field_145850_b.field_72995_K) {
            this.sync();
        }
    }

    public void resetListeningTimer() {
        this.listeningTimer = 60;
    }

    public void recordNote(int noteID, String instrumentName) {
        this.recordedNotes.add(new NoteWrapper(noteID, instrumentName));
        if (!this.field_145850_b.field_72995_K) {
            this.sync();
        }
    }

    public void listenToNote(int noteID, String instrumentName) {
        if (this.getNumberOfNotes() == 0 || this.listenPos >= this.getNumberOfNotes()) {
            return;
        }
        if (!this.isListening) {
            this.isListening = true;
            this.sync();
        }
        if (this.recordedNotes.get(this.listenPos++).isSameNote(noteID, instrumentName)) {
            this.resetListeningTimer();
            if (this.listenPos >= this.recordedNotes.size()) {
                this.wasCorrectTunePlayed = true;
                this.powerCooldown = (Integer)this.signalLength.get();
                if (this.isModuleEnabled(ModuleType.REDSTONE)) {
                    this.field_145850_b.func_175656_a(this.func_174877_v(), this.func_145831_w().func_180495_p(this.func_174877_v()).func_177226_a((IProperty)SonicSecuritySystemBlock.POWERED, (Comparable)Boolean.valueOf(true)));
                    BlockUtils.updateIndirectNeighbors(this.field_145850_b, this.func_174877_v(), SCContent.sonicSecuritySystem, EnumFacing.DOWN);
                }
            }
        }
    }

    public List<NoteWrapper> getRecordedNotes() {
        return this.recordedNotes;
    }

    public int getNumberOfNotes() {
        return this.recordedNotes.size();
    }

    public void clearNotes() {
        this.recordedNotes.clear();
    }

    @Override
    public boolean isShutDown() {
        return this.shutDown;
    }

    @Override
    public void setShutDown(boolean shutDown) {
        this.shutDown = shutDown;
        this.sync();
    }

    public void setDisableBlocksWhenTuneIsPlayed(boolean disableBlocksWhenTuneIsPlayed) {
        this.disableBlocksWhenTuneIsPlayed = disableBlocksWhenTuneIsPlayed;
    }

    public boolean disablesBlocksWhenTuneIsPlayed() {
        return this.disableBlocksWhenTuneIsPlayed;
    }

    @Override
    public TileEntity getTileEntity() {
        return this;
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[]{ModuleType.ALLOWLIST, ModuleType.REDSTONE};
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.signalLength};
    }

    public boolean wasCorrectTunePlayed() {
        return this.wasCorrectTunePlayed;
    }

    public float getOriginalRadarRotationDegrees() {
        return this.oRadarRotationDegrees;
    }

    public float getRadarRotationDegrees() {
        return this.radarRotationDegrees;
    }

    public static class NoteWrapper {
        public final int noteID;
        public final String instrumentName;

        public NoteWrapper(int note, String instrument) {
            this.noteID = note;
            this.instrumentName = instrument;
        }

        public boolean isSameNote(int note, String instrument) {
            return this.noteID == note && this.instrumentName.equals(instrument);
        }
    }
}

