/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import java.util.function.Function;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.IPasscodeConvertible;
import net.geforcemods.securitycraft.api.IPasscodeProtected;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.blockentities.KeypadTrapdoorBlockEntity;
import net.geforcemods.securitycraft.blocks.reinforced.BaseIronTrapDoorBlock;
import net.geforcemods.securitycraft.misc.SaltData;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockTrapDoor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class KeypadTrapDoorBlock
extends BaseIronTrapDoorBlock {
    public KeypadTrapDoorBlock(Material mat) {
        super(mat);
    }

    @Override
    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (((Boolean)state.func_177229_b((IProperty)field_176283_b)).booleanValue()) {
            return false;
        }
        if (!world.field_72995_K) {
            KeypadTrapdoorBlockEntity be = (KeypadTrapdoorBlockEntity)world.func_175625_s(pos);
            if (be.isDisabled()) {
                player.func_146105_b((ITextComponent)Utils.localize("gui.securitycraft:scManual.disabled", new Object[0]), true);
            } else if (be.verifyPasscodeSet(world, pos, be, player)) {
                if (be.isDenied((Entity)player)) {
                    if (be.sendsMessages()) {
                        PlayerUtils.sendMessageToPlayer(player, (ITextComponent)Utils.localize((Block)this, new Object[0]), (ITextComponent)Utils.localize("messages.securitycraft:module.onDenylist", new Object[0]), TextFormatting.RED);
                    }
                } else if (be.isAllowed((Entity)player)) {
                    if (be.sendsMessages()) {
                        PlayerUtils.sendMessageToPlayer(player, (ITextComponent)Utils.localize((Block)this, new Object[0]), (ITextComponent)Utils.localize("messages.securitycraft:module.onAllowlist", new Object[0]), TextFormatting.GREEN);
                    }
                    this.activate(state, world, pos, be.getSignalLength());
                } else if (player.func_184586_b(hand).func_77973_b() != SCContent.codebreaker) {
                    be.openPasscodeGUI(world, pos, player);
                }
            }
        }
        return true;
    }

    public void activate(IBlockState state, World world, BlockPos pos, int signalLength) {
        world.func_175656_a(pos, state.func_177226_a((IProperty)field_176283_b, (Comparable)Boolean.valueOf(true)));
        world.func_175684_a(pos, (Block)this, signalLength);
        this.func_185731_a(null, world, pos, true);
    }

    @Override
    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity be = world.func_175625_s(pos);
        if (be instanceof IPasscodeProtected) {
            SaltData.removeSalt(((IPasscodeProtected)be).getSaltKey());
        }
        super.func_180663_b(world, pos, state);
    }

    @Override
    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos neighbor) {
    }

    @Override
    public TileEntity func_149915_a(World world, int meta) {
        return new KeypadTrapdoorBlockEntity();
    }

    public static class Convertible
    implements Function<Object, IPasscodeConvertible>,
    IPasscodeConvertible {
        @Override
        public IPasscodeConvertible apply(Object o) {
            return this;
        }

        @Override
        public boolean isValidStateForConversion(IBlockState state) {
            return state.func_177230_c() == SCContent.frame;
        }

        @Override
        public boolean convert(EntityPlayer player, World level, BlockPos pos) {
            IBlockState state = level.func_180495_p(pos);
            EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)BlockTrapDoor.field_176284_a);
            boolean open = (Boolean)state.func_177229_b((IProperty)BlockTrapDoor.field_176283_b);
            BlockTrapDoor.DoorHalf half = (BlockTrapDoor.DoorHalf)state.func_177229_b((IProperty)BlockTrapDoor.field_176285_M);
            TileEntity trapdoor = level.func_175625_s(pos);
            Owner oldOwner = ((IOwnable)trapdoor).getOwner();
            NBTTagCompound tag = trapdoor.func_189515_b(new NBTTagCompound());
            level.func_175656_a(pos, SCContent.keypadTrapdoor.func_176223_P().func_177226_a((IProperty)BlockTrapDoor.field_176284_a, (Comparable)facing).func_177226_a((IProperty)BlockTrapDoor.field_176283_b, (Comparable)Boolean.valueOf(open)).func_177226_a((IProperty)BlockTrapDoor.field_176285_M, (Comparable)half));
            trapdoor = level.func_175625_s(pos);
            trapdoor.func_145839_a(tag);
            ((IOwnable)trapdoor).setOwner(oldOwner.getUUID(), oldOwner.getName());
            return true;
        }
    }
}

