/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks.mines;

import java.util.List;
import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.api.OwnableBlockEntity;
import net.geforcemods.securitycraft.blocks.mines.ExplosiveBlock;
import net.geforcemods.securitycraft.compat.IOverlayDisplay;
import net.geforcemods.securitycraft.util.EntityUtils;
import net.geforcemods.securitycraft.util.IBlockMine;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BaseFullMineBlock
extends ExplosiveBlock
implements IOverlayDisplay,
IBlockMine {
    private final Block blockDisguisedAs;

    public BaseFullMineBlock(Material material, Block disguisedBlock, int harvestLevel, MapColor color) {
        super(material);
        this.blockDisguisedAs = disguisedBlock;
        this.field_181083_K = color;
        if (material == Material.field_151595_p) {
            this.func_149672_a(SoundType.field_185855_h);
            this.setHarvestLevel("shovel", harvestLevel);
        } else if (material == Material.field_151578_c) {
            this.func_149672_a(SoundType.field_185849_b);
            this.setHarvestLevel("shovel", harvestLevel);
        } else {
            this.func_149672_a(SoundType.field_185851_d);
            this.setHarvestLevel("pickaxe", harvestLevel);
        }
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess access, BlockPos pos) {
        return null;
    }

    public void func_185477_a(IBlockState state, World world, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, Entity entity, boolean isActualState) {
        if (entity instanceof EntityItem) {
            BaseFullMineBlock.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)field_185505_j);
        } else {
            TileEntity te = world.func_175625_s(pos);
            if (te instanceof OwnableBlockEntity) {
                EntityPlayer player;
                OwnableBlockEntity ownableTe = (OwnableBlockEntity)te;
                if (ownableTe.allowsOwnableEntity(entity)) {
                    BaseFullMineBlock.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)field_185505_j);
                    return;
                }
                if (entity instanceof EntityPlayer && (ownableTe.isOwnedBy(player = (EntityPlayer)entity) || player.func_184812_l_())) {
                    BaseFullMineBlock.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)field_185505_j);
                    return;
                }
            }
            BaseFullMineBlock.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)field_185506_k);
        }
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        if (!EntityUtils.doesEntityOwn(entity, world, pos)) {
            this.explode(world, pos);
        }
    }

    public void func_180652_a(World world, BlockPos pos, Explosion explosion) {
        if (!world.field_72995_K) {
            if (pos.equals((Object)new BlockPos(explosion.getPosition()))) {
                return;
            }
            this.explode(world, pos);
        }
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (!world.field_72995_K) {
            if (player != null && player.field_71075_bZ.field_75098_d && !ConfigHandler.mineExplodesWhenInCreative) {
                return super.removedByPlayer(state, world, pos, player, willHarvest);
            }
            if (!EntityUtils.doesPlayerOwn(player, world, pos)) {
                this.explode(world, pos);
                return super.removedByPlayer(state, world, pos, player, willHarvest);
            }
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    @Override
    public boolean activateMine(World world, BlockPos pos) {
        return false;
    }

    @Override
    public boolean defuseMine(World world, BlockPos pos) {
        return false;
    }

    @Override
    public void explode(World world, BlockPos pos) {
        if (!world.field_72995_K) {
            world.func_175655_b(pos, false);
            world.func_72885_a((Entity)null, (double)pos.func_177958_n(), (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p(), ConfigHandler.smallerMineExplosion ? 2.5f : 5.0f, ConfigHandler.shouldSpawnFire, ConfigHandler.mineExplosionsBreakBlocks);
        }
    }

    public boolean func_149659_a(Explosion explosion) {
        return false;
    }

    @Override
    public boolean isActive(World world, BlockPos pos) {
        return true;
    }

    @Override
    public boolean explodesWhenInteractedWith() {
        return false;
    }

    @Override
    public boolean isDefusable() {
        return false;
    }

    @Override
    public TileEntity func_149915_a(World world, int meta) {
        return new OwnableBlockEntity();
    }

    @Override
    public ItemStack getDisplayStack(World world, IBlockState state, BlockPos pos) {
        return new ItemStack(this.blockDisguisedAs);
    }

    @Override
    public boolean shouldShowSCInfo(World world, IBlockState state, BlockPos pos) {
        return false;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        if (world.func_175625_s(pos) instanceof OwnableBlockEntity) {
            OwnableBlockEntity te = (OwnableBlockEntity)world.func_175625_s(pos);
            if (player.func_184812_l_() || te.isOwnedBy(player)) {
                return super.getPickBlock(state, target, world, pos, player);
            }
        }
        return new ItemStack(this.blockDisguisedAs);
    }

    public Block getBlockDisguisedAs() {
        return this.blockDisguisedAs;
    }
}

