/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks.reinforced;

import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IExtractionBlock;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.IReinforcedBlock;
import net.geforcemods.securitycraft.blockentities.ReinforcedHopperBlockEntity;
import net.geforcemods.securitycraft.misc.OwnershipEvent;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHopper;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class ReinforcedHopperBlock
extends BlockHopper
implements IReinforcedBlock {
    public ReinforcedHopperBlock() {
        this.func_149672_a(SoundType.field_185852_e);
    }

    public float func_149638_a(Entity exploder) {
        return Float.MAX_VALUE;
    }

    public float getExplosionResistance(World world, BlockPos pos, Entity exploder, Explosion explosion) {
        return Float.MAX_VALUE;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (placer instanceof EntityPlayer) {
            MinecraftForge.EVENT_BUS.post((Event)new OwnershipEvent(world, pos, (EntityPlayer)placer));
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ReinforcedHopperBlockEntity te;
        TileEntity tileEntity;
        if (!world.field_72995_K && (tileEntity = world.func_175625_s(pos)) instanceof ReinforcedHopperBlockEntity && ((te = (ReinforcedHopperBlockEntity)tileEntity).isOwnedBy(player) || te.isAllowed((Entity)player))) {
            player.func_71007_a((IInventory)te);
            player.func_71029_a(StatList.field_188084_R);
        }
        return true;
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new ReinforcedHopperBlockEntity();
    }

    @Override
    public List<Block> getVanillaBlocks() {
        return Arrays.asList(Blocks.field_150438_bZ);
    }

    @Override
    public int getAmount() {
        return 1;
    }

    public static class ExtractionBlock
    implements IExtractionBlock,
    Function<Object, IExtractionBlock> {
        @Override
        public IExtractionBlock apply(Object o) {
            return this;
        }

        @Override
        public boolean canExtract(IOwnable te, World world, BlockPos pos, IBlockState state) {
            ReinforcedHopperBlockEntity hopperTe = (ReinforcedHopperBlockEntity)world.func_175625_s(pos);
            if (!hopperTe.getOwner().isValidated()) {
                return false;
            }
            if (!te.getOwner().owns(hopperTe)) {
                if (te instanceof IModuleInventory) {
                    return ((IModuleInventory)((Object)te)).isAllowed(hopperTe.getOwner().getName());
                }
                return false;
            }
            return true;
        }

        @Override
        public Block getBlock() {
            return SCContent.reinforcedHopper;
        }
    }
}

