/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks.reinforced;

import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IDoorActivator;
import net.geforcemods.securitycraft.api.IReinforcedBlock;
import net.geforcemods.securitycraft.blocks.OwnableBlock;
import net.geforcemods.securitycraft.compat.IOverlayDisplay;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class ReinforcedMetalsBlock
extends OwnableBlock
implements IOverlayDisplay,
IReinforcedBlock {
    public static final PropertyEnum<EnumType> VARIANT = PropertyEnum.func_177709_a((String)"variant", EnumType.class);

    public ReinforcedMetalsBlock() {
        super(Material.field_151576_e);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(VARIANT, (Comparable)((Object)EnumType.GOLD)));
        this.func_149672_a(SoundType.field_185852_e);
    }

    public MapColor func_180659_g(IBlockState state, IBlockAccess world, BlockPos pos) {
        return ((EnumType)((Object)state.func_177229_b(VARIANT))).getColor();
    }

    public int func_180651_a(IBlockState state) {
        return ((EnumType)((Object)state.func_177229_b(VARIANT))).getMetadata();
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        EnumType[] values;
        for (EnumType type : values = EnumType.values()) {
            list.add((Object)new ItemStack((Block)this, 1, type.getMetadata()));
        }
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)EnumType.byMetadata(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumType)((Object)state.func_177229_b(VARIANT))).getMetadata();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT});
    }

    public boolean isBeaconBase(IBlockAccess world, BlockPos pos, BlockPos beacon) {
        return world.func_180495_p(pos).func_177229_b(VARIANT) != EnumType.REDSTONE;
    }

    public boolean func_149744_f(IBlockState state) {
        return state.func_177229_b(VARIANT) == EnumType.REDSTONE;
    }

    public int func_180656_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return state.func_177229_b(VARIANT) == EnumType.REDSTONE ? 15 : 0;
    }

    @Override
    public ItemStack getDisplayStack(World world, IBlockState state, BlockPos pos) {
        return new ItemStack(Item.func_150898_a((Block)SCContent.reinforcedMetals), 1, this.func_176201_c(state));
    }

    @Override
    public boolean shouldShowSCInfo(World world, IBlockState state, BlockPos pos) {
        return true;
    }

    @Override
    public List<Block> getVanillaBlocks() {
        return Arrays.asList(Blocks.field_150340_R, Blocks.field_150339_S, Blocks.field_150484_ah, Blocks.field_150475_bE, Blocks.field_150451_bX);
    }

    @Override
    public int getAmount() {
        return 5;
    }

    public static class DoorActivator
    implements Function<Object, IDoorActivator>,
    IDoorActivator {
        private List<Block> blocks = Arrays.asList(SCContent.reinforcedMetals);

        @Override
        public IDoorActivator apply(Object o) {
            return this;
        }

        @Override
        public boolean isPowering(World world, BlockPos pos, IBlockState state, TileEntity te, EnumFacing direction, int distance) {
            return state.func_177229_b(VARIANT) == EnumType.REDSTONE && distance == 1;
        }

        @Override
        public List<Block> getBlocks() {
            return this.blocks;
        }
    }

    public static final class EnumType
    extends Enum<EnumType>
    implements IStringSerializable {
        public static final /* enum */ EnumType GOLD;
        public static final /* enum */ EnumType IRON;
        public static final /* enum */ EnumType DIAMOND;
        public static final /* enum */ EnumType EMERALD;
        public static final /* enum */ EnumType REDSTONE;
        private static final EnumType[] META_LOOKUP;
        private final int meta;
        private final String name;
        private final MapColor color;
        private static final /* synthetic */ EnumType[] $VALUES;

        public static EnumType[] values() {
            return (EnumType[])$VALUES.clone();
        }

        public static EnumType valueOf(String name) {
            return Enum.valueOf(EnumType.class, name);
        }

        private EnumType(int meta, String name, MapColor color) {
            this.meta = meta;
            this.name = name;
            this.color = color;
        }

        public int getMetadata() {
            return this.meta;
        }

        public String toString() {
            return this.name;
        }

        public static EnumType byMetadata(int meta) {
            if (meta < 0 || meta >= META_LOOKUP.length) {
                meta = 0;
            }
            return META_LOOKUP[meta];
        }

        public String func_176610_l() {
            return this.name;
        }

        public MapColor getColor() {
            return this.color;
        }

        static {
            EnumType[] values;
            GOLD = new EnumType(0, "gold", MapColor.field_151647_F);
            IRON = new EnumType(1, "iron", MapColor.field_151668_h);
            DIAMOND = new EnumType(2, "diamond", MapColor.field_151648_G);
            EMERALD = new EnumType(3, "emerald", MapColor.field_151653_I);
            REDSTONE = new EnumType(4, "redstone", MapColor.field_151656_f);
            $VALUES = new EnumType[]{GOLD, IRON, DIAMOND, EMERALD, REDSTONE};
            META_LOOKUP = new EnumType[EnumType.values().length];
            EnumType[] enumTypeArray = values = EnumType.values();
            int n = enumTypeArray.length;
            for (int i = 0; i < n; ++i) {
                EnumType type;
                EnumType.META_LOOKUP[type.getMetadata()] = type = enumTypeArray[i];
            }
        }
    }
}

