/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks.reinforced;

import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IDoorActivator;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.IReinforcedBlock;
import net.geforcemods.securitycraft.blockentities.AllowlistOnlyBlockEntity;
import net.geforcemods.securitycraft.misc.OwnershipEvent;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPressurePlate;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class ReinforcedPressurePlateBlock
extends BlockPressurePlate
implements IReinforcedBlock {
    private final Block vanillaBlock;

    public ReinforcedPressurePlateBlock(Material material, BlockPressurePlate.Sensitivity sensitivity, SoundType soundType, Block vanillaBlock, MapColor color) {
        super(material, sensitivity);
        this.func_149672_a(soundType);
        this.vanillaBlock = vanillaBlock;
        this.field_181083_K = color;
    }

    public float func_149638_a(Entity exploder) {
        return Float.MAX_VALUE;
    }

    public float getExplosionResistance(World world, BlockPos pos, Entity exploder, Explosion explosion) {
        return Float.MAX_VALUE;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (placer instanceof EntityPlayer) {
            MinecraftForge.EVENT_BUS.post((Event)new OwnershipEvent(world, pos, (EntityPlayer)placer));
        }
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        TileEntity te;
        int redstoneStrength = this.func_176576_e(state);
        if (!world.field_72995_K && redstoneStrength == 0 && entity instanceof EntityPlayer && (te = world.func_175625_s(pos)) instanceof AllowlistOnlyBlockEntity && this.isAllowedToPress((AllowlistOnlyBlockEntity)te, (EntityPlayer)entity)) {
            this.func_180666_a(world, pos, state, redstoneStrength);
        }
    }

    protected int func_180669_e(World world, BlockPos pos) {
        TileEntity te;
        AxisAlignedBB aabb = field_185511_c.func_186670_a(pos);
        List list = world.func_72839_b(null, aabb);
        if (!list.isEmpty() && (te = world.func_175625_s(pos)) instanceof AllowlistOnlyBlockEntity) {
            for (Entity entity : list) {
                if (!(entity instanceof EntityPlayer) || !this.isAllowedToPress((AllowlistOnlyBlockEntity)te, (EntityPlayer)entity)) continue;
                return 15;
            }
        }
        return 0;
    }

    public boolean isAllowedToPress(AllowlistOnlyBlockEntity te, EntityPlayer entity) {
        return te.isOwnedBy(entity) || te.isAllowed((Entity)entity);
    }

    public void func_176208_a(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        TileEntity te;
        if (player.func_184812_l_() && (te = world.func_175625_s(pos)) instanceof IModuleInventory) {
            ((IModuleInventory)te).getInventory().clear();
        }
        super.func_176208_a(world, pos, state, player);
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof IModuleInventory) {
            ((IModuleInventory)te).dropAllModules();
        }
        super.func_180663_b(world, pos, state);
    }

    public EnumPushReaction func_149656_h(IBlockState state) {
        return EnumPushReaction.NORMAL;
    }

    @Override
    public List<Block> getVanillaBlocks() {
        return Arrays.asList(this.vanillaBlock);
    }

    @Override
    public int getAmount() {
        return 1;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new AllowlistOnlyBlockEntity();
    }

    public static class DoorActivator
    implements Function<Object, IDoorActivator>,
    IDoorActivator {
        private final List<Block> blocks = Arrays.asList(SCContent.reinforcedStonePressurePlate, SCContent.reinforcedWoodenPressurePlate);

        @Override
        public IDoorActivator apply(Object o) {
            return this;
        }

        @Override
        public boolean isPowering(World world, BlockPos pos, IBlockState state, TileEntity te, EnumFacing direction, int distance) {
            return (Boolean)state.func_177229_b((IProperty)BlockPressurePlate.field_176580_a) != false && (distance < 2 || direction == EnumFacing.UP);
        }

        @Override
        public List<Block> getBlocks() {
            return this.blocks;
        }
    }
}

