/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.items;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.ILinkedAction;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.OwnableBlockEntity;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.blockentities.DisplayCaseBlockEntity;
import net.geforcemods.securitycraft.blockentities.InventoryScannerBlockEntity;
import net.geforcemods.securitycraft.blockentities.LaserBlockBlockEntity;
import net.geforcemods.securitycraft.blocks.CageTrapBlock;
import net.geforcemods.securitycraft.blocks.DisguisableBlock;
import net.geforcemods.securitycraft.blocks.InventoryScannerBlock;
import net.geforcemods.securitycraft.blocks.LaserBlock;
import net.geforcemods.securitycraft.blocks.OwnableBlock;
import net.geforcemods.securitycraft.items.ModuleItem;
import net.geforcemods.securitycraft.util.IBlockMine;
import net.geforcemods.securitycraft.util.IBlockWithNoDrops;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.apache.logging.log4j.util.TriConsumer;

public class UniversalBlockRemoverItem
extends Item {
    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        TileEntity tileEntity = world.func_175625_s(pos);
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (tileEntity != null && this.isOwnableBlock(block, tileEntity)) {
            if (tileEntity instanceof DisplayCaseBlockEntity && ((DisplayCaseBlockEntity)tileEntity).isOpen() && ((DisplayCaseBlockEntity)tileEntity).getDisplayedStack().func_190926_b()) {
                return EnumActionResult.PASS;
            }
            if (!((IOwnable)tileEntity).isOwnedBy(player)) {
                if (!(block instanceof IBlockMine || tileEntity.func_145838_q() instanceof DisguisableBlock && !(((ItemBlock)((DisguisableBlock)tileEntity.func_145838_q()).getDisguisedStack((IBlockAccess)world, pos).func_77973_b()).func_179223_d() instanceof DisguisableBlock))) {
                    PlayerUtils.sendMessageToPlayer(player, (ITextComponent)Utils.localize("item.securitycraft:universalBlockRemover.name", new Object[0]), (ITextComponent)Utils.localize("messages.securitycraft:notOwned", PlayerUtils.getOwnerComponent(((IOwnable)tileEntity).getOwner())), TextFormatting.RED);
                    return EnumActionResult.SUCCESS;
                }
                return EnumActionResult.PASS;
            }
            if (tileEntity instanceof IModuleInventory) {
                ((IModuleInventory)tileEntity).dropAllModules();
            }
            if (block == SCContent.laserBlock) {
                LaserBlockBlockEntity te = (LaserBlockBlockEntity)world.func_175625_s(pos);
                for (ItemStack module : te.getInventory()) {
                    if (module.func_190926_b()) continue;
                    te.createLinkedBlockAction((ILinkedAction)new ILinkedAction.ModuleRemoved(((ModuleItem)module.func_77973_b()).getModuleType(), false), te);
                }
                if (!world.field_72995_K) {
                    world.func_175655_b(pos, true);
                    LaserBlock.destroyAdjacentLasers(world, pos);
                    player.func_184586_b(hand).func_77972_a(1, (EntityLivingBase)player);
                }
            } else if (block == SCContent.cageTrap && ((Boolean)world.func_180495_p(pos).func_177229_b((IProperty)CageTrapBlock.DEACTIVATED)).booleanValue()) {
                BlockPos originalPos = pos;
                BlockPos middlePos = originalPos.func_177981_b(4);
                if (!world.field_72995_K) {
                    new CageTrapBlock.BlockModifier(world, new BlockPos.MutableBlockPos(originalPos), ((IOwnable)tileEntity).getOwner()).loop((TriConsumer<World, BlockPos.MutableBlockPos, Owner>)((TriConsumer)(w, p, o) -> {
                        Block b;
                        TileEntity te = w.func_175625_s((BlockPos)p);
                        if (te instanceof IOwnable && ((IOwnable)te).getOwner().owns((IOwnable)te) && ((b = w.func_180495_p((BlockPos)p).func_177230_c()) == SCContent.reinforcedIronBars || p.equals((Object)middlePos) && b == SCContent.horizontalReinforcedIronBars)) {
                            w.func_175655_b((BlockPos)p, false);
                        }
                    }));
                    world.func_175655_b(originalPos, true);
                    player.func_184586_b(hand).func_77972_a(1, (EntityLivingBase)player);
                }
            } else {
                if (block == SCContent.inventoryScanner) {
                    InventoryScannerBlockEntity te = InventoryScannerBlock.getConnectedInventoryScanner(world, pos);
                    if (te != null) {
                        te.getInventory().clear();
                    }
                } else if (block instanceof IBlockWithNoDrops) {
                    Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)((IBlockWithNoDrops)block).getUniversalBlockRemoverDrop());
                }
                if (!world.field_72995_K) {
                    world.func_175655_b(pos, true);
                    block.func_176206_d(world, pos, state);
                    player.func_184586_b(hand).func_77972_a(1, (EntityLivingBase)player);
                }
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    private boolean isOwnableBlock(Block block, TileEntity tileEntity) {
        return tileEntity instanceof OwnableBlockEntity || tileEntity instanceof IOwnable || block instanceof OwnableBlock;
    }
}

