/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.misc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import net.geforcemods.securitycraft.blockentities.BlockChangeDetectorBlockEntity;
import net.geforcemods.securitycraft.blockentities.RiftStabilizerBlockEntity;
import net.geforcemods.securitycraft.blockentities.SonicSecuritySystemBlockEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class BlockEntityTracker<TE extends TileEntity> {
    public static final BlockEntityTracker<SonicSecuritySystemBlockEntity> SONIC_SECURITY_SYSTEM = new BlockEntityTracker<SonicSecuritySystemBlockEntity>(te -> 30);
    public static final BlockEntityTracker<BlockChangeDetectorBlockEntity> BLOCK_CHANGE_DETECTOR = new BlockEntityTracker<BlockChangeDetectorBlockEntity>(te -> te.getRange());
    public static final BlockEntityTracker<RiftStabilizerBlockEntity> RIFT_STABILIZER = new BlockEntityTracker<RiftStabilizerBlockEntity>(RiftStabilizerBlockEntity::getRange);
    private final Map<Integer, Collection<BlockPos>> trackedTileEntities = new ConcurrentHashMap<Integer, Collection<BlockPos>>();
    private final Function<TE, Integer> range;

    private BlockEntityTracker(Function<TE, Integer> range) {
        this.range = range;
    }

    public void track(TE te) {
        this.getTrackedTileEntities(te.func_145831_w()).add(te.func_174877_v().func_185334_h());
    }

    public void stopTracking(TE te) {
        this.getTrackedTileEntities(te.func_145831_w()).remove(te.func_174877_v());
    }

    public List<TE> getTileEntitiesInRange(World world, BlockPos pos) {
        return this.getTileEntitiesInRange(world, new Vec3d((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()));
    }

    public List<TE> getTileEntitiesInRange(World world, Vec3d pos) {
        Collection<BlockPos> tileEntities = this.getTrackedTileEntities(world);
        ArrayList<TileEntity> returnValue = new ArrayList<TileEntity>();
        Iterator<BlockPos> it = tileEntities.iterator();
        while (it.hasNext()) {
            BlockPos tePos = it.next();
            if (tePos != null) {
                TileEntity te = world.func_175625_s(tePos);
                if (te == null || !this.canReach(te, pos)) continue;
                returnValue.add(te);
                continue;
            }
            it.remove();
        }
        return returnValue;
    }

    public Collection<BlockPos> getTrackedTileEntities(World world) {
        Collection<BlockPos> tileEntities = this.trackedTileEntities.get(world.field_73011_w.getDimension());
        if (tileEntities == null) {
            tileEntities = ConcurrentHashMap.newKeySet();
            this.trackedTileEntities.put(world.field_73011_w.getDimension(), tileEntities);
        }
        return tileEntities;
    }

    public boolean canReach(TE te, Vec3d pos) {
        AxisAlignedBB possibleRange = new AxisAlignedBB(te.func_174877_v()).func_186662_g((double)this.range.apply(te).intValue());
        return possibleRange.field_72340_a <= pos.field_72450_a && possibleRange.field_72338_b <= pos.field_72448_b && possibleRange.field_72339_c <= pos.field_72449_c && possibleRange.field_72336_d >= pos.field_72450_a && possibleRange.field_72337_e >= pos.field_72448_b && possibleRange.field_72334_f >= pos.field_72449_c;
    }
}

