/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.misc;

import java.util.Arrays;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.IExplosive;
import net.geforcemods.securitycraft.api.ILockable;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.blockentities.SecurityCameraBlockEntity;
import net.geforcemods.securitycraft.blocks.DisguisableBlock;
import net.geforcemods.securitycraft.entity.sentry.Sentry;
import net.geforcemods.securitycraft.items.CameraMonitorItem;
import net.geforcemods.securitycraft.items.MineRemoteAccessToolItem;
import net.geforcemods.securitycraft.items.SentryRemoteAccessToolItem;
import net.geforcemods.securitycraft.items.SonicSecuritySystemItem;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class LinkingStateItemPropertyHandler {
    public static final float EMPTY_STATE = 0.0f;
    public static final float UNKNOWN_STATE = 0.25f;
    public static final float NOT_LINKED_STATE = 0.5f;
    public static final float LINKED_STATE = 0.75f;
    public static final ResourceLocation LINKING_STATE_PROPERTY = new ResourceLocation("securitycraft", "linking_state");

    public static float cameraMonitor(ItemStack stack, World world, EntityLivingBase entity) {
        if (!(entity instanceof EntityPlayer)) {
            return 0.0f;
        }
        EntityPlayer player = (EntityPlayer)entity;
        float linkingState = LinkingStateItemPropertyHandler.getLinkingState(world, player, stack, (_world, pos) -> _world.func_175625_s(pos) instanceof SecurityCameraBlockEntity, 30, (tag, i) -> {
            if (!tag.func_74764_b("Camera" + i)) {
                return null;
            }
            String camera = tag.func_74779_i("Camera" + i);
            return (Integer[])Arrays.stream(camera.substring(0, camera.lastIndexOf(32)).split(" ")).map(Integer::parseInt).toArray(Integer[]::new);
        });
        if (!CameraMonitorItem.hasCameraAdded(stack.func_77978_p())) {
            if (linkingState == 0.5f) {
                return 0.5f;
            }
            return 0.0f;
        }
        return linkingState;
    }

    public static float mineRemoteAccessTool(ItemStack stack, World world, EntityLivingBase entity) {
        if (!(entity instanceof EntityPlayer)) {
            return 0.0f;
        }
        EntityPlayer player = (EntityPlayer)entity;
        float linkingState = LinkingStateItemPropertyHandler.getLinkingState(world, player, stack, (_world, pos) -> _world.func_180495_p(pos).func_177230_c() instanceof IExplosive, 30, (tag, i) -> {
            if (tag.func_74759_k("mine" + i).length > 0) {
                return (Integer[])Arrays.stream(tag.func_74759_k("mine" + i)).boxed().toArray(Integer[]::new);
            }
            return null;
        });
        if (!MineRemoteAccessToolItem.hasMineAdded(stack.func_77978_p())) {
            if (linkingState == 0.5f) {
                return 0.5f;
            }
            return 0.0f;
        }
        return linkingState;
    }

    public static float sentryRemoteAccessTool(ItemStack stack, World world, EntityLivingBase entity) {
        if (!(entity instanceof EntityPlayer)) {
            return 0.0f;
        }
        if (Minecraft.func_71410_x().field_147125_j instanceof Sentry) {
            Sentry sentry = (Sentry)Minecraft.func_71410_x().field_147125_j;
            if (!stack.func_77942_o()) {
                stack.func_77982_d(new NBTTagCompound());
            }
            float linkingState = LinkingStateItemPropertyHandler.loop(12, (tag, i) -> (Integer[])Arrays.stream(tag.func_74759_k("sentry" + i)).boxed().toArray(Integer[]::new), stack.func_77978_p(), sentry.func_180425_c());
            if (!SentryRemoteAccessToolItem.hasSentryAdded(stack.func_77978_p())) {
                if (linkingState == 0.5f) {
                    return 0.5f;
                }
                return 0.0f;
            }
            return linkingState;
        }
        return SentryRemoteAccessToolItem.hasSentryAdded(stack.func_77978_p()) ? 0.25f : 0.0f;
    }

    public static float sonicSecuritySystem(ItemStack stack, World world, EntityLivingBase entity) {
        if (!(entity instanceof EntityPlayer)) {
            return 0.0f;
        }
        EntityPlayer player = (EntityPlayer)entity;
        float linkingState = LinkingStateItemPropertyHandler.getLinkingState(world, player, stack, (_world, pos) -> {
            TileEntity tile = _world.func_175625_s(pos);
            if (!(tile instanceof ILockable)) {
                return false;
            }
            return tile instanceof IOwnable && ((IOwnable)tile).isOwnedBy(player) || DisguisableBlock.getDisguisedBlockStateUnknown((IBlockAccess)_world, pos) == null;
        }, 0, null, false, SonicSecuritySystemItem::isAdded);
        if (!SonicSecuritySystemItem.hasLinkedBlock(stack.func_77978_p())) {
            if (linkingState == 0.5f) {
                return 0.5f;
            }
            return 0.0f;
        }
        return linkingState;
    }

    public static float getLinkingState(World level, EntityPlayer player, ItemStack stackInHand, BiPredicate<World, BlockPos> isValidHitResult, int tagSize, BiFunction<NBTTagCompound, Integer, Integer[]> getCoords) {
        return LinkingStateItemPropertyHandler.getLinkingState(level, player, stackInHand, isValidHitResult, tagSize, getCoords, true, null);
    }

    public static float getLinkingState(World level, EntityPlayer player, ItemStack stackInHand, BiPredicate<World, BlockPos> isValidHitResult, int tagSize, BiFunction<NBTTagCompound, Integer, Integer[]> getCoords, boolean loop, BiPredicate<NBTTagCompound, BlockPos> useCheckmark) {
        if (level == null) {
            level = SecurityCraft.proxy.getClientLevel();
        }
        double reachDistance = Minecraft.func_71410_x().field_71442_b.func_78757_d();
        double eyeHeight = player.func_70047_e();
        Vec3d lookVec = new Vec3d(player.field_70165_t + player.func_70040_Z().field_72450_a * reachDistance, eyeHeight + player.field_70163_u + player.func_70040_Z().field_72448_b * reachDistance, player.field_70161_v + player.func_70040_Z().field_72449_c * reachDistance);
        RayTraceResult hitResult = level.func_72933_a(new Vec3d(player.field_70165_t, player.field_70163_u + (double)player.func_70047_e(), player.field_70161_v), lookVec);
        if (hitResult != null && hitResult.field_72313_a == RayTraceResult.Type.BLOCK && isValidHitResult.test(level, hitResult.func_178782_a())) {
            if (!stackInHand.func_77942_o()) {
                stackInHand.func_77982_d(new NBTTagCompound());
            }
            if (loop) {
                return LinkingStateItemPropertyHandler.loop(tagSize, getCoords, stackInHand.func_77978_p(), hitResult.func_178782_a());
            }
            return useCheckmark.test(stackInHand.func_77978_p(), hitResult.func_178782_a()) ? 0.75f : 0.5f;
        }
        return 0.25f;
    }

    private static float loop(int tagSize, BiFunction<NBTTagCompound, Integer, Integer[]> getCoords, NBTTagCompound tag, BlockPos pos) {
        for (int i = 1; i <= tagSize; ++i) {
            Integer[] coords = getCoords.apply(tag, i);
            if (coords == null || coords.length != 3 || coords[0].intValue() != pos.func_177958_n() || coords[1].intValue() != pos.func_177956_o() || coords[2].intValue() != pos.func_177952_p()) continue;
            return 0.75f;
        }
        return 0.5f;
    }
}

