/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.client;

import io.netty.buffer.ByteBuf;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.blockentities.AlarmBlockEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class PlayAlarmSound
implements IMessage {
    private BlockPos bePos;
    private SoundEvent sound;
    private int soundX;
    private int soundY;
    private int soundZ;
    private float volume;
    private float pitch;

    public PlayAlarmSound() {
    }

    public PlayAlarmSound(BlockPos bePos, SoundEvent sound, float volume, float pitch) {
        this.bePos = bePos;
        this.sound = sound;
        this.soundX = (int)((float)bePos.func_177958_n() * 8.0f);
        this.soundY = (int)((float)bePos.func_177956_o() * 8.0f);
        this.soundZ = (int)((float)bePos.func_177952_p() * 8.0f);
        this.volume = volume;
        this.pitch = pitch;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeLong(this.bePos.func_177986_g());
        ByteBufUtils.writeRegistryEntry((ByteBuf)buf, (IForgeRegistryEntry)this.sound);
        buf.writeInt(this.soundX);
        buf.writeInt(this.soundY);
        buf.writeInt(this.soundZ);
        buf.writeFloat(this.volume);
        buf.writeFloat(this.pitch);
    }

    public void fromBytes(ByteBuf buf) {
        this.bePos = BlockPos.func_177969_a((long)buf.readLong());
        this.sound = (SoundEvent)ByteBufUtils.readRegistryEntry((ByteBuf)buf, (IForgeRegistry)ForgeRegistries.SOUND_EVENTS);
        this.soundX = buf.readInt();
        this.soundY = buf.readInt();
        this.soundZ = buf.readInt();
        this.volume = buf.readFloat();
        this.pitch = buf.readFloat();
    }

    public double getX() {
        return (float)this.soundX / 8.0f;
    }

    public double getY() {
        return (float)this.soundY / 8.0f;
    }

    public double getZ() {
        return (float)this.soundZ / 8.0f;
    }

    public static class Handler
    implements IMessageHandler<PlayAlarmSound, IMessage> {
        @SideOnly(value=Side.CLIENT)
        public IMessage onMessage(PlayAlarmSound message, MessageContext context) {
            Minecraft.func_71410_x().func_152344_a(() -> {
                World level = SecurityCraft.proxy.getClientLevel();
                TileEntity te = level.func_175625_s(message.bePos);
                if (te instanceof AlarmBlockEntity) {
                    ((AlarmBlockEntity)te).setPowered(true);
                    ((AlarmBlockEntity)te).playSound(message.getX(), message.getY(), message.getZ(), message.sound, message.volume, message.pitch);
                }
            });
            return null;
        }
    }
}

