/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.server;

import io.netty.buffer.ByteBuf;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.items.BriefcaseItem;
import net.geforcemods.securitycraft.util.LevelUtils;
import net.geforcemods.securitycraft.util.PasscodeUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class CheckBriefcasePasscode
implements IMessage {
    private String passcode;

    public CheckBriefcasePasscode() {
    }

    public CheckBriefcasePasscode(String passcode) {
        this.passcode = PasscodeUtils.hashPasscodeWithoutSalt(passcode);
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.passcode);
    }

    public void fromBytes(ByteBuf buf) {
        this.passcode = ByteBufUtils.readUTF8String((ByteBuf)buf);
    }

    public static class Handler
    implements IMessageHandler<CheckBriefcasePasscode, IMessage> {
        public IMessage onMessage(CheckBriefcasePasscode message, MessageContext ctx) {
            LevelUtils.addScheduledTask(ctx.getServerHandler().field_147369_b.field_70170_p, () -> {
                EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
                ItemStack briefcase = PlayerUtils.getItemStackFromAnyHand((EntityPlayer)player, SCContent.briefcase);
                if (!briefcase.func_190926_b()) {
                    NBTTagCompound tag;
                    String tagCode;
                    if (!briefcase.func_77942_o()) {
                        briefcase.func_77982_d(new NBTTagCompound());
                    }
                    if ((tagCode = (tag = briefcase.func_77978_p()).func_74779_i("passcode")).length() == 4) {
                        BriefcaseItem.hashAndSetPasscode(tag, PasscodeUtils.hashPasscodeWithoutSalt(tagCode), p -> BriefcaseItem.checkPasscode(player, message.passcode, PasscodeUtils.bytesToString(p), tag));
                    } else {
                        BriefcaseItem.checkPasscode(player, message.passcode, tagCode, tag);
                    }
                }
            });
            return null;
        }
    }
}

