/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.server;

import io.netty.buffer.ByteBuf;
import net.geforcemods.securitycraft.api.IExplosive;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.util.LevelUtils;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class RemoteControlMine
implements IMessage {
    private int x;
    private int y;
    private int z;
    private String stateString;

    public RemoteControlMine() {
    }

    public RemoteControlMine(int x, int y, int z, String state) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.stateString = state;
    }

    public void fromBytes(ByteBuf buf) {
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        this.stateString = ByteBufUtils.readUTF8String((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.stateString);
    }

    public static class Handler
    implements IMessageHandler<RemoteControlMine, IMessage> {
        public IMessage onMessage(RemoteControlMine message, MessageContext context) {
            LevelUtils.addScheduledTask(context.getServerHandler().field_147369_b.field_70170_p, () -> {
                EntityPlayerMP player = context.getServerHandler().field_147369_b;
                World world = player.field_70170_p;
                BlockPos pos = new BlockPos(message.x, message.y, message.z);
                IBlockState state = world.func_180495_p(pos);
                if (state.func_177230_c() instanceof IExplosive) {
                    IExplosive explosive = (IExplosive)state.func_177230_c();
                    TileEntity te = world.func_175625_s(pos);
                    if (!(te instanceof IOwnable) || ((IOwnable)te).isOwnedBy((EntityPlayer)player)) {
                        if (message.stateString.equalsIgnoreCase("activate")) {
                            explosive.activateMine(world, pos);
                        } else if (message.stateString.equalsIgnoreCase("defuse")) {
                            explosive.defuseMine(world, pos);
                        } else if (message.stateString.equalsIgnoreCase("detonate")) {
                            explosive.explode(world, pos);
                        }
                    }
                }
            });
            return null;
        }
    }
}

