/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.screen;

import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.blockentities.AlarmBlockEntity;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.network.server.SyncAlarmSettings;
import net.geforcemods.securitycraft.screen.AlarmOptionsScreen;
import net.geforcemods.securitycraft.screen.components.ClickButton;
import net.geforcemods.securitycraft.screen.components.ColorableScrollPanel;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiPageButtonList;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.Style;
import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import org.lwjgl.input.Mouse;

public class AlarmScreen
extends GuiScreen {
    private static final ResourceLocation GUI_TEXTURE = new ResourceLocation("securitycraft", "textures/gui/container/alarm.png");
    protected final AlarmBlockEntity be;
    private final boolean hasSmartModule;
    private final String smartModuleTooltip;
    private final String currentlySelectedText = Utils.localize("gui.securitycraft:alarm.currently_selected", new Object[0]).func_150255_a(new Style().func_150228_d(Boolean.valueOf(true))).func_150254_d();
    private String title;
    private final ResourceLocation previousSelectedSoundEvent;
    private ResourceLocation selectedSoundEvent;
    private String selectedSoundEventText;
    protected int imageWidth = 256;
    protected int imageHeight = 246;
    protected int leftPos;
    protected int topPos;
    protected SoundScrollList soundList;
    protected HintEditBox searchBar;
    protected ClickButton optionsButton;
    protected int previousSoundLength;
    protected int soundLength;
    protected float previousPitch;
    protected float pitch;

    public AlarmScreen(AlarmBlockEntity be, ResourceLocation selectedSoundEvent) {
        this.be = be;
        this.hasSmartModule = be.isModuleEnabled(ModuleType.SMART);
        this.smartModuleTooltip = Utils.localize(this.hasSmartModule ? "gui.securitycraft:alarm.smart_module" : "gui.securitycraft:alarm.no_smart_module", new Object[0]).func_150254_d();
        this.previousSelectedSoundEvent = selectedSoundEvent;
        this.soundLength = this.previousSoundLength = be.getSoundLength();
        this.pitch = this.previousPitch = be.getPitch();
        this.title = be.func_145748_c_().func_150254_d();
        this.selectSound(selectedSoundEvent);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.leftPos = (this.field_146294_l - this.imageWidth) / 2;
        this.topPos = (this.field_146295_m - this.imageHeight) / 2;
        int id = 0;
        this.soundList = new SoundScrollList(this.field_146297_k, this.imageWidth - 10, this.imageHeight - 105, this.topPos + 40, this.leftPos + 5);
        this.searchBar = new HintEditBox(id++, this.field_146289_q, this.leftPos + 30, this.topPos + 20, this.imageWidth - 60, 15);
        this.searchBar.setHint(Utils.localize("gui.securitycraft:alarm.search", new Object[0]).func_150254_d());
        this.searchBar.func_175205_a(s -> s.matches("[a-zA-Z0-9\\._]*"));
        this.searchBar.func_175207_a(new GuiPageButtonList.GuiResponder(){

            public void func_175319_a(int id, String value) {
                AlarmScreen.this.soundList.updateFilteredEntries(value);
            }

            public void func_175320_a(int id, float value) {
            }

            public void func_175321_a(int id, boolean value) {
            }
        });
        this.optionsButton = (ClickButton)this.func_189646_b((GuiButton)new ClickButton(id++, this.leftPos + this.imageWidth / 2 - 85, this.topPos + 215, 170, 20, Utils.localize("menu.options", new Object[0]).func_150254_d(), b -> this.field_146297_k.func_147108_a((GuiScreen)new AlarmOptionsScreen(this))));
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(GUI_TEXTURE);
        this.func_73729_b(this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
        super.func_73863_a(mouseX, mouseY, partialTicks);
        if (this.soundList != null) {
            this.soundList.drawScreen(mouseX, mouseY);
        }
        this.searchBar.func_146194_f();
        this.field_146289_q.func_78276_b(this.title, this.field_146294_l / 2 - this.field_146289_q.func_78256_a(this.title) / 2, this.topPos + 6, 0x404040);
        this.field_146289_q.func_78276_b(this.currentlySelectedText, this.field_146294_l / 2 - this.field_146289_q.func_78256_a(this.currentlySelectedText) / 2, this.topPos + this.imageHeight - 62, 0x404040);
        this.field_146289_q.func_78276_b(this.selectedSoundEventText, this.field_146294_l / 2 - this.field_146289_q.func_78256_a(this.selectedSoundEventText) / 2, this.topPos + this.imageHeight - 49, 0x404040);
        net.geforcemods.securitycraft.util.GuiUtils.renderModuleInfo(ModuleType.SMART, this.smartModuleTooltip, this.hasSmartModule, this.leftPos + 5, this.topPos + 5, this.field_146294_l, this.field_146295_m, mouseX, mouseY);
    }

    public void selectSound(ResourceLocation eventId) {
        this.selectedSoundEvent = eventId;
        this.selectedSoundEventText = Utils.localize(this.toLanguageKey(this.selectedSoundEvent), new Object[0]).func_150254_d();
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        if (button instanceof ClickButton) {
            ((ClickButton)button).onClick();
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        this.searchBar.func_146192_a(mouseX, mouseY, mouseButton);
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        double mouseX = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
        double mouseY = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
        if (this.soundList != null) {
            this.soundList.handleMouseInput((int)mouseX, (int)mouseY);
        }
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        super.func_73869_a(typedChar, keyCode);
        this.searchBar.func_146201_a(typedChar, keyCode);
        if (keyCode == 1 || this.field_146297_k.field_71474_y.field_151445_Q.isActiveAndMatches(keyCode) && !this.searchBar.func_146206_l()) {
            this.field_146297_k.field_71439_g.func_71053_j();
        }
    }

    public boolean func_73868_f() {
        return false;
    }

    public void func_146281_b() {
        super.func_146281_b();
        if (this.soundList != null && this.soundList.playingSound != null) {
            Minecraft.func_71410_x().func_147118_V().func_147683_b(this.soundList.playingSound);
        }
        boolean changed = false;
        if (this.selectedSoundEvent != this.previousSelectedSoundEvent) {
            this.be.setSound(this.selectedSoundEvent);
            changed = true;
        }
        if (this.pitch != this.previousPitch) {
            this.be.setPitch(this.pitch);
            changed = true;
        }
        if (this.soundLength != this.previousSoundLength) {
            this.be.setSoundLength(this.soundLength);
            changed = true;
        }
        if (changed) {
            SecurityCraft.network.sendToServer((IMessage)new SyncAlarmSettings(this.be.func_174877_v(), this.selectedSoundEvent, this.pitch, this.soundLength));
        }
    }

    private String toLanguageKey(ResourceLocation resourceLocation) {
        return resourceLocation.func_110624_b() + "." + resourceLocation.func_110623_a();
    }

    public class HintEditBox
    extends GuiTextField {
        private String hint;

        public HintEditBox(int id, FontRenderer font, int x, int y, int width, int height) {
            super(id, font, x, y, width, height);
        }

        public void func_146194_f() {
            super.func_146194_f();
            if (this.func_146176_q() && this.hint != null && this.field_146216_j.isEmpty() && !this.func_146206_l()) {
                AlarmScreen.this.field_146289_q.func_175063_a(this.hint, (float)(this.field_146209_f + 4), (float)(this.field_146210_g + (this.field_146219_i - 8) / 2), 0xE0E0E0);
            }
        }

        public void setHint(String hint) {
            this.hint = hint;
        }
    }

    public class SoundScrollList
    extends ColorableScrollPanel {
        private static final int TEXT_OFFSET = 11;
        public final List<SoundEvent> allSoundEvents;
        private final Map<SoundEvent, String> soundEventKeys;
        private List<SoundEvent> filteredSoundEvents;
        private ISound playingSound;
        private int selectedSoundIndex;
        private int contentHeight;
        private String previousSearchText;

        public SoundScrollList(Minecraft client, int width, int height, int top, int left) {
            super(client, width, height, top, left);
            this.allSoundEvents = new ArrayList<SoundEvent>(ForgeRegistries.SOUND_EVENTS.getValues());
            this.soundEventKeys = new HashMap<SoundEvent, String>();
            this.contentHeight = 0;
            this.previousSearchText = "";
            this.updateFilteredEntries("");
            this.scrollDistance = this.selectedSoundIndex * this.slotHeight;
            int maxScroll = this.getContentHeight() - (height - 4);
            if (this.scrollDistance > (float)maxScroll) {
                this.scrollDistance = maxScroll;
            }
        }

        @Override
        public int getContentHeight() {
            return this.contentHeight;
        }

        @Override
        public void elementClicked(int mouseX, int mouseY, int slotIndex) {
            if (slotIndex >= 0 && slotIndex < this.filteredSoundEvents.size()) {
                if ((mouseX -= this.left) >= 0 && mouseX <= 8) {
                    this.playSound(this.filteredSoundEvents.get(slotIndex));
                } else if (AlarmScreen.this.hasSmartModule && mouseX > 8 && mouseX <= this.right - 6 && slotIndex != this.selectedSoundIndex) {
                    AlarmScreen.this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
                    this.selectSound(slotIndex);
                }
            }
        }

        @Override
        public void drawScreen(int mouseX, int mouseY) {
            super.drawScreen(mouseX, mouseY);
            int baseY = this.top + 4 - (int)this.scrollDistance;
            int mouseListY = (int)((float)(mouseY - this.top) + this.scrollDistance - 2.0f);
            int slotIndex = mouseListY / this.slotHeight;
            if (slotIndex >= 0 && slotIndex < this.filteredSoundEvents.size() && mouseX >= this.left && mouseX < this.right - 6 && mouseListY >= 0 && mouseY >= this.top && mouseY <= this.bottom) {
                String soundEventKey = this.getSoundEventString(this.filteredSoundEvents.get(slotIndex));
                int length = AlarmScreen.this.field_146289_q.func_78256_a(soundEventKey);
                if (length >= AlarmScreen.this.field_146294_l - 6 - 11) {
                    GuiUtils.drawHoveringText(Collections.singletonList(soundEventKey), (int)(this.left + 11 - 12), (int)(baseY + (this.slotHeight * slotIndex + this.slotHeight)), (int)AlarmScreen.this.field_146294_l, (int)AlarmScreen.this.field_146295_m, (int)-1, (FontRenderer)AlarmScreen.this.field_146289_q);
                    RenderHelper.func_74518_a();
                }
            }
        }

        @Override
        public void drawPanel(int entryRight, int baseY, Tessellator tesselator, int mouseX, int mouseY) {
            int slotBuffer = this.slotHeight - 4;
            int mouseListY = (int)((float)(mouseY - this.top) + this.scrollDistance - 2.0f);
            int slotIndex = mouseListY / this.slotHeight;
            int min = this.left + 11 - 2;
            if (AlarmScreen.this.hasSmartModule && slotIndex != this.selectedSoundIndex && mouseX >= min && mouseX <= this.right - 7 && slotIndex >= 0 && mouseListY >= 0 && slotIndex < this.filteredSoundEvents.size() && mouseY >= this.top && mouseY <= this.bottom) {
                this.renderHighlightBox(entryRight, tesselator, baseY, slotBuffer, slotIndex, min);
            }
            if (this.selectedSoundIndex >= 0) {
                this.renderHighlightBox(entryRight, tesselator, baseY, slotBuffer, this.selectedSoundIndex, min);
            }
            for (int i = 0; i < this.filteredSoundEvents.size(); ++i) {
                int yStart = baseY + this.slotHeight * i;
                if (yStart + this.slotHeight < this.top) continue;
                if (yStart > this.top + AlarmScreen.this.field_146295_m) break;
                SoundEvent soundEvent = this.filteredSoundEvents.get(i);
                String name = this.getSoundEventString(soundEvent);
                AlarmScreen.this.field_146289_q.func_78276_b(name, this.left + 11, yStart, 0xC6C6C6);
                AlarmScreen.this.field_146297_k.func_110434_K().func_110577_a(GUI_TEXTURE);
                Gui.func_146110_a((int)this.left, (int)(yStart - 1), (float)(i == slotIndex && mouseX >= this.left && mouseX < min && mouseY >= this.top && mouseY <= this.bottom ? 9.0f : 0.0f), (float)246.0f, (int)10, (int)10, (float)256.0f, (float)256.0f);
            }
        }

        private String getSoundEventString(SoundEvent soundEvent) {
            return this.soundEventKeys.computeIfAbsent(soundEvent, t -> Utils.localize(AlarmScreen.this.toLanguageKey(soundEvent.getRegistryName()), new Object[0]).func_150254_d());
        }

        private void renderHighlightBox(int entryRight, Tessellator tesselator, int baseY, int slotBuffer, int slotIndex, int min) {
            int max = entryRight - 6;
            int slotTop = baseY + slotIndex * this.slotHeight;
            BufferBuilder bufferBuilder = tesselator.func_178180_c();
            GlStateManager.func_179090_x();
            GlStateManager.func_179147_l();
            bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            bufferBuilder.func_181662_b((double)min, (double)(slotTop + slotBuffer + 2), 0.0).func_187315_a(0.0, 1.0).func_181669_b(128, 128, 128, 255).func_181675_d();
            bufferBuilder.func_181662_b((double)max, (double)(slotTop + slotBuffer + 2), 0.0).func_187315_a(1.0, 1.0).func_181669_b(128, 128, 128, 255).func_181675_d();
            bufferBuilder.func_181662_b((double)max, (double)(slotTop - 2), 0.0).func_187315_a(1.0, 0.0).func_181669_b(128, 128, 128, 255).func_181675_d();
            bufferBuilder.func_181662_b((double)min, (double)(slotTop - 2), 0.0).func_187315_a(0.0, 0.0).func_181669_b(128, 128, 128, 255).func_181675_d();
            bufferBuilder.func_181662_b((double)(min + 1), (double)(slotTop + slotBuffer + 1), 0.0).func_187315_a(0.0, 1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            bufferBuilder.func_181662_b((double)(max - 1), (double)(slotTop + slotBuffer + 1), 0.0).func_187315_a(1.0, 1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            bufferBuilder.func_181662_b((double)(max - 1), (double)(slotTop - 1), 0.0).func_187315_a(1.0, 0.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            bufferBuilder.func_181662_b((double)(min + 1), (double)(slotTop - 1), 0.0).func_187315_a(0.0, 0.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            tesselator.func_78381_a();
            GlStateManager.func_179098_w();
            GlStateManager.func_179084_k();
        }

        public void selectSound(int slotIndex) {
            this.selectedSoundIndex = slotIndex;
            AlarmScreen.this.selectSound(this.filteredSoundEvents.get(slotIndex).getRegistryName());
        }

        public void playSound(SoundEvent soundEvent) {
            SoundHandler soundManager = Minecraft.func_71410_x().func_147118_V();
            if (this.playingSound != null) {
                soundManager.func_147683_b(this.playingSound);
            }
            this.playingSound = PositionedSoundRecord.func_194007_a((SoundEvent)soundEvent, (float)1.0f, (float)1.0f);
            soundManager.func_147682_a(this.playingSound);
        }

        public void updateFilteredEntries(String searchText) {
            this.filteredSoundEvents = new ArrayList<SoundEvent>(this.allSoundEvents.stream().filter(e -> AlarmScreen.this.toLanguageKey(e.getRegistryName()).contains(searchText)).sorted((se1, se2) -> se1.getRegistryName().toString().compareTo(se2.getRegistryName().toString())).collect(Collectors.toList()));
            this.recalculateContentHeight();
            this.updateSelectedSoundIndex();
            if (!searchText.equals(this.previousSearchText)) {
                this.previousSearchText = searchText;
                this.scrollDistance = 0.0f;
            }
        }

        public void recalculateContentHeight() {
            int height = this.filteredSoundEvents.size() * (((AlarmScreen)AlarmScreen.this).field_146289_q.field_78288_b + 3);
            if (height < this.bottom - this.top - 4) {
                height = this.bottom - this.top - 4;
            }
            this.contentHeight = height;
        }

        public void updateSelectedSoundIndex() {
            this.selectedSoundIndex = Iterables.indexOf(this.filteredSoundEvents, se -> se.getRegistryName().equals((Object)AlarmScreen.this.selectedSoundEvent));
        }

        @Override
        public int getSize() {
            return this.filteredSoundEvents.size();
        }

        public void updateSize(int leftDifference, int topDifference) {
            this.left += leftDifference;
            this.top += topDifference;
            this.right = this.left + this.listWidth;
            this.bottom = this.top + this.listHeight;
            this.scrollBarRight = this.left + this.listWidth;
            this.scrollBarLeft = this.scrollBarRight - 6;
        }
    }
}

