/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.screen;

import java.util.ArrayList;
import java.util.List;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.IExplosive;
import net.geforcemods.securitycraft.inventory.GenericMenu;
import net.geforcemods.securitycraft.network.server.RemoteControlMine;
import net.geforcemods.securitycraft.network.server.RemoveMineFromMRAT;
import net.geforcemods.securitycraft.screen.components.PictureButton;
import net.geforcemods.securitycraft.screen.components.StringHoverChecker;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class MineRemoteAccessToolScreen
extends GuiContainer {
    private static final ResourceLocation TEXTURE = new ResourceLocation("securitycraft:textures/gui/container/mrat.png");
    private static final ResourceLocation INFO_BOOK_ICONS = new ResourceLocation("securitycraft:textures/gui/info_book_icons.png");
    private ItemStack mrat;
    private GuiButton[][] buttons = new GuiButton[6][4];
    private static final int DEFUSE = 0;
    private static final int ACTIVATE = 1;
    private static final int DETONATE = 2;
    private static final int UNBIND = 3;
    private List<StringHoverChecker> hoverCheckers = new ArrayList<StringHoverChecker>();

    public MineRemoteAccessToolScreen(ItemStack item) {
        super((Container)new GenericMenu(null));
        this.mrat = item;
        this.field_146999_f = 256;
        this.field_147000_g = 184;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        int padding = 25;
        int y = 50;
        int[] coords = null;
        int id = 0;
        this.hoverCheckers.clear();
        for (int i = 0; i < 6; ++i) {
            y += 25;
            coords = this.getMineCoordinates(i);
            for (int j = 0; j < 4; ++j) {
                int btnX = this.field_147003_i + j * padding + 154;
                int btnY = this.field_147009_r + y - 48;
                switch (j) {
                    case 0: {
                        this.buttons[i][j] = new PictureButton(id++, btnX, btnY, 20, 20, this.field_146296_j, new ItemStack(SCContent.wireCutters));
                        this.buttons[i][j].field_146124_l = false;
                        break;
                    }
                    case 1: {
                        this.buttons[i][j] = new PictureButton(id++, btnX, btnY, 20, 20, this.field_146296_j, new ItemStack(Items.field_151033_d));
                        this.buttons[i][j].field_146124_l = false;
                        break;
                    }
                    case 2: {
                        this.buttons[i][j] = new PictureButton(id++, btnX, btnY, 20, 20, INFO_BOOK_ICONS, 54, 1, 0, 1, 18, 18, 256, 256);
                        this.buttons[i][j].field_146124_l = false;
                        break;
                    }
                    case 3: {
                        this.buttons[i][j] = new GuiButton(id++, btnX, btnY, 20, 20, "X");
                        this.buttons[i][j].field_146124_l = false;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Mine actions can only range from 0-3 (inclusive)");
                    }
                }
                this.field_146292_n.add(this.buttons[i][j]);
            }
            BlockPos minePos = new BlockPos(coords[0], coords[1], coords[2]);
            if (coords[0] == 0 && coords[1] == 0 && coords[2] == 0) continue;
            this.buttons[i][3].field_146124_l = true;
            if (Minecraft.func_71410_x().field_71439_g.field_70170_p.func_175668_a(minePos, false)) {
                Block block = this.field_146297_k.field_71441_e.func_180495_p(minePos).func_177230_c();
                if (block instanceof IExplosive) {
                    boolean active = ((IExplosive)block).isActive((World)this.field_146297_k.field_71441_e, minePos);
                    boolean defusable = ((IExplosive)block).isDefusable();
                    this.buttons[i][0].field_146124_l = active && defusable;
                    this.buttons[i][1].field_146124_l = !active && defusable;
                    this.buttons[i][2].field_146124_l = active;
                    this.hoverCheckers.add(new StringHoverChecker(this.buttons[i][0], Utils.localize("gui.securitycraft:mrat.defuse", new Object[0]).func_150254_d()));
                    this.hoverCheckers.add(new StringHoverChecker(this.buttons[i][1], Utils.localize("gui.securitycraft:mrat.activate", new Object[0]).func_150254_d()));
                    this.hoverCheckers.add(new StringHoverChecker(this.buttons[i][2], Utils.localize("gui.securitycraft:mrat.detonate", new Object[0]).func_150254_d()));
                    this.hoverCheckers.add(new StringHoverChecker(this.buttons[i][3], Utils.localize("gui.securitycraft:mrat.unbind", new Object[0]).func_150254_d()));
                    continue;
                }
                this.removeTagFromToolAndUpdate(this.mrat, coords[0], coords[1], coords[2]);
                for (int j = 0; j < 4; ++j) {
                    this.buttons[i][j].field_146124_l = false;
                }
                continue;
            }
            for (int j = 0; j < 3; ++j) {
                this.hoverCheckers.add(new StringHoverChecker(this.buttons[i][j], Utils.localize("gui.securitycraft:mrat.outOfRange", new Object[0]).func_150254_d()));
            }
            this.hoverCheckers.add(new StringHoverChecker(this.buttons[i][3], Utils.localize("gui.securitycraft:mrat.unbind", new Object[0]).func_150254_d()));
        }
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b(this.mrat.func_82833_r(), this.field_146999_f / 2 - this.field_146289_q.func_78256_a(this.mrat.func_82833_r()) / 2, 6, 0x404040);
        for (int i = 0; i < 6; ++i) {
            int[] coords = this.getMineCoordinates(i);
            String line = coords[0] == 0 && coords[1] == 0 && coords[2] == 0 ? Utils.localize("gui.securitycraft:mrat.notBound", new Object[0]).func_150254_d() : Utils.localize("gui.securitycraft:mrat.mineLocations", Utils.getFormattedCoordinates(new BlockPos(coords[0], coords[1], coords[2]))).func_150254_d();
            this.field_146289_q.func_78276_b(line, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(line) + 25, i * 25 + 33, 0x404040);
        }
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        int startX = (this.field_146294_l - this.field_146999_f) / 2;
        int startY = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_146276_q_();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(TEXTURE);
        this.func_73729_b(startX, startY, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        for (StringHoverChecker chc : this.hoverCheckers) {
            if (chc == null || !chc.checkHover(mouseX, mouseY) || chc.getName() == null) continue;
            this.drawHoveringText(chc.getLines(), mouseX, mouseY, this.field_146289_q);
        }
    }

    protected void func_146284_a(GuiButton button) {
        int mine = button.field_146127_k / 4;
        int action = button.field_146127_k % 4;
        int[] coords = this.getMineCoordinates(mine);
        switch (action) {
            case 0: {
                ((IExplosive)Minecraft.func_71410_x().field_71439_g.field_70170_p.func_180495_p(new BlockPos(coords[0], coords[1], coords[2])).func_177230_c()).defuseMine(Minecraft.func_71410_x().field_71439_g.field_70170_p, new BlockPos(coords[0], coords[1], coords[2]));
                SecurityCraft.network.sendToServer((IMessage)new RemoteControlMine(coords[0], coords[1], coords[2], "defuse"));
                this.buttons[mine][0].field_146124_l = false;
                this.buttons[mine][1].field_146124_l = true;
                this.buttons[mine][2].field_146124_l = false;
                break;
            }
            case 1: {
                ((IExplosive)Minecraft.func_71410_x().field_71439_g.field_70170_p.func_180495_p(new BlockPos(coords[0], coords[1], coords[2])).func_177230_c()).activateMine(Minecraft.func_71410_x().field_71439_g.field_70170_p, new BlockPos(coords[0], coords[1], coords[2]));
                SecurityCraft.network.sendToServer((IMessage)new RemoteControlMine(coords[0], coords[1], coords[2], "activate"));
                this.buttons[mine][0].field_146124_l = true;
                this.buttons[mine][1].field_146124_l = false;
                this.buttons[mine][2].field_146124_l = true;
                break;
            }
            case 2: {
                SecurityCraft.network.sendToServer((IMessage)new RemoteControlMine(coords[0], coords[1], coords[2], "detonate"));
                this.removeTagFromToolAndUpdate(this.mrat, coords[0], coords[1], coords[2]);
                for (int i = 0; i < 4; ++i) {
                    this.buttons[mine][i].field_146124_l = false;
                }
                break;
            }
            case 3: {
                this.removeTagFromToolAndUpdate(this.mrat, coords[0], coords[1], coords[2]);
                for (int i = 0; i < 4; ++i) {
                    this.buttons[mine][i].field_146124_l = false;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Mine actions can only range from 0-3 (inclusive)");
            }
        }
    }

    private int[] getMineCoordinates(int mine) {
        if (this.mrat.func_77973_b() != null && this.mrat.func_77973_b() == SCContent.mineRemoteAccessTool && this.mrat.func_77978_p() != null && this.mrat.func_77978_p().func_74759_k("mine" + ++mine) != null && this.mrat.func_77978_p().func_74759_k("mine" + mine).length > 0) {
            return this.mrat.func_77978_p().func_74759_k("mine" + mine);
        }
        return new int[]{0, 0, 0};
    }

    private void removeTagFromToolAndUpdate(ItemStack stack, int x, int y, int z) {
        if (stack.func_77978_p() == null) {
            return;
        }
        for (int i = 1; i <= 6; ++i) {
            int[] coords;
            if (stack.func_77978_p().func_74759_k("mine" + i).length <= 0 || (coords = stack.func_77978_p().func_74759_k("mine" + i))[0] != x || coords[1] != y || coords[2] != z) continue;
            stack.func_77978_p().func_74783_a("mine" + i, new int[]{0, 0, 0});
            SecurityCraft.network.sendToServer((IMessage)new RemoveMineFromMRAT(i));
            return;
        }
    }
}

