/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.screen;

import java.awt.Rectangle;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.blockentities.ProjectorBlockEntity;
import net.geforcemods.securitycraft.inventory.ProjectorMenu;
import net.geforcemods.securitycraft.inventory.StateSelectorAccessMenu;
import net.geforcemods.securitycraft.network.server.SyncProjector;
import net.geforcemods.securitycraft.screen.components.CallbackCheckbox;
import net.geforcemods.securitycraft.screen.components.ClickButton;
import net.geforcemods.securitycraft.screen.components.Slider;
import net.geforcemods.securitycraft.screen.components.StateSelector;
import net.geforcemods.securitycraft.screen.components.StringHoverChecker;
import net.geforcemods.securitycraft.screen.components.TogglePictureButton;
import net.geforcemods.securitycraft.util.IHasExtraAreas;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.block.Block;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ProjectorScreen
extends GuiContainer
implements Slider.ISlider,
IHasExtraAreas {
    private static final ResourceLocation TEXTURE = new ResourceLocation("securitycraft:textures/gui/container/projector.png");
    private static final String SLOT_TOOLTIP = Utils.localize("gui.securitycraft:projector.block", new Object[0]).func_150254_d();
    private ProjectorBlockEntity te;
    private Block block;
    private String title;
    private StringHoverChecker[] hoverCheckers = new StringHoverChecker[6];
    private StringHoverChecker slotHoverChecker;
    private Slider projectionWidthSlider;
    private Slider projectionHeightSlider;
    private Slider projectionRangeSlider;
    private Slider projectionOffsetSlider;
    private StateSelector stateSelector;
    private int sliderWidth = 120;

    public ProjectorScreen(InventoryPlayer inv, ProjectorBlockEntity te) {
        super((Container)new ProjectorMenu(inv, te));
        this.te = te;
        this.block = te.func_145831_w().func_180495_p(te.func_174877_v()).func_177230_c();
        this.title = te.func_145748_c_().func_150254_d();
        this.field_147000_g = 235;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_147003_i += 90;
        int id = 0;
        int left = this.field_147003_i + (this.field_146999_f - this.sliderWidth) / 2;
        this.projectionWidthSlider = (Slider)this.func_189646_b((GuiButton)new Slider(Utils.localize("gui.securitycraft:projector.width", this.te.getProjectionWidth()).func_150254_d(), this.block, id, left, this.field_147009_r + 57, this.sliderWidth, 20, Utils.localize("gui.securitycraft:projector.width", "").func_150254_d(), 1.0, 10.0, this.te.getProjectionWidth(), true, this));
        this.hoverCheckers[id++] = new StringHoverChecker((GuiButton)this.projectionWidthSlider, Utils.localize("gui.securitycraft:projector.width.description", new Object[0]).func_150254_d());
        this.projectionHeightSlider = (Slider)this.func_189646_b((GuiButton)new Slider(Utils.localize("gui.securitycraft:projector.height", this.te.getProjectionHeight()).func_150254_d(), this.block, id, left, this.field_147009_r + 78, this.sliderWidth, 20, Utils.localize("gui.securitycraft:projector.height", "").func_150254_d(), 1.0, 10.0, this.te.getProjectionHeight(), true, this));
        this.hoverCheckers[id++] = new StringHoverChecker((GuiButton)this.projectionHeightSlider, Utils.localize("gui.securitycraft:projector.height.description", new Object[0]).func_150254_d());
        this.projectionRangeSlider = (Slider)this.func_189646_b((GuiButton)new Slider(Utils.localize("gui.securitycraft:projector.range", this.te.getProjectionRange()).func_150254_d(), this.block, id, left, this.field_147009_r + 99, this.sliderWidth, 20, Utils.localize("gui.securitycraft:projector.range", "").func_150254_d(), 1.0, 30.0, this.te.getProjectionRange(), true, this));
        this.hoverCheckers[id++] = new StringHoverChecker((GuiButton)this.projectionRangeSlider, Utils.localize("gui.securitycraft:projector.range.description", new Object[0]).func_150254_d());
        this.projectionOffsetSlider = (Slider)this.func_189646_b((GuiButton)new Slider(Utils.localize("gui.securitycraft:projector.offset", this.te.getProjectionOffset()).func_150254_d(), this.block, id, left, this.field_147009_r + 120, this.sliderWidth, 20, Utils.localize("gui.securitycraft:projector.offset", "").func_150254_d(), -10.0, 10.0, this.te.getProjectionOffset(), true, this));
        this.hoverCheckers[id++] = new StringHoverChecker((GuiButton)this.projectionOffsetSlider, Utils.localize("gui.securitycraft:projector.offset.description", new Object[0]).func_150254_d());
        TogglePictureButton toggleButton = (TogglePictureButton)this.func_189646_b((GuiButton)new TogglePictureButton(id, left + this.sliderWidth - 20, this.field_147009_r + 36, 20, 20, TEXTURE, new int[]{176, 192}, new int[]{0, 0}, 2, 2, b -> {
            this.te.setHorizontal(!this.te.isHorizontal());
            this.projectionRangeSlider.updateSlider();
            SecurityCraft.network.sendToServer((IMessage)new SyncProjector(this.te.func_174877_v(), this.te.isHorizontal() ? 1 : 0, SyncProjector.DataType.HORIZONTAL));
        }));
        toggleButton.setCurrentIndex(this.te.isHorizontal() ? 1 : 0);
        this.hoverCheckers[id++] = new StringHoverChecker((GuiButton)toggleButton, Arrays.asList(Utils.localize("gui.securitycraft:projector.vertical", new Object[0]).func_150254_d(), Utils.localize("gui.securitycraft:projector.horizontal", new Object[0]).func_150254_d()));
        this.projectionRangeSlider.updateSlider();
        CallbackCheckbox overrideCheckbox = (CallbackCheckbox)this.func_189646_b((GuiButton)new CallbackCheckbox(id, left + this.sliderWidth - 41, this.field_147009_r + 36, 20, 20, "", this.te.isOverridingBlocks(), newValue -> {
            this.te.setOverridingBlocks((boolean)newValue);
            SecurityCraft.network.sendToServer((IMessage)new SyncProjector(this.te.func_174877_v(), this.te.isOverridingBlocks() ? 1 : 0, SyncProjector.DataType.OVERRIDING_BLOCKS));
        }, 0));
        this.hoverCheckers[id++] = new StringHoverChecker((GuiButton)overrideCheckbox, Arrays.asList(Utils.localize("gui.securitycraft:projector.isOverridingBlocks.yes", new Object[0]).func_150254_d(), Utils.localize("gui.securitycraft:projector.isOverridingBlocks.no", new Object[0]).func_150254_d()));
        this.slotHoverChecker = new StringHoverChecker(this.field_147009_r + 22, this.field_147009_r + 39, this.field_147003_i + 78, this.field_147003_i + 95, SLOT_TOOLTIP);
        this.stateSelector = new StateSelector((StateSelectorAccessMenu)this.field_147002_h, this.field_147003_i - 190, this.field_147009_r + 7, 0, 197, 0);
        this.stateSelector.func_73866_w_();
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
        for (StringHoverChecker thc : this.hoverCheckers) {
            if (!thc.checkHover(mouseX, mouseY)) continue;
            this.func_146279_a(thc.getName(), mouseX, mouseY);
        }
        if (this.slotHoverChecker.checkHover(mouseX, mouseY) && this.te.func_191420_l()) {
            this.func_146279_a(this.slotHoverChecker.getName(), mouseX, mouseY);
        }
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b(this.title, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(this.title) / 2, 6, 0x404040);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        this.func_146276_q_();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(TEXTURE);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        if (this.stateSelector != null) {
            this.stateSelector.func_73863_a(mouseX, mouseY, partialTicks);
        }
    }

    protected void func_146284_a(GuiButton button) {
        if (button instanceof ClickButton) {
            ((ClickButton)button).onClick();
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int button) throws IOException {
        if (this.stateSelector != null) {
            this.stateSelector.func_73864_a(mouseX, mouseY, button);
        }
        super.func_73864_a(mouseX, mouseY, button);
    }

    protected void func_146286_b(int mouseX, int mouseY, int state) {
        if (this.stateSelector != null) {
            this.stateSelector.func_146286_b(mouseX, mouseY, state);
        }
        super.func_146286_b(mouseX, mouseY, state);
    }

    @Override
    public List<Rectangle> getGuiExtraAreas() {
        if (this.stateSelector != null) {
            return this.stateSelector.getExtraAreas();
        }
        return new ArrayList<Rectangle>();
    }

    public void func_146281_b() {
        super.func_146281_b();
        if (this.stateSelector.getState() != null) {
            this.te.setProjectedState(this.stateSelector.getState());
            SecurityCraft.network.sendToServer((IMessage)new SyncProjector(this.te.func_174877_v(), this.stateSelector.getState()));
        }
    }

    @Override
    public void onMouseRelease(int id) {
        int data = 0;
        SyncProjector.DataType dataType = SyncProjector.DataType.INVALID;
        if (id == this.projectionWidthSlider.field_146127_k) {
            data = this.projectionWidthSlider.getValueInt();
            this.te.setProjectionWidth(data);
            dataType = SyncProjector.DataType.WIDTH;
        } else if (id == this.projectionHeightSlider.field_146127_k) {
            data = this.projectionHeightSlider.getValueInt();
            this.te.setProjectionHeight(data);
            dataType = SyncProjector.DataType.HEIGHT;
        } else if (id == this.projectionRangeSlider.field_146127_k) {
            data = this.projectionRangeSlider.getValueInt();
            this.te.setProjectionRange(data);
            dataType = SyncProjector.DataType.RANGE;
        } else if (id == this.projectionOffsetSlider.field_146127_k) {
            data = this.projectionOffsetSlider.getValueInt();
            this.te.setProjectionOffset(data);
            dataType = SyncProjector.DataType.OFFSET;
        }
        SecurityCraft.network.sendToServer((IMessage)new SyncProjector(this.te.func_174877_v(), data, dataType));
    }

    @Override
    public void onChangeSliderValue(Slider slider, Block block, int id) {
        slider.field_146126_j = this.te.isHorizontal() && slider.field_146127_k == this.projectionRangeSlider.field_146127_k ? slider.getPrefix() + (slider.getValueInt() - 16) : slider.getPrefix() + slider.getValueInt();
    }
}

