/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.compat.ftbutilities.FTBUtilitiesCompat;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerList;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Loader;

public class TeamUtils {
    private TeamUtils() {
    }

    public static boolean areOnSameTeam(Owner owner1, Owner owner2) {
        if (owner1.equals(owner2)) {
            return true;
        }
        if (Loader.isModLoaded((String)"ftbutilities")) {
            return FTBUtilitiesCompat.areOnSameTeam(owner1, owner2);
        }
        ScorePlayerTeam team = TeamUtils.getVanillaTeamFromPlayer(owner1.getName());
        return team != null && team.func_96670_d().contains(owner2.getName());
    }

    public static ScorePlayerTeam getVanillaTeamFromPlayer(String playerName) {
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (server != null) {
            return server.func_130014_f_().func_96441_U().func_96509_i(playerName);
        }
        return SecurityCraft.proxy.getClientPlayer().field_70170_p.func_96441_U().func_96509_i(playerName);
    }

    public static TeamRepresentation getTeamRepresentation(Owner owner) {
        if (Loader.isModLoaded((String)"ftbutilities")) {
            return FTBUtilitiesCompat.getTeamRepresentation(owner);
        }
        ScorePlayerTeam team = TeamUtils.getVanillaTeamFromPlayer(owner.getName());
        if (team != null) {
            TextFormatting color = team.func_178775_l();
            return new TeamRepresentation(team.func_96669_c(), !color.func_96302_c() ? TextFormatting.GRAY : color);
        }
        return null;
    }

    public static Collection<EntityPlayerMP> getOnlinePlayersInTeam(MinecraftServer server, Owner owner) {
        if (Loader.isModLoaded((String)"ftbutilities")) {
            return FTBUtilitiesCompat.getOnlinePlayersInTeam(owner);
        }
        ScorePlayerTeam team = TeamUtils.getVanillaTeamFromPlayer(owner.getName());
        if (team != null) {
            return team.func_96670_d().stream().map(arg_0 -> ((PlayerList)server.func_184103_al()).func_152612_a(arg_0)).filter(Objects::nonNull).collect(Collectors.toList());
        }
        return new ArrayList<EntityPlayerMP>();
    }

    public static class TeamRepresentation {
        private final String name;
        private final TextFormatting color;

        public TeamRepresentation(String name, TextFormatting color) {
            this.name = name;
            this.color = color;
        }

        public String name() {
            return this.name;
        }

        public TextFormatting color() {
            return this.color;
        }
    }
}

