/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.generator;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.supermartijn642.core.data.TagLoader;
import com.supermartijn642.core.generator.ResourceCache;
import com.supermartijn642.core.generator.ResourceGenerator;
import com.supermartijn642.core.generator.ResourceType;
import com.supermartijn642.core.generator.aggregator.ResourceAggregator;
import com.supermartijn642.core.registry.Registries;
import com.supermartijn642.core.registry.RegistryUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.EntityEntry;

public abstract class TagGenerator
extends ResourceGenerator {
    private static final Map<Registries.Registry<?>, String> TAG_DIRECTORIES = new HashMap();
    private static final Gson GSON;
    private static final ResourceAggregator<TagBuilder<?>, TagBuilder<?>> AGGREGATOR;
    private final Map<Registries.Registry<?>, Map<ResourceLocation, TagBuilder<?>>> tags = new HashMap();

    public TagGenerator(String modid, ResourceCache cache) {
        super(modid, cache);
    }

    @Override
    public void save() {
        for (Map.Entry<Registries.Registry<?>, Map<ResourceLocation, TagBuilder<?>>> registryEntry : this.tags.entrySet()) {
            String directoryName = TagGenerator.getTagDirectoryName(registryEntry.getKey());
            for (TagBuilder<?> tag : registryEntry.getValue().values()) {
                for (ResourceLocation reference : ((TagBuilder)tag).references) {
                    if (registryEntry.getValue().containsKey(reference) || TagLoader.getTag(registryEntry.getKey(), reference) != null || this.cache.doesResourceExist(ResourceType.DATA, reference.func_110624_b(), directoryName, reference.func_110623_a(), ".json")) continue;
                    throw new RuntimeException("Could not find tag reference '" + reference + "'!");
                }
                ResourceLocation identifier = tag.identifier;
                this.cache.saveResource(ResourceType.DATA, AGGREGATOR, tag, identifier.func_110624_b(), directoryName, identifier.func_110623_a(), ".json");
            }
        }
    }

    private static String getTagDirectoryName(Registries.Registry<?> registry) {
        return "tags/" + TAG_DIRECTORIES.get(registry);
    }

    protected <T> TagBuilder<T> tag(Registries.Registry<T> registry, ResourceLocation identifier) {
        this.cache.trackToBeGeneratedResource(ResourceType.DATA, identifier.func_110624_b(), TagGenerator.getTagDirectoryName(registry), identifier.func_110623_a(), ".json");
        return this.tags.computeIfAbsent(registry, o -> new HashMap()).computeIfAbsent(identifier, identifier1 -> new TagBuilder(registry, (ResourceLocation)identifier1));
    }

    protected <T> TagBuilder<T> tag(Registries.Registry<T> registry, String namespace, String identifier) {
        return this.tag(registry, new ResourceLocation(namespace, identifier));
    }

    protected <T> TagBuilder<T> tag(Registries.Registry<T> registry, String identifier) {
        return this.tag(registry, this.modid, identifier);
    }

    protected TagBuilder<Block> blockTag(ResourceLocation identifier) {
        return this.tag(Registries.BLOCKS, identifier);
    }

    protected TagBuilder<Block> blockTag(String namespace, String identifier) {
        return this.tag(Registries.BLOCKS, namespace, identifier);
    }

    protected TagBuilder<Block> blockTag(String identifier) {
        return this.tag(Registries.BLOCKS, identifier);
    }

    protected TagBuilder<Item> itemTag(ResourceLocation identifier) {
        return this.tag(Registries.ITEMS, identifier);
    }

    protected TagBuilder<Item> itemTag(String namespace, String identifier) {
        return this.tag(Registries.ITEMS, namespace, identifier);
    }

    protected TagBuilder<Item> itemTag(String identifier) {
        return this.tag(Registries.ITEMS, identifier);
    }

    protected TagBuilder<EntityEntry> entityTag(ResourceLocation identifier) {
        return this.tag(Registries.ENTITY_TYPES, identifier);
    }

    protected TagBuilder<EntityEntry> entityTag(String namespace, String identifier) {
        return this.tag(Registries.ENTITY_TYPES, namespace, identifier);
    }

    protected TagBuilder<EntityEntry> entityTag(String identifier) {
        return this.tag(Registries.ENTITY_TYPES, identifier);
    }

    protected TagBuilder<Block> blockMineableWithAxe() {
        return this.blockTag("minecraft", "mineable/axe");
    }

    protected TagBuilder<Block> blockMineableWithHoe() {
        return this.blockTag("minecraft", "mineable/hoe");
    }

    protected TagBuilder<Block> blockMineableWithPickaxe() {
        return this.blockTag("minecraft", "mineable/pickaxe");
    }

    protected TagBuilder<Block> blockMineableWithShovel() {
        return this.blockTag("minecraft", "mineable/shovel");
    }

    protected TagBuilder<Block> blockNeedsStoneTool() {
        return this.blockTag("minecraft", "needs_stone_tool");
    }

    protected TagBuilder<Block> blockNeedsIronTool() {
        return this.blockTag("minecraft", "needs_iron_tool");
    }

    protected TagBuilder<Block> blockNeedsDiamondTool() {
        return this.blockTag("minecraft", "needs_diamond_tool");
    }

    @Override
    public String getName() {
        return this.modName + " Tag Generator";
    }

    static {
        TAG_DIRECTORIES.put(Registries.BLOCKS, "blocks");
        TAG_DIRECTORIES.put(Registries.FLUIDS, "fluids");
        TAG_DIRECTORIES.put(Registries.ITEMS, "items");
        TAG_DIRECTORIES.put(Registries.ENTITY_TYPES, "entity_types");
        GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
        AGGREGATOR = new ResourceAggregator<TagBuilder<?>, TagBuilder<?>>(){

            @Override
            public TagBuilder<?> initialData() {
                return null;
            }

            @Override
            public TagBuilder<?> combine(TagBuilder<?> data, TagBuilder<?> newData) {
                if (data != null) {
                    ((TagBuilder)data).addAll((TagBuilder)newData);
                    return data;
                }
                return newData;
            }

            @Override
            public void write(OutputStream stream, TagBuilder<?> tag) throws IOException {
                JsonObject json = new JsonObject();
                json.addProperty("replace", Boolean.valueOf(((TagBuilder)tag).replace));
                JsonArray entries = new JsonArray();
                ((TagBuilder)tag).entries.forEach(arg_0 -> ((JsonArray)entries).add(arg_0));
                ((TagBuilder)tag).references.stream().map(ResourceLocation::toString).map(s -> "#" + s).forEach(arg_0 -> ((JsonArray)entries).add(arg_0));
                ((TagBuilder)tag).optionalEntries.stream().map(e -> {
                    JsonObject jsonObject = new JsonObject();
                    jsonObject.addProperty("id", e);
                    jsonObject.addProperty("required", Boolean.valueOf(false));
                    return jsonObject;
                }).forEach(arg_0 -> ((JsonArray)entries).add(arg_0));
                ((TagBuilder)tag).optionalReferences.stream().map(e -> {
                    JsonObject entryObject = new JsonObject();
                    entryObject.addProperty("id", "#" + e);
                    entryObject.addProperty("required", Boolean.valueOf(false));
                    return entryObject;
                }).forEach(arg_0 -> ((JsonArray)entries).add(arg_0));
                if (entries.size() > 0 || ((TagBuilder)tag).remove.isEmpty()) {
                    json.add("values", (JsonElement)entries);
                }
                JsonArray removedEntries = new JsonArray();
                ((TagBuilder)tag).remove.forEach(arg_0 -> ((JsonArray)removedEntries).add(arg_0));
                ((TagBuilder)tag).optionalRemove.stream().map(e -> {
                    JsonObject jsonObject = new JsonObject();
                    jsonObject.addProperty("id", e);
                    jsonObject.addProperty("required", Boolean.valueOf(false));
                    return jsonObject;
                }).forEach(arg_0 -> ((JsonArray)entries).add(arg_0));
                if (removedEntries.size() > 0) {
                    json.add("remove", (JsonElement)removedEntries);
                }
                try (OutputStreamWriter writer = new OutputStreamWriter(stream);){
                    GSON.toJson((JsonElement)json, (Appendable)writer);
                }
            }
        };
    }

    protected static class TagBuilder<T> {
        private final Registries.Registry<T> registry;
        protected final ResourceLocation identifier;
        private final Set<String> entries = new HashSet<String>();
        private final Set<String> optionalEntries = new HashSet<String>();
        private final Set<ResourceLocation> references = new HashSet<ResourceLocation>();
        private final Set<String> optionalReferences = new HashSet<String>();
        private final Set<String> remove = new HashSet<String>();
        private final Set<String> optionalRemove = new HashSet<String>();
        private boolean replace;

        protected TagBuilder(Registries.Registry<T> registry, ResourceLocation identifier) {
            this.registry = registry;
            this.identifier = identifier;
        }

        public TagBuilder<T> replace(boolean replace) {
            this.replace = replace;
            return this;
        }

        public TagBuilder<T> replace() {
            return this.replace(true);
        }

        public TagBuilder<T> add(T entry) {
            this.entries.add(this.registry.getIdentifier(entry).toString());
            return this;
        }

        public TagBuilder<T> add(ResourceLocation entry) {
            if (!this.registry.hasIdentifier(entry)) {
                throw new RuntimeException("Could not find any object registered under '" + entry + "'!");
            }
            this.entries.add(entry.toString());
            return this;
        }

        public TagBuilder<T> add(String namespace, String identifier) {
            if (!RegistryUtil.isValidNamespace(namespace)) {
                throw new IllegalArgumentException("Namespace '" + namespace + "' must only contain characters [a-z0-9_.-]!");
            }
            if (!RegistryUtil.isValidPath(identifier)) {
                throw new IllegalArgumentException("Identifier '" + identifier + "' must only contain characters [a-z0-9_./-]!");
            }
            this.add(new ResourceLocation(namespace, identifier));
            return this;
        }

        public TagBuilder<T> add(String entry) {
            if (!RegistryUtil.isValidIdentifier(entry)) {
                throw new IllegalArgumentException("Entry identifier '" + entry + "' contains invalid characters!");
            }
            this.add(new ResourceLocation(entry));
            return this;
        }

        public TagBuilder<T> addOptional(T entry) {
            this.optionalEntries.add(this.registry.getIdentifier(entry).toString());
            return this;
        }

        public TagBuilder<T> addOptional(ResourceLocation entry) {
            this.optionalEntries.add(entry.toString());
            return this;
        }

        public TagBuilder<T> addOptional(String namespace, String identifier) {
            if (!RegistryUtil.isValidNamespace(namespace)) {
                throw new IllegalArgumentException("Namespace '" + namespace + "' must only contain characters [a-z0-9_.-]!");
            }
            if (!RegistryUtil.isValidPath(identifier)) {
                throw new IllegalArgumentException("Identifier '" + identifier + "' must only contain characters [a-z0-9_./-]!");
            }
            this.addOptional(new ResourceLocation(namespace, identifier));
            return this;
        }

        public TagBuilder<T> addOptional(String entry) {
            if (!RegistryUtil.isValidIdentifier(entry)) {
                throw new IllegalArgumentException("Identifier '" + entry + "' contains invalid characters!");
            }
            this.addOptional(new ResourceLocation(entry));
            return this;
        }

        public TagBuilder<T> addReference(ResourceLocation tag) {
            if (this.identifier.equals((Object)tag)) {
                throw new IllegalArgumentException("Cannot add self reference to tag '" + tag + "'!");
            }
            this.references.add(tag);
            return this;
        }

        public TagBuilder<T> addReference(String namespace, String identifier) {
            if (!RegistryUtil.isValidNamespace(namespace)) {
                throw new IllegalArgumentException("Namespace '" + namespace + "' must only contain characters [a-z0-9_.-]!");
            }
            if (!RegistryUtil.isValidPath(identifier)) {
                throw new IllegalArgumentException("Identifier '" + identifier + "' must only contain characters [a-z0-9_./-]!");
            }
            this.addReference(new ResourceLocation(namespace, identifier));
            return this;
        }

        public TagBuilder<T> addReference(String tag) {
            if (!RegistryUtil.isValidIdentifier(tag)) {
                throw new IllegalArgumentException("Tag identifier '" + tag + "' contains invalid characters!");
            }
            this.addReference(new ResourceLocation(tag));
            return this;
        }

        public TagBuilder<T> addOptionalReference(ResourceLocation tag) {
            if (this.identifier.equals((Object)tag)) {
                throw new IllegalArgumentException("Cannot add self reference to tag '" + tag + "'!");
            }
            this.optionalReferences.add(tag.toString());
            return this;
        }

        public TagBuilder<T> addOptionalReference(String namespace, String identifier) {
            if (!RegistryUtil.isValidNamespace(namespace)) {
                throw new IllegalArgumentException("Namespace '" + namespace + "' must only contain characters [a-z0-9_.-]!");
            }
            if (!RegistryUtil.isValidPath(identifier)) {
                throw new IllegalArgumentException("Identifier '" + identifier + "' must only contain characters [a-z0-9_./-]!");
            }
            this.addOptionalReference(new ResourceLocation(namespace, identifier));
            return this;
        }

        public TagBuilder<T> addOptionalReference(String tag) {
            if (!RegistryUtil.isValidIdentifier(tag)) {
                throw new IllegalArgumentException("Tag identifier '" + tag + "' contains invalid characters!");
            }
            this.addOptionalReference(new ResourceLocation(tag));
            return this;
        }

        public TagBuilder<T> remove(T entry) {
            this.remove.add(this.registry.getIdentifier(entry).toString());
            return this;
        }

        public TagBuilder<T> remove(ResourceLocation entry) {
            if (!this.registry.hasIdentifier(entry)) {
                throw new RuntimeException("Could not find any object registered under '" + entry + "'!");
            }
            this.remove.add(entry.toString());
            return this;
        }

        public TagBuilder<T> remove(String namespace, String identifier) {
            if (!RegistryUtil.isValidNamespace(namespace)) {
                throw new IllegalArgumentException("Namespace '" + namespace + "' must only contain characters [a-z0-9_.-]!");
            }
            if (!RegistryUtil.isValidPath(identifier)) {
                throw new IllegalArgumentException("Identifier '" + identifier + "' must only contain characters [a-z0-9_./-]!");
            }
            this.remove(new ResourceLocation(namespace, identifier));
            return this;
        }

        public TagBuilder<T> remove(String entry) {
            if (!RegistryUtil.isValidIdentifier(entry)) {
                throw new IllegalArgumentException("Entry identifier '" + entry + "' contains invalid characters!");
            }
            this.remove(new ResourceLocation(entry));
            return this;
        }

        public TagBuilder<T> removeOptional(T entry) {
            return this.removeOptional(this.registry.getIdentifier(entry));
        }

        public TagBuilder<T> removeOptional(ResourceLocation entry) {
            this.optionalRemove.add(entry.toString());
            return this;
        }

        public TagBuilder<T> removeOptional(String namespace, String identifier) {
            if (!RegistryUtil.isValidNamespace(namespace)) {
                throw new IllegalArgumentException("Namespace '" + namespace + "' must only contain characters [a-z0-9_.-]!");
            }
            if (!RegistryUtil.isValidPath(identifier)) {
                throw new IllegalArgumentException("Identifier '" + identifier + "' must only contain characters [a-z0-9_./-]!");
            }
            this.removeOptional(new ResourceLocation(namespace, identifier));
            return this;
        }

        public TagBuilder<T> removeOptional(String entry) {
            if (!RegistryUtil.isValidIdentifier(entry)) {
                throw new IllegalArgumentException("Identifier '" + entry + "' contains invalid characters!");
            }
            this.removeOptional(new ResourceLocation(entry));
            return this;
        }

        private void addAll(TagBuilder<T> other) {
            this.entries.addAll(other.entries);
            this.optionalEntries.addAll(other.optionalEntries);
            this.references.addAll(other.references);
            this.optionalReferences.addAll(other.optionalReferences);
            this.remove.addAll(other.remove);
            this.optionalRemove.addAll(other.optionalRemove);
        }
    }
}

