/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.mixin.spongeforge;

import com.supermartijn642.core.block.BaseBlock;
import com.supermartijn642.core.registry.RegistrationHandler;
import com.supermartijn642.core.registry.Registries;
import com.supermartijn642.core.registry.RegistryEntryAcceptor;
import java.util.Map;
import net.minecraft.advancements.Advancement;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.ForgeEventFactory;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.cause.EventContextKeys;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.common.SpongeImplHooks;
import org.spongepowered.common.bridge.world.WorldBridge;
import org.spongepowered.common.bridge.world.WorldServerBridge;
import org.spongepowered.common.event.ShouldFire;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.tracking.IPhaseState;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.item.inventory.util.ItemStackUtil;

@Mixin(value={ForgeHooks.class})
public class ForgeHooksMixinSpongeForge {
    @Inject(method={"canHarvestBlock"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private static void canHarvestBlock(Block block, EntityPlayer player, IBlockAccess world, BlockPos pos, CallbackInfoReturnable<Boolean> ci) {
        Object source;
        if (!(block instanceof BaseBlock)) {
            return;
        }
        if (!((BaseBlock)block).requiresCorrectToolForDrops()) {
            ci.setReturnValue(ForgeEventFactory.doPlayerHarvestCheck((EntityPlayer)player, (IBlockState)world.func_180495_p(pos), (boolean)true));
        }
        IBlockState state = world.func_180495_p(pos);
        if ((state = state.func_177230_c().func_176221_a(state, world, pos)).func_185904_a().func_76229_l()) {
            ci.setReturnValue(true);
            return;
        }
        ItemStack stack = player.func_184614_ca();
        String tool = block.getHarvestTool(state);
        if (stack.func_190926_b() || tool == null) {
            ci.setReturnValue(player.func_184823_b(state));
            return;
        }
        PhaseContext context = PhaseTracker.getInstance().getCurrentContext();
        IPhaseState phaseState = context.state;
        Object object = source = context.getSource() == null ? player : context.getSource();
        if (ShouldFire.CHANGE_BLOCK_EVENT_PRE && !phaseState.isInteraction() && world instanceof WorldBridge && !((WorldBridge)world).bridge$isFake() && SpongeImplHooks.isMainThread()) {
            try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
                frame.addContext(EventContextKeys.USED_ITEM, (Object)ItemStackUtil.snapshotOf((ItemStack)player.func_184607_cu()));
                if (SpongeCommonEventFactory.callChangeBlockEventPre((WorldServerBridge)((WorldServerBridge)world), (BlockPos)pos, (Object)source).isCancelled()) {
                    ci.setReturnValue(false);
                    return;
                }
            }
        }
        int toolLevel = -1;
        Item item = stack.func_77973_b();
        for (String toolType : item.getToolClasses(stack)) {
            int harvestLevel;
            if (!state.func_177230_c().isToolEffective(toolType, state) || (harvestLevel = item.getHarvestLevel(stack, toolType, player, state)) <= toolLevel) continue;
            toolLevel = harvestLevel;
        }
        if (toolLevel == -1) {
            toolLevel = item.getHarvestLevel(stack, tool, player, state);
        }
        if (toolLevel < 0) {
            ci.setReturnValue(player.func_184823_b(state));
            return;
        }
        ci.setReturnValue(toolLevel >= block.getHarvestLevel(state));
    }

    @Inject(method={"canToolHarvestBlock"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private static void canToolHarvestBlock(IBlockAccess world, BlockPos pos, ItemStack stack, CallbackInfoReturnable<Boolean> ci) {
        if (stack.func_190926_b()) {
            return;
        }
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() instanceof BaseBlock) {
            int harvestLevel = state.func_177230_c().getHarvestLevel(state);
            for (String toolType : stack.func_77973_b().getToolClasses(stack)) {
                if (!state.func_177230_c().isToolEffective(toolType, state) || stack.func_77973_b().getHarvestLevel(stack, toolType, null, state) < harvestLevel) continue;
                ci.setReturnValue(true);
                return;
            }
            ci.setReturnValue(false);
        }
    }

    @Inject(method={"loadAdvancements"}, at={@At(value="INVOKE", target="Lnet/minecraftforge/common/crafting/CraftingHelper;init()V", shift=At.Shift.AFTER)}, remap=false)
    private static void loadAdvancements(Map<ResourceLocation, Advancement.Builder> map, CallbackInfoReturnable<Boolean> ci) {
        RegistrationHandler.handleResourceConditionSerializerRegistryEvent();
        RegistryEntryAcceptor.Handler.onRegisterEvent(Registries.RECIPE_CONDITION_SERIALIZERS);
    }
}

