/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.doors.movement;

import net.malisis.core.block.BoundingBoxType;
import net.malisis.core.renderer.RenderParameters;
import net.malisis.core.renderer.animation.Animation;
import net.malisis.core.renderer.animation.transformation.ITransformable;
import net.malisis.core.renderer.animation.transformation.Rotation;
import net.malisis.core.renderer.animation.transformation.Transformation;
import net.malisis.core.renderer.model.MalisisModel;
import net.malisis.doors.DoorState;
import net.malisis.doors.movement.IDoorMovement;
import net.malisis.doors.tileentity.DoorTileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;

public class FenceGateMovement
implements IDoorMovement {
    @Override
    public AxisAlignedBB getOpenBoundingBox(DoorTileEntity tileEntity, boolean topBlock, BoundingBoxType type) {
        return null;
    }

    public Rotation getTransformation(DoorTileEntity tileEntity, boolean left) {
        boolean reversedOpen = (tileEntity.func_145832_p() >> 1 & 1) == 1;
        float hinge = -0.4375f;
        float angle = 90.0f;
        if (tileEntity.getDirection().func_176740_k() == EnumFacing.Axis.X) {
            angle = -angle;
        }
        if (!reversedOpen) {
            angle = -angle;
        }
        if (left) {
            angle = -angle;
            hinge = -hinge;
        }
        Rotation rotation = new Rotation(angle).aroundAxis(0.0f, 1.0f, 0.0f).offset(hinge, 0.0f, 0.0f);
        rotation.reversed(tileEntity.getState() == DoorState.CLOSING || tileEntity.getState() == DoorState.CLOSED);
        rotation.forTicks(tileEntity.getDescriptor().getOpeningTime());
        return rotation;
    }

    @Override
    public Animation<?>[] getAnimations(DoorTileEntity tileEntity, MalisisModel model, RenderParameters rp) {
        DoorTileEntity doubleDoor = tileEntity.getDoubleDoor();
        if (doubleDoor != null) {
            boolean left = true;
            left = tileEntity.getDirection().func_176740_k() == EnumFacing.Axis.X ? tileEntity.func_174877_v().func_177952_p() < doubleDoor.func_174877_v().func_177952_p() : tileEntity.func_174877_v().func_177958_n() > doubleDoor.func_174877_v().func_177958_n();
            return new Animation[]{new Animation((ITransformable)model, (Transformation)this.getTransformation(tileEntity, left))};
        }
        return new Animation[]{new Animation((ITransformable)model.getShape("left"), (Transformation)this.getTransformation(tileEntity, true)), new Animation((ITransformable)model.getShape("right"), (Transformation)this.getTransformation(tileEntity, false))};
    }

    @Override
    public boolean isSpecial() {
        return true;
    }
}

