/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.config;

import de.maxhenkel.voicechat.Voicechat;
import de.maxhenkel.voicechat.configbuilder.CommentedProperties;
import de.maxhenkel.voicechat.configbuilder.CommentedPropertyConfig;
import de.maxhenkel.voicechat.intercompatibility.CommonCompatibilityManager;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class VolumeConfig
extends CommentedPropertyConfig {
    private final Map<UUID, Double> volumes;
    private final Map<String, Double> categoryVolumes;

    public VolumeConfig(Path path) {
        super(new CommentedProperties(false));
        this.path = path;
        this.reload();
        this.properties.setHeaderComments(Collections.singletonList(String.format("%s volume config", CommonCompatibilityManager.INSTANCE.getModName())));
        Map<String, String> entries = this.getEntries();
        this.volumes = new HashMap<UUID, Double>();
        this.categoryVolumes = new HashMap<String, Double>();
        for (Map.Entry<String, String> entry : entries.entrySet()) {
            this.properties.setComments(entry.getKey(), Collections.emptyList());
            try {
                double volume = Double.parseDouble(entry.getValue().toString());
                try {
                    this.volumes.put(UUID.fromString(entry.getKey()), volume);
                }
                catch (IllegalArgumentException e) {
                    this.categoryVolumes.put(entry.getKey(), volume);
                }
            }
            catch (NumberFormatException e) {
                Voicechat.LOGGER.warn("Invalid volume value '{}' for '{}'", entry.getValue(), entry.getKey());
                this.properties.remove(entry.getKey());
            }
        }
        this.saveSync();
    }

    public double getPlayerVolume(UUID uuid, double def) {
        Double volume = this.volumes.get(uuid);
        if (volume == null) {
            return def;
        }
        return volume;
    }

    public double getPlayerVolume(UUID playerID) {
        return this.getPlayerVolume(playerID, 1.0);
    }

    public double setPlayerVolume(UUID uuid, double value) {
        this.volumes.put(uuid, value);
        this.properties.set(uuid.toString(), String.valueOf(value), new String[0]);
        return value;
    }

    public Map<UUID, Double> getPlayerVolumes() {
        return Collections.unmodifiableMap(this.volumes);
    }

    public double getCategoryVolume(String category, double def) {
        Double volume = this.categoryVolumes.get(category);
        if (volume == null) {
            return def;
        }
        return volume;
    }

    public double getCategoryVolume(String category) {
        return this.getCategoryVolume(category, 1.0);
    }

    public double setCategoryVolume(String category, double value) {
        this.categoryVolumes.put(category, value);
        this.properties.set(category, String.valueOf(value), new String[0]);
        return value;
    }
}

