/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.voice.common;

import de.maxhenkel.voicechat.voice.common.SoundPacket;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.network.PacketBuffer;

public class PlayerSoundPacket
extends SoundPacket<PlayerSoundPacket> {
    protected boolean whispering;
    protected float distance;

    public PlayerSoundPacket(UUID sender, byte[] data, long sequenceNumber, boolean whispering, float distance, @Nullable String category) {
        super(sender, data, sequenceNumber, category);
        this.whispering = whispering;
        this.distance = distance;
    }

    public PlayerSoundPacket(UUID sender, short[] data, boolean whispering, float distance, @Nullable String category) {
        super(sender, data, category);
        this.whispering = whispering;
        this.distance = distance;
    }

    public PlayerSoundPacket() {
    }

    @Override
    public UUID getSender() {
        return this.sender;
    }

    public boolean isWhispering() {
        return this.whispering;
    }

    public float getDistance() {
        return this.distance;
    }

    @Override
    public PlayerSoundPacket fromBytes(PacketBuffer buf) {
        PlayerSoundPacket soundPacket = new PlayerSoundPacket();
        soundPacket.sender = buf.func_179253_g();
        soundPacket.data = buf.func_179251_a();
        soundPacket.sequenceNumber = buf.readLong();
        soundPacket.distance = buf.readFloat();
        byte data = buf.readByte();
        soundPacket.whispering = this.hasFlag(data, (byte)1);
        if (this.hasFlag(data, (byte)2)) {
            soundPacket.category = buf.func_150789_c(16);
        }
        return soundPacket;
    }

    @Override
    public void toBytes(PacketBuffer buf) {
        buf.func_179252_a(this.sender);
        buf.func_179250_a(this.data);
        buf.writeLong(this.sequenceNumber);
        buf.writeFloat(this.distance);
        byte data = 0;
        if (this.whispering) {
            data = this.setFlag(data, (byte)1);
        }
        if (this.category != null) {
            data = this.setFlag(data, (byte)2);
        }
        buf.writeByte((int)data);
        if (this.category != null) {
            buf.func_180714_a(this.category);
        }
    }
}

