/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.item;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import me.desht.pneumaticcraft.api.item.IInventoryItem;
import me.desht.pneumaticcraft.api.item.IItemRegistry;
import me.desht.pneumaticcraft.api.item.IMagnetSuppressor;
import me.desht.pneumaticcraft.api.item.IUpgradeAcceptor;
import me.desht.pneumaticcraft.common.item.Itemss;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;

public class ItemRegistry
implements IItemRegistry {
    private static final ItemRegistry INSTANCE = new ItemRegistry();
    public final List<IInventoryItem> inventoryItems = new ArrayList<IInventoryItem>();
    private final Map<Item, List<IUpgradeAcceptor>> upgradeToAcceptors = new HashMap<Item, List<IUpgradeAcceptor>>();
    private final List<IMagnetSuppressor> magnetSuppressors = new ArrayList<IMagnetSuppressor>();

    public static ItemRegistry getInstance() {
        return INSTANCE;
    }

    @Override
    public void registerInventoryItem(IInventoryItem handler) {
        if (handler == null) {
            throw new NullPointerException("IInventoryItem is null!");
        }
        this.inventoryItems.add(handler);
    }

    @Override
    public Item getUpgrade(IItemRegistry.EnumUpgrade type) {
        return Itemss.upgrades.get(type);
    }

    @Override
    public void registerUpgradeAcceptor(IUpgradeAcceptor upgradeAcceptor) {
        if (upgradeAcceptor == null) {
            throw new NullPointerException("Upgrade acceptor is null!");
        }
        Set<Item> applicableUpgrades = upgradeAcceptor.getApplicableUpgrades();
        if (applicableUpgrades != null) {
            for (Item applicableUpgrade : applicableUpgrades) {
                List acceptors = this.upgradeToAcceptors.computeIfAbsent(applicableUpgrade, k -> new ArrayList());
                acceptors.add(upgradeAcceptor);
            }
        }
    }

    @Override
    public void addTooltip(Item upgrade, List<String> tooltip) {
        List<IUpgradeAcceptor> acceptors = this.upgradeToAcceptors.get(upgrade);
        if (acceptors != null) {
            ArrayList<String> tempList = new ArrayList<String>(acceptors.size());
            for (IUpgradeAcceptor acceptor : acceptors) {
                tempList.add("\u2022 " + I18n.func_135052_a((String)acceptor.getName(), (Object[])new Object[0]));
            }
            Collections.sort(tempList);
            tooltip.addAll(tempList);
        }
    }

    @Override
    public void registerMagnetSuppressor(IMagnetSuppressor suppressor) {
        this.magnetSuppressors.add(suppressor);
    }

    public boolean shouldSuppressMagnet(Entity e) {
        return this.magnetSuppressors.stream().anyMatch(s -> s.shouldSuppressMagnet(e));
    }
}

