/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.blast;

import icbm.classic.api.ICBMClassicHelpers;
import icbm.classic.api.caps.IEMPReceiver;
import icbm.classic.api.events.EmpEvent;
import icbm.classic.client.ICBMSounds;
import icbm.classic.config.ConfigEMP;
import icbm.classic.content.blast.Blast;
import icbm.classic.lib.capability.emp.CapabilityEMP;
import icbm.classic.lib.capability.emp.CapabilityEmpInventory;
import icbm.classic.lib.energy.system.EnergySystem;
import icbm.classic.lib.energy.system.IEnergySystem;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.items.CapabilityItemHandler;

public class BlastEMP
extends Blast {
    private boolean effectEntities = false;
    private boolean effectBlocks = false;

    public BlastEMP setEffectBlocks() {
        this.effectBlocks = true;
        return this;
    }

    public BlastEMP setEffectEntities() {
        this.effectEntities = true;
        return this;
    }

    public BlastEMP clearSetEffectBlocksAndEntities() {
        this.effectBlocks = false;
        this.effectEntities = false;
        return this;
    }

    @Override
    public boolean doExplode(int callCount) {
        if (!this.world().field_72995_K) {
            if (this.effectBlocks && ConfigEMP.ALLOW_TILES) {
                for (int x = (int)(-this.getBlastRadius()); x < (int)this.getBlastRadius(); ++x) {
                    for (int y = (int)(-this.getBlastRadius()); y < (int)this.getBlastRadius(); ++y) {
                        for (int z = (int)(-this.getBlastRadius()); z < (int)this.getBlastRadius(); ++z) {
                            TileEntity tileEntity;
                            BlockPos blockPos = new BlockPos(x + this.location.xi(), y + this.location.yi(), z + this.location.zi());
                            double dist = MathHelper.func_76129_c((float)(x * x + y * y + z * z));
                            if (dist > (double)this.getBlastRadius() || !this.field_77287_j.func_175667_e(blockPos)) continue;
                            if (Math.round(this.location.x() + (double)y) == (long)this.location.yi()) {
                                this.world().func_175688_a(EnumParticleTypes.SMOKE_LARGE, (double)blockPos.func_177958_n() + 0.5, (double)blockPos.func_177956_o() + 0.5, (double)blockPos.func_177952_p() + 0.5, 0.0, 0.0, 0.0, new int[0]);
                            }
                            IBlockState iBlockState = this.field_77287_j.func_180495_p(blockPos);
                            float powerEntity = 1.0f;
                            if (!MinecraftForge.EVENT_BUS.post((Event)new EmpEvent.BlockPre(this, this.field_77287_j, blockPos, iBlockState)) && !ICBMClassicHelpers.hasEmpHandler(iBlockState) && (tileEntity = this.field_77287_j.func_175625_s(blockPos)) != null) {
                                IEnergySystem energySystem;
                                boolean doInventory = true;
                                if (tileEntity.hasCapability(CapabilityEMP.EMP, null)) {
                                    IEMPReceiver receiver = (IEMPReceiver)tileEntity.getCapability(CapabilityEMP.EMP, null);
                                    if (receiver != null) {
                                        powerEntity = this.empEntity(tileEntity, powerEntity, receiver);
                                        doInventory = receiver.shouldEmpSubObjects(this.field_77287_j, tileEntity.func_174877_v().func_177958_n(), tileEntity.func_174877_v().func_177956_o(), tileEntity.func_174877_v().func_177952_p());
                                    }
                                } else if (ConfigEMP.DRAIN_ENERGY_TILES && (energySystem = EnergySystem.getSystem(tileEntity, null)).canSetEnergyDirectly(tileEntity, null)) {
                                    energySystem.setEnergy(tileEntity, null, 0, false);
                                }
                                if (doInventory && tileEntity.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) {
                                    powerEntity = this.empEntity(tileEntity, powerEntity, (IEMPReceiver)new CapabilityEmpInventory.TileInv(tileEntity));
                                }
                            }
                            MinecraftForge.EVENT_BUS.post((Event)new EmpEvent.BlockPost(this, this.field_77287_j, blockPos, iBlockState));
                        }
                    }
                }
            }
            if (this.effectEntities && ConfigEMP.ALLOW_ENTITY) {
                AxisAlignedBB bounds = new AxisAlignedBB(this.location.x() - (double)this.getBlastRadius(), this.location.y() - (double)this.getBlastRadius(), this.location.z() - (double)this.getBlastRadius(), this.location.x() + (double)this.getBlastRadius(), this.location.y() + (double)this.getBlastRadius(), this.location.z() + (double)this.getBlastRadius());
                List entities = this.world().func_72872_a(Entity.class, bounds);
                for (Entity entity : entities) {
                    IEnergySystem energySystem;
                    float powerEntity = 1.0f;
                    if (MinecraftForge.EVENT_BUS.post((Event)new EmpEvent.EntityPre(this, entity))) continue;
                    boolean doInventory = true;
                    if (entity.hasCapability(CapabilityEMP.EMP, null)) {
                        IEMPReceiver receiver = (IEMPReceiver)entity.getCapability(CapabilityEMP.EMP, null);
                        if (receiver != null) {
                            powerEntity = this.empEntity(entity, powerEntity, receiver);
                            doInventory = receiver.shouldEmpSubObjects(this.field_77287_j, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
                        }
                    } else if (ConfigEMP.DRAIN_ENERGY_ENTITY && (energySystem = EnergySystem.getSystem(entity, null)).canSetEnergyDirectly(entity, null)) {
                        energySystem.setEnergy(entity, null, 0, false);
                    }
                    if (doInventory && entity.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) {
                        powerEntity = this.empEntity(entity, powerEntity, (IEMPReceiver)new CapabilityEmpInventory.EntityInv(entity));
                    }
                    MinecraftForge.EVENT_BUS.post((Event)new EmpEvent.EntityPost(this, entity));
                }
            }
            ICBMSounds.EMP.play(this.field_77287_j, this.location.x(), this.location.y(), this.location.z(), 4.0f, (1.0f + (this.world().field_73012_v.nextFloat() - this.world().field_73012_v.nextFloat()) * 0.2f) * 0.7f, true);
        }
        return true;
    }

    protected float empEntity(Entity entity, float powerEntity, IEMPReceiver receiver) {
        if (receiver != null) {
            powerEntity = receiver.applyEmpAction(this.field_77287_j, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, this, powerEntity, true);
        }
        return powerEntity;
    }

    protected float empEntity(TileEntity entity, float powerEntity, IEMPReceiver receiver) {
        if (receiver != null) {
            powerEntity = receiver.applyEmpAction(this.field_77287_j, entity.func_174877_v().func_177958_n(), entity.func_174877_v().func_177956_o(), entity.func_174877_v().func_177952_p(), this, powerEntity, true);
        }
        return powerEntity;
    }
}

