/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.blast.cluster;

import icbm.classic.api.ICBMClassicAPI;
import icbm.classic.api.explosion.IBlast;
import icbm.classic.api.missiles.projectile.IProjectileData;
import icbm.classic.api.reg.IExplosiveCustomization;
import icbm.classic.api.reg.IExplosiveData;
import icbm.classic.content.blast.cluster.BlastCluster;
import icbm.classic.lib.LanguageUtility;
import icbm.classic.lib.saving.NbtSaveHandler;
import java.util.Optional;
import java.util.function.Consumer;
import lombok.Generated;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;

public class ClusterCustomization
implements IExplosiveCustomization {
    public static final ResourceLocation NAME = new ResourceLocation("icbmclassic", "cluster");
    private IProjectileData projectileData;
    private int projectilesToSpawn = 0;
    private int projectilesPerLayer = 10;
    private boolean allowPickupItems = true;
    private static final NbtSaveHandler<ClusterCustomization> SAVE_LOGIC = new NbtSaveHandler().mainRoot().nodeBuildableObject("projectile_data", () -> ICBMClassicAPI.PROJECTILE_DATA_REGISTRY, ClusterCustomization::getProjectileData, ClusterCustomization::setProjectileData).nodeBoolean("projectile_allow_pickup", ClusterCustomization::isAllowPickupItems, ClusterCustomization::setAllowPickupItems).nodeInteger("projectile_count", ClusterCustomization::getProjectilesToSpawn, ClusterCustomization::setProjectilesToSpawn).nodeInteger("projectile_layer", ClusterCustomization::getProjectilesPerLayer, ClusterCustomization::setProjectilesPerLayer).base();

    @Override
    public void collectCustomizationInformation(Consumer<String> collector) {
        String name = null;
        if (this.projectileData != null) {
            name = LanguageUtility.buildToolTipString((ITextComponent)new TextComponentTranslation(this.projectileData.getTranslationKey().toString(), new Object[0]));
        }
        collector.accept(LanguageUtility.buildToolTipString((ITextComponent)new TextComponentTranslation("explosive.icbmclassic:cluster.projectile.name", new Object[]{Optional.ofNullable(name).orElse("???")})));
        collector.accept(LanguageUtility.buildToolTipString((ITextComponent)new TextComponentTranslation("explosive.icbmclassic:cluster.projectile.count", new Object[]{this.projectilesToSpawn})));
        collector.accept(LanguageUtility.buildToolTipString((ITextComponent)new TextComponentTranslation("explosive.icbmclassic:cluster.projectile.layer", new Object[]{this.projectilesPerLayer})));
    }

    @Override
    public ResourceLocation getRegistryName() {
        return NAME;
    }

    @Override
    public void apply(IExplosiveData explosiveData, IBlast blast) {
        if (blast instanceof BlastCluster) {
            ((BlastCluster)blast).setProjectilesToSpawn(this.projectilesToSpawn);
            ((BlastCluster)blast).setProjectilesPerLayer(this.projectilesPerLayer);
            ((BlastCluster)blast).setAllowPickupItem(this.allowPickupItems);
            ((BlastCluster)blast).setProjectileBuilder(integer -> this.projectileData);
        }
    }

    public NBTTagCompound serializeNBT() {
        return SAVE_LOGIC.save(this);
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        SAVE_LOGIC.load(this, nbt);
    }

    @Generated
    public IProjectileData getProjectileData() {
        return this.projectileData;
    }

    @Generated
    public ClusterCustomization setProjectileData(IProjectileData projectileData) {
        this.projectileData = projectileData;
        return this;
    }

    @Generated
    public int getProjectilesToSpawn() {
        return this.projectilesToSpawn;
    }

    @Generated
    public ClusterCustomization setProjectilesToSpawn(int projectilesToSpawn) {
        this.projectilesToSpawn = projectilesToSpawn;
        return this;
    }

    @Generated
    public int getProjectilesPerLayer() {
        return this.projectilesPerLayer;
    }

    @Generated
    public ClusterCustomization setProjectilesPerLayer(int projectilesPerLayer) {
        this.projectilesPerLayer = projectilesPerLayer;
        return this;
    }

    @Generated
    public boolean isAllowPickupItems() {
        return this.allowPickupItems;
    }

    @Generated
    public ClusterCustomization setAllowPickupItems(boolean allowPickupItems) {
        this.allowPickupItems = allowPickupItems;
        return this;
    }
}

