/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.entity;

import icbm.classic.lib.world.IProjectileBlockInteraction;
import icbm.classic.lib.world.ProjectileBlockInteraction;
import io.netty.buffer.ByteBuf;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;

@Deprecated
public class EntityFragments
extends Entity
implements IEntityAdditionalSpawnData {
    private BlockPos inTilePosition = new BlockPos(0, 0, 0);
    private IBlockState inTile;
    public EntityLivingBase shootingEntity;
    public boolean isExplosive;
    public boolean isAnvil;
    private boolean inGround = false;
    private boolean isExploding = false;
    public int arrowShake = 0;
    private int ticksInAir = 0;
    public int damage = 11;
    public boolean flatDamage = false;
    public boolean arrowCritical = false;
    public float explosionSize = 1.5f;

    public EntityFragments(World par1World) {
        super(par1World);
        this.func_70105_a(0.5f, 0.5f);
    }

    public EntityFragments(World par1World, double x, double y, double z, boolean isExplosive, boolean isAnvil) {
        super(par1World);
        this.func_70107_b(x, y, z);
        this.isExplosive = isExplosive;
        this.isAnvil = isAnvil;
        if (this.isAnvil) {
            this.func_70105_a(1.0f, 1.0f);
            this.damage = 30;
        } else {
            this.func_70105_a(0.5f, 0.5f);
        }
    }

    public void writeSpawnData(ByteBuf data) {
        data.writeBoolean(this.isExplosive);
        data.writeBoolean(this.isAnvil);
    }

    public void readSpawnData(ByteBuf data) {
        this.isExplosive = data.readBoolean();
        this.isAnvil = data.readBoolean();
    }

    protected void func_70088_a() {
    }

    public String func_70005_c_() {
        return "Fragments";
    }

    public void setArrowHeading(double vecX, double vecY, double vecZ, float scale, float random) {
        float mag = MathHelper.func_76133_a((double)(vecX * vecX + vecY * vecY + vecZ * vecZ));
        vecX /= (double)mag;
        vecY /= (double)mag;
        vecZ /= (double)mag;
        vecX += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)random;
        vecY += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)random;
        vecZ += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)random;
        this.field_70159_w = vecX *= (double)scale;
        this.field_70181_x = vecY *= (double)scale;
        this.field_70179_y = vecZ *= (double)scale;
        float var10 = MathHelper.func_76133_a((double)(vecX * vecX + vecZ * vecZ));
        this.field_70126_B = this.field_70177_z = (float)(Math.atan2(vecX, vecZ) * 180.0 / Math.PI);
        this.field_70127_C = this.field_70125_A = (float)(Math.atan2(vecY, var10) * 180.0 / Math.PI);
    }

    public void func_70016_h(double par1, double par3, double par5) {
        this.field_70159_w = par1;
        this.field_70181_x = par3;
        this.field_70179_y = par5;
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float var7 = MathHelper.func_76133_a((double)(par1 * par1 + par5 * par5));
            this.field_70126_B = this.field_70177_z = (float)(Math.atan2(par1, par5) * 180.0 / Math.PI);
            this.field_70127_C = this.field_70125_A = (float)(Math.atan2(par3, var7) * 180.0 / Math.PI);
            this.field_70127_C = this.field_70125_A;
            this.field_70126_B = this.field_70177_z;
            this.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
        }
    }

    private void explode() {
        if (!this.isExploding && !this.field_70170_p.field_72995_K) {
            this.isExploding = true;
            this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.explosionSize, true);
            this.func_70106_y();
        }
    }

    public void func_70071_h_() {
        AxisAlignedBB axisalignedbb;
        IBlockState iblockstate;
        super.func_70071_h_();
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float f = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
            this.field_70177_z = (float)(MathHelper.func_181159_b((double)this.field_70159_w, (double)this.field_70179_y) * 57.29577951308232);
            this.field_70125_A = (float)(MathHelper.func_181159_b((double)this.field_70181_x, (double)f) * 57.29577951308232);
            this.field_70126_B = this.field_70177_z;
            this.field_70127_C = this.field_70125_A;
        }
        if ((iblockstate = this.field_70170_p.func_180495_p(this.inTilePosition)).func_185904_a() != Material.field_151579_a && (axisalignedbb = iblockstate.func_185890_d((IBlockAccess)this.field_70170_p, this.inTilePosition)) != Block.field_185506_k && axisalignedbb.func_186670_a(this.inTilePosition).func_72318_a(new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v))) {
            this.inGround = true;
        }
        if (this.arrowShake > 0) {
            --this.arrowShake;
        }
        if (this.inGround) {
            if (iblockstate != this.inTile && !this.field_70170_p.func_184143_b(this.func_174813_aQ().func_186662_g(0.05))) {
                this.inGround = false;
                this.field_70159_w *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
                this.field_70181_x *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
                this.field_70179_y *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
                this.ticksInAir = 0;
            } else {
                this.onImpactGround();
            }
        } else {
            Entity entity;
            ++this.ticksInAir;
            Vec3d start = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            Vec3d end = new Vec3d(this.field_70165_t + this.field_70159_w * 2.0, this.field_70163_u + this.field_70181_x * 2.0, this.field_70161_v + this.field_70179_y * 2.0);
            RayTraceResult raytraceresult = this.field_70170_p.func_147447_a(start, end, false, true, false);
            start = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            end = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
            if (raytraceresult != null) {
                end = new Vec3d(raytraceresult.field_72307_f.field_72450_a, raytraceresult.field_72307_f.field_72448_b, raytraceresult.field_72307_f.field_72449_c);
            }
            if ((entity = this.findEntityOnPath(start, end)) != null) {
                raytraceresult = new RayTraceResult(entity);
            }
            if (raytraceresult != null && !ForgeEventFactory.onProjectileImpact((Entity)this, (RayTraceResult)raytraceresult)) {
                this.onHit(raytraceresult);
            }
            this.field_70165_t += this.field_70159_w;
            this.field_70163_u += this.field_70181_x;
            this.field_70161_v += this.field_70179_y;
            float flatMag = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
            this.field_70177_z = (float)(MathHelper.func_181159_b((double)this.field_70159_w, (double)this.field_70179_y) * 57.29577951308232);
            this.field_70125_A = (float)(MathHelper.func_181159_b((double)this.field_70181_x, (double)flatMag) * 57.29577951308232);
            while (this.field_70125_A - this.field_70127_C < -180.0f) {
                this.field_70127_C -= 360.0f;
            }
            while (this.field_70125_A - this.field_70127_C >= 180.0f) {
                this.field_70127_C += 360.0f;
            }
            while (this.field_70177_z - this.field_70126_B < -180.0f) {
                this.field_70126_B -= 360.0f;
            }
            while (this.field_70177_z - this.field_70126_B >= 180.0f) {
                this.field_70126_B += 360.0f;
            }
            this.field_70125_A = this.field_70127_C + (this.field_70125_A - this.field_70127_C) * 0.2f;
            this.field_70177_z = this.field_70126_B + (this.field_70177_z - this.field_70126_B) * 0.2f;
            float motionModifier = 0.99f;
            if (this.func_70090_H()) {
                float motionMultiplier = 0.25f;
                for (int i = 0; i < 4; ++i) {
                    this.field_70170_p.func_175688_a(EnumParticleTypes.WATER_BUBBLE, this.field_70165_t - this.field_70159_w * (double)motionMultiplier, this.field_70163_u - this.field_70181_x * (double)motionMultiplier, this.field_70161_v - this.field_70179_y * (double)motionMultiplier, this.field_70159_w, this.field_70181_x, this.field_70179_y, new int[0]);
                }
                motionModifier = 0.6f;
            }
            if (this.func_70026_G()) {
                this.func_70066_B();
            }
            this.field_70159_w *= (double)motionModifier;
            this.field_70181_x *= (double)motionModifier;
            this.field_70179_y *= (double)motionModifier;
            if (!this.func_189652_ae()) {
                this.field_70181_x -= (double)0.05f;
            }
            this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            this.func_145775_I();
        }
    }

    protected double getDamage(float speed) {
        if (this.flatDamage) {
            return this.damage;
        }
        return (double)speed * (double)this.damage;
    }

    protected boolean canAttack(Entity entity) {
        return entity != null && entity.func_70089_S();
    }

    protected void onHit(RayTraceResult raytraceResultIn) {
        Entity entity = raytraceResultIn.field_72308_g;
        if (entity != null) {
            if (!this.canAttack(entity)) {
                this.func_70106_y();
                return;
            }
            float speed = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y));
            int damageScaled = MathHelper.func_76143_f((double)this.getDamage(speed));
            DamageSource damagesource = new EntityDamageSourceIndirect("arrow", (Entity)this, (Entity)this.shootingEntity).func_76349_b();
            this.onImpactEntity(entity);
            if (this.func_70027_ad() && !(entity instanceof EntityEnderman)) {
                entity.func_70015_d(5);
            }
            if (entity.func_70097_a(damagesource, (float)damageScaled)) {
                if (!(entity instanceof EntityEnderman)) {
                    this.func_70106_y();
                }
            } else {
                this.field_70159_w *= (double)-0.1f;
                this.field_70181_x *= (double)-0.1f;
                this.field_70179_y *= (double)-0.1f;
                this.field_70177_z += 180.0f;
                this.field_70126_B += 180.0f;
                this.ticksInAir = 0;
                if (!this.field_70170_p.field_72995_K && this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y < (double)0.001f) {
                    this.func_70106_y();
                }
            }
        } else {
            this.inTilePosition = raytraceResultIn.func_178782_a();
            this.inTile = this.field_70170_p.func_180495_p(this.inTilePosition);
            IProjectileBlockInteraction.EnumHitReactions reaction = ProjectileBlockInteraction.handleSpecialInteraction(this.field_70170_p, this.inTilePosition, raytraceResultIn.field_72307_f, raytraceResultIn.field_178784_b, this.inTile, this);
            if (reaction.stop) {
                return;
            }
            this.field_70159_w = (float)(raytraceResultIn.field_72307_f.field_72450_a - this.field_70165_t);
            this.field_70181_x = (float)(raytraceResultIn.field_72307_f.field_72448_b - this.field_70163_u);
            this.field_70179_y = (float)(raytraceResultIn.field_72307_f.field_72449_c - this.field_70161_v);
            float f2 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y));
            this.field_70165_t -= this.field_70159_w / (double)f2 * (double)0.05f;
            this.field_70163_u -= this.field_70181_x / (double)f2 * (double)0.05f;
            this.field_70161_v -= this.field_70179_y / (double)f2 * (double)0.05f;
            this.func_184185_a(SoundEvents.field_187731_t, 1.0f, 1.2f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
            this.inGround = true;
            this.arrowShake = 7;
            if (this.inTile.func_185904_a() != Material.field_151579_a) {
                this.inTile.func_177230_c().func_180634_a(this.field_70170_p, this.inTilePosition, this.inTile, (Entity)this);
            }
        }
    }

    protected void onImpactEntity(Entity entity) {
        if (this.isExplosive) {
            this.explode();
        } else {
            this.playImpactAudio();
        }
    }

    protected void onImpactGround() {
        if (this.isExplosive) {
            this.explode();
        } else {
            this.playImpactAudio();
            this.func_70106_y();
        }
    }

    protected void playImpactAudio() {
        if (this.field_70170_p.field_73012_v.nextFloat() > 0.5f) {
            if (this.isAnvil) {
                this.field_70170_p.func_184134_a(this.field_70165_t, (double)((int)this.field_70163_u), (double)((int)this.field_70161_v), SoundEvents.field_187686_e, SoundCategory.BLOCKS, 1.0f, 1.0f, true);
            } else {
                this.func_184185_a(SoundEvents.field_187731_t, 1.0f, 1.2f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
            }
        }
    }

    @Nullable
    protected Entity findEntityOnPath(Vec3d start, Vec3d end) {
        Entity resultEntity = null;
        List entityList = this.field_70170_p.func_175674_a((Entity)this, this.func_174813_aQ().func_72321_a(this.field_70159_w * 1.2, this.field_70181_x * 1.2, this.field_70179_y * 1.2).func_186662_g(1.0), e -> e.func_70067_L());
        double d0 = 0.0;
        for (int i = 0; i < entityList.size(); ++i) {
            double d1;
            AxisAlignedBB axisalignedbb;
            RayTraceResult raytraceresult;
            Entity currentEntity = (Entity)entityList.get(i);
            if (currentEntity instanceof EntityFragments || this.ticksInAir < 5 || (raytraceresult = (axisalignedbb = currentEntity.func_174813_aQ().func_186662_g((double)0.3f)).func_72327_a(start, end)) == null || !((d1 = start.func_72436_e(raytraceresult.field_72307_f)) < d0) && d0 != 0.0) continue;
            resultEntity = currentEntity;
            d0 = d1;
        }
        return resultEntity;
    }

    public void func_70014_b(NBTTagCompound nbt) {
        nbt.func_74774_a("shake", (byte)this.arrowShake);
        nbt.func_74757_a("isExplosive", this.isExplosive);
    }

    public void func_70037_a(NBTTagCompound nbt) {
        this.arrowShake = nbt.func_74771_c("shake") & 0xFF;
        this.isExplosive = nbt.func_74767_n("isExplosive");
    }

    public void func_70108_f(Entity par1Entity) {
        super.func_70108_f(par1Entity);
        if (this.isExplosive && this.field_70173_aa < 40) {
            this.explode();
        }
    }
}

