/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.entity.flyingblock;

import io.netty.buffer.ByteBuf;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.MoverType;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;

public class EntityFlyingBlock
extends Entity
implements IEntityAdditionalSpawnData {
    public static final float GRAVITY_DEFAULT = 0.045f;
    private IBlockState blockState;
    public float yawChange = 0.0f;
    public float pitchChange = 0.0f;
    public float gravity = 0.045f;

    public EntityFlyingBlock(World world) {
        super(world);
        this.field_70173_aa = 0;
        this.field_70156_m = true;
        this.field_70178_ae = true;
        this.func_70105_a(0.98f, 0.98f);
    }

    public void restoreGravity() {
        this.gravity = 0.045f;
    }

    public IBlockState getBlockState() {
        if (this.blockState == null) {
            this.blockState = Blocks.field_150348_b.func_176223_P();
        }
        return this.blockState;
    }

    public String func_70005_c_() {
        return "Flying Block [" + this.getBlockState() + ", " + this.hashCode() + "]";
    }

    public void writeSpawnData(ByteBuf data) {
        ByteBufUtils.writeTag((ByteBuf)data, (NBTTagCompound)NBTUtil.func_190009_a((NBTTagCompound)new NBTTagCompound(), (IBlockState)this.getBlockState()));
        data.writeFloat(this.gravity);
        data.writeFloat(this.yawChange);
        data.writeFloat(this.pitchChange);
    }

    public void readSpawnData(ByteBuf data) {
        this.blockState = NBTUtil.func_190008_d((NBTTagCompound)ByteBufUtils.readTag((ByteBuf)data));
        this.gravity = data.readFloat();
        this.yawChange = data.readFloat();
        this.pitchChange = data.readFloat();
    }

    protected void func_70088_a() {
    }

    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K) {
            if (this.blockState == null || this.field_70173_aa > 1200) {
                this.placeBlockIntoWorld();
                return;
            }
            if (this.field_70163_u > 400.0 || this.field_70163_u < -40.0) {
                this.func_70106_y();
                return;
            }
            if (this.field_70122_E && this.field_70173_aa > 20) {
                this.placeBlockIntoWorld();
                return;
            }
        }
        this.field_70181_x -= (double)this.gravity;
        this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
        if (this.field_70132_H) {
            this.func_70107_b(this.field_70165_t, (this.func_174813_aQ().field_72338_b + this.func_174813_aQ().field_72337_e) / 2.0, this.field_70161_v);
        }
        if (this.yawChange > 0.0f) {
            this.field_70177_z += this.yawChange;
            this.yawChange -= 2.0f;
        }
        if (this.pitchChange > 0.0f) {
            this.field_70125_A += this.pitchChange;
            this.pitchChange -= 2.0f;
        }
        ++this.field_70173_aa;
    }

    public void placeBlockIntoWorld() {
        int k;
        int j;
        int i;
        BlockPos pos;
        IBlockState currentState;
        if (!this.field_70170_p.field_72995_K && (currentState = this.field_70170_p.func_180495_p(pos = new BlockPos(i = MathHelper.func_76128_c((double)this.field_70165_t), j = MathHelper.func_76128_c((double)this.field_70163_u), k = MathHelper.func_76128_c((double)this.field_70161_v)))).func_177230_c().func_176200_f((IBlockAccess)this.field_70170_p, pos)) {
            this.field_70170_p.func_180501_a(pos, this.getBlockState(), 3);
        }
        this.func_70106_y();
    }

    public AxisAlignedBB func_70114_g(Entity par1Entity) {
        if (par1Entity instanceof EntityLiving && this.getBlockState() != null && !(this.getBlockState().func_177230_c() instanceof IFluidBlock) && (this.field_70159_w > 2.0 || this.field_70181_x > 2.0 || this.field_70179_y > 2.0)) {
            int damage = (int)(1.2 * (Math.abs(this.field_70159_w) + Math.abs(this.field_70181_x) + Math.abs(this.field_70179_y)));
            ((EntityLiving)par1Entity).func_70097_a(DamageSource.field_82729_p, (float)damage);
        }
        return null;
    }

    protected void func_70014_b(NBTTagCompound nbttagcompound) {
        if (this.blockState != null) {
            nbttagcompound.func_74782_a("blockState", (NBTBase)NBTUtil.func_190009_a((NBTTagCompound)new NBTTagCompound(), (IBlockState)this.blockState));
        }
        nbttagcompound.func_74776_a("gravity", this.gravity);
    }

    protected void func_70037_a(NBTTagCompound nbttagcompound) {
        if (nbttagcompound.func_74764_b("blockState")) {
            this.blockState = NBTUtil.func_190008_d((NBTTagCompound)nbttagcompound.func_74775_l("blockState"));
        }
        this.gravity = nbttagcompound.func_74760_g("gravity");
    }

    public boolean func_70104_M() {
        return true;
    }

    protected boolean func_70041_e_() {
        return true;
    }

    public boolean func_70067_L() {
        return true;
    }

    void setBlockState(IBlockState blockState) {
        this.blockState = blockState;
    }
}

