/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.items;

import icbm.classic.api.ICBMClassicAPI;
import icbm.classic.api.reg.IExplosiveData;
import icbm.classic.content.blocks.explosive.ItemBlockExplosive;
import icbm.classic.content.entity.EntityBombCart;
import icbm.classic.content.reg.BlockReg;
import icbm.classic.lib.capability.ex.CapabilityExplosiveStack;
import icbm.classic.prefab.item.ItemBase;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRailBase;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class ItemBombCart
extends ItemBase {
    public ItemBombCart() {
        this.func_77625_d(3);
        this.func_77627_a(true);
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable NBTTagCompound nbt) {
        CapabilityExplosiveStack capabilityExplosive = new CapabilityExplosiveStack(stack);
        if (nbt != null) {
            capabilityExplosive.deserializeNBT(nbt);
        }
        return capabilityExplosive;
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        IBlockState iblockstate = worldIn.func_180495_p(pos);
        if (!BlockRailBase.func_176563_d((IBlockState)iblockstate)) {
            return EnumActionResult.FAIL;
        }
        ItemStack itemstack = player.func_184586_b(hand);
        if (!worldIn.field_72995_K) {
            BlockRailBase.EnumRailDirection railBlock = iblockstate.func_177230_c() instanceof BlockRailBase ? ((BlockRailBase)iblockstate.func_177230_c()).getRailDirection((IBlockAccess)worldIn, pos, iblockstate, null) : BlockRailBase.EnumRailDirection.NORTH_SOUTH;
            double d0 = 0.0;
            if (railBlock.func_177018_c()) {
                d0 = 0.5;
            }
            EntityBombCart entityminecart = new EntityBombCart(worldIn, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.0625 + d0, (double)pos.func_177952_p() + 0.5, itemstack);
            if (itemstack.func_82837_s()) {
                entityminecart.func_96094_a(itemstack.func_82833_r());
            }
            worldIn.func_72838_d((Entity)entityminecart);
        }
        itemstack.func_190918_g(1);
        return EnumActionResult.SUCCESS;
    }

    public int func_77647_b(int damage) {
        return damage;
    }

    public String func_77667_c(ItemStack itemstack) {
        IExplosiveData data = ICBMClassicAPI.EXPLOSIVE_REGISTRY.getExplosiveData(itemstack.func_77952_i());
        if (data != null) {
            return "bombcart." + data.getRegistryName();
        }
        return "bombcart";
    }

    public String func_77658_a() {
        return "bombcart";
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (tab == this.func_77640_w() || tab == CreativeTabs.field_78027_g) {
            for (int id : ICBMClassicAPI.EX_MINECART_REGISTRY.getExplosivesIDs()) {
                items.add((Object)new ItemStack((Item)this, 1, id));
            }
        }
    }

    @Override
    protected boolean hasDetailedInfo(ItemStack stack, EntityPlayer player) {
        return true;
    }

    protected void getDetailedInfo(ItemStack stack, EntityPlayer player, List list) {
        ((ItemBlockExplosive)Item.func_150898_a((Block)BlockReg.blockExplosive)).getDetailedInfo(stack, player, list);
    }
}

