/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.missile;

import icbm.classic.ICBMClassic;
import icbm.classic.api.missiles.parts.IBuildableObject;
import icbm.classic.api.reg.obj.IBuilderRegistry;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import lombok.Generated;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class BuildableObjectRegistry<Part extends IBuildableObject>
implements IBuilderRegistry<Part> {
    private final Map<ResourceLocation, Supplier<Part>> builders = new HashMap<ResourceLocation, Supplier<Part>>();
    private boolean isLocked = false;
    private final String name;

    @Override
    public void register(ResourceLocation key, Supplier<Part> builder) {
        if (this.isLocked) {
            throw new RuntimeException(this.name + ": mod '" + FMLCommonHandler.instance().getModName() + "' attempted to do a late registry");
        }
        if (this.builders.containsKey(key)) {
            throw new RuntimeException(this.name + ": mod '" + FMLCommonHandler.instance().getModName() + "' attempted to override '" + key + "'. This method does not allow replacing existing registries. See implementing class for override call.");
        }
        this.builders.put(key, builder);
    }

    public void overrideRegistry(ResourceLocation key, Supplier<Part> builder) {
        if (this.isLocked) {
            throw new RuntimeException(this.name + ":mod '" + FMLCommonHandler.instance().getModName() + "' attempted to do a late registry");
        }
        ICBMClassic.logger().info(this.name + ":'" + key + "' is being overridden by " + FMLCommonHandler.instance().getModName());
        this.builders.put(key, builder);
    }

    @Override
    public Part build(ResourceLocation name) {
        return (Part)((IBuildableObject)Optional.ofNullable(this.builders.get(name)).map(Supplier::get).orElse(null));
    }

    public void lock() {
        this.isLocked = true;
    }

    @Generated
    public BuildableObjectRegistry(String name) {
        this.name = name;
    }

    @Generated
    public boolean isLocked() {
        return this.isLocked;
    }
}

